/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Queryable;
import dyvil.collection.SizedIterable;
import dyvil.collection.view.MapKeys;
import dyvil.collection.view.MapValues;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import dyvil.ref.ObjectRef;
import dyvil.util.Option;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Deprecated(replacements={"java.util.Map"})
@LiteralConvertible.FromArray
@LiteralConvertible.FromMap
public interface Map<K, V>
extends SizedIterable<Entry<K, V>>,
Serializable {
    public static final @NonNull String EMPTY_STRING = "[]";
    public static final @NonNull String START_STRING = "[";
    public static final @NonNull String END_STRING = "]";
    public static final @NonNull String ENTRY_SEPARATOR_STRING = ", ";
    public static final @NonNull String KEY_VALUE_SEPARATOR_STRING = ": ";

    public static <K, V> @NonNull ImmutableMap<K, V> empty() {
        return ImmutableMap.apply();
    }

    public static <K, V> @NonNull MutableMap<K, V> apply() {
        return MutableMap.apply();
    }

    public static <K, V> @NonNull ImmutableMap<K, V> singleton(K key, V value) {
        return ImmutableMap.singleton(key, value);
    }

    public static <K, V> @NonNull ImmutableMap<K, V> apply(@NonNull Entry<? extends K, ? extends V> entry) {
        return ImmutableMap.apply(entry);
    }

    @SafeVarargs
    public static <K, V> @NonNull ImmutableMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return ImmutableMap.apply(entries);
    }

    public static <K, V> @NonNull ImmutableMap<K, V> apply(K @NonNull [] keys, V @NonNull [] values) {
        return ImmutableMap.apply(keys, values);
    }

    public boolean isImmutable();

    @Override
    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean isSorted() {
        return this.size() < 2 || Collection.iteratorSorted(this.keyIterator());
    }

    default public boolean isSorted(@NonNull Comparator<? super K> comparator) {
        return this.size() < 2 || Collection.iteratorSorted(this.keyIterator(), comparator);
    }

    @Override
    public @NonNull Iterator<@NonNull Entry<K, V>> iterator();

    @Override
    default public @NonNull Spliterator<@NonNull Entry<K, V>> spliterator() {
        Spliterator<Entry<K, V>> spliterator = Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
        spliterator.getClass();
        return spliterator;
    }

    default public @NonNull Stream<@NonNull Entry<K, V>> stream() {
        Stream<Entry<K, V>> stream = StreamSupport.stream(this.spliterator(), false);
        stream.getClass();
        return stream;
    }

    default public @NonNull Stream<@NonNull Entry<K, V>> parallelStream() {
        Stream<Entry<K, V>> stream = StreamSupport.stream(this.spliterator(), true);
        stream.getClass();
        return stream;
    }

    default public @NonNull Queryable<K> keys() {
        return new MapKeys(this);
    }

    public @NonNull Iterator<K> keyIterator();

    default public @NonNull Spliterator<K> keySpliterator() {
        Spliterator<K> spliterator = Spliterators.spliterator(this.keyIterator(), (long)this.size(), 0);
        spliterator.getClass();
        return spliterator;
    }

    default public @NonNull Stream<K> keyStream() {
        Stream<K> stream = StreamSupport.stream(this.keySpliterator(), false);
        stream.getClass();
        return stream;
    }

    default public @NonNull Stream<K> parallelKeyStream() {
        Stream<K> stream = StreamSupport.stream(this.keySpliterator(), true);
        stream.getClass();
        return stream;
    }

    default public @NonNull Queryable<V> values() {
        return new MapValues(this);
    }

    public @NonNull Iterator<V> valueIterator();

    default public @NonNull Spliterator<V> valueSpliterator() {
        Spliterator<V> spliterator = Spliterators.spliterator(this.valueIterator(), (long)this.size(), 0);
        spliterator.getClass();
        return spliterator;
    }

    default public @NonNull Stream<V> valueStream() {
        Stream<V> stream = StreamSupport.stream(this.valueSpliterator(), false);
        stream.getClass();
        return stream;
    }

    default public @NonNull Stream<V> parallelValueStream() {
        Stream<V> stream = StreamSupport.stream(this.valueSpliterator(), true);
        stream.getClass();
        return stream;
    }

    @Override
    default public void forEach(@NonNull Consumer<? super @NonNull Entry<K, V>> action) {
        for (Entry e : this) {
            action.accept(e);
        }
    }

    @Override
    default public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        for (Entry e : this) {
            action.accept(e.getKey(), e.getValue());
        }
    }

    default public void forEachKey(@NonNull Consumer<? super K> action) {
        for (Entry e : this) {
            action.accept(e.getKey());
        }
    }

    default public void forEachValue(@NonNull Consumer<? super V> action) {
        for (Entry e : this) {
            action.accept(e.getValue());
        }
    }

    default public boolean allMatch(@NonNull BiPredicate<? super K, ? super V> predicate) {
        for (Entry e : this) {
            if (predicate.test(e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean exists(@NonNull BiPredicate<? super K, ? super V> predicate) {
        for (Entry e : this) {
            if (!predicate.test(e.getKey(), e.getValue())) continue;
            return true;
        }
        return false;
    }

    default public @Nullable Entry<K, V> find(@NonNull BiPredicate<? super K, ? super V> predicate) {
        for (Entry e : this) {
            if (!predicate.test(e.getKey(), e.getValue())) continue;
            return e;
        }
        return null;
    }

    default public boolean containsKey(@Primitive Object key) {
        return Collection.iteratorContains(this.keyIterator(), key);
    }

    default public boolean containsValue(@Primitive Object value) {
        return Collection.iteratorContains(this.valueIterator(), value);
    }

    default public boolean contains(@Primitive Object key, @Primitive Object value) {
        for (Entry e : this) {
            if (!Objects.equals(key, e.getKey()) || !Objects.equals(value, e.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> entry) {
        return this.contains(entry.getKey(), entry.getValue());
    }

    default public @Nullable V subscript(@Primitive Object key) {
        return this.get(key);
    }

    default public @NonNull ObjectRef<V> subscript_$amp(K key) {
        return new 1(this, key);
    }

    default public @Nullable V get(@Primitive Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    public @Nullable Entry<K, V> getEntry(@Primitive Object var1);

    public @NonNull Option<V> getOption(@Primitive Object var1);

    public @NonNull Map<K, V> withEntry(K var1, V var2);

    public @NonNull Map<K, V> withEntry(@NonNull Entry<? extends K, ? extends V> var1);

    public @NonNull Map<K, V> union(@NonNull Map<? extends K, ? extends V> var1);

    public @NonNull Map<K, V> removed(@Primitive Object var1, @Primitive Object var2);

    public @NonNull Map<K, V> removed(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> var1);

    public @NonNull Map<K, V> keyRemoved(@Primitive Object var1);

    public @NonNull Map<K, V> valueRemoved(@Primitive Object var1);

    public @NonNull Map<K, V> difference(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> var1);

    public @NonNull Map<K, V> keyDifference(@NonNull Collection<? extends @Primitive Object> var1);

    public <NK> @NonNull Map<NK, V> keyMapped(@NonNull Function<? super K, ? extends NK> var1);

    public <NK> @NonNull Map<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> var1);

    public <NV> @NonNull Map<K, NV> valueMapped(@NonNull Function<? super V, ? extends NV> var1);

    public <NV> @NonNull Map<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> var1);

    public <NK, NV> @NonNull Map<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> var1);

    public <NK, NV> @NonNull Map<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> var1);

    public @NonNull Map<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> var1);

    public @NonNull Map<K, V> filteredByKey(@NonNull Predicate<? super K> var1);

    public @NonNull Map<K, V> filteredByValue(@NonNull Predicate<? super V> var1);

    public @NonNull Map<V, K> inverted();

    public void clear();

    public void subscript_$eq(K var1, V var2);

    public @Nullable V put(K var1, V var2);

    public @Nullable V put(@NonNull Entry<? extends K, ? extends V> var1);

    public @Nullable V putIfAbsent(K var1, V var2);

    public @Nullable V putIfAbsent(@NonNull Entry<? extends K, ? extends V> var1);

    public void putAll(@NonNull Map<? extends K, ? extends V> var1);

    public boolean replace(K var1, V var2, V var3);

    public @Nullable V replace(K var1, V var2);

    public @Nullable V replace(@NonNull Entry<? extends K, ? extends V> var1);

    public @Nullable V remap(@Primitive Object var1, K var2);

    public @Nullable V removeKey(@Primitive Object var1);

    public boolean removeValue(@Primitive Object var1);

    public boolean remove(@Primitive Object var1, @Primitive Object var2);

    public boolean remove(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> var1);

    public boolean removeKeys(@NonNull Collection<? extends @Primitive Object> var1);

    public boolean removeAll(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> var1);

    public void mapKeys(@NonNull Function<? super K, ? extends K> var1);

    public void mapKeys(@NonNull BiFunction<? super K, ? super V, ? extends K> var1);

    public void mapValues(@NonNull Function<? super V, ? extends V> var1);

    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> var1);

    public void mapEntries(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends K, ? extends V>> var1);

    public void flatMap(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>>> var1);

    public void filter(@NonNull BiPredicate<? super K, ? super V> var1);

    public void filterByKey(@NonNull Predicate<? super K> var1);

    public void filterByValue(@NonNull Predicate<? super V> var1);

    default public @NonNull Entry<K, V> @NonNull [] toArray() {
        Entry[] entryArray = new Entry[this.size()];
        this.toArray(0, entryArray);
        return entryArray;
    }

    default public void toArray(@NonNull Entry<K, V> @NonNull [] store) {
        this.toArray(0, store);
    }

    default public void toArray(int index, @NonNull Entry<K, V> @NonNull [] store) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry e;
            store[index] = e = (Entry)iterator.next();
            ++index;
        }
    }

    default public @Primitive Object @NonNull [] toKeyArray() {
        Object[] objectArray = new Object[this.size()];
        this.toKeyArray(0, objectArray);
        return objectArray;
    }

    default public K @NonNull [] toKeyArray(@NonNull Class<K> keyType) {
        Object[] objectArray = ObjectArray.ofType(this.size(), keyType);
        this.toKeyArray(0, objectArray);
        return objectArray;
    }

    default public void toKeyArray(@Primitive Object @NonNull [] store) {
        this.toKeyArray(0, store);
    }

    default public void toKeyArray(int index, @Primitive Object @NonNull [] store) {
        Iterator<K> iterator = this.keyIterator();
        while (iterator.hasNext()) {
            K k = iterator.next();
            store[index] = k;
            ++index;
        }
    }

    default public @Primitive Object @NonNull [] toValueArray() {
        Object[] objectArray = new Object[this.size()];
        this.toValueArray(0, objectArray);
        return objectArray;
    }

    default public V @NonNull [] toValueArray(@NonNull Class<V> valueType) {
        Object[] objectArray = ObjectArray.ofType(this.size(), valueType);
        this.toValueArray(0, objectArray);
        return objectArray;
    }

    default public void toValueArray(@Primitive Object @NonNull [] store) {
        this.toValueArray(0, store);
    }

    default public void toValueArray(int index, @Primitive Object @NonNull [] store) {
        Iterator<V> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            V v = iterator.next();
            store[index] = v;
            ++index;
        }
    }

    public @NonNull Map<K, V> copy();

    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy();

    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy(int var1);

    public @NonNull MutableMap<K, V> mutable();

    public @NonNull MutableMap<K, V> mutableCopy();

    public @NonNull ImmutableMap<K, V> immutable();

    public @NonNull ImmutableMap<K, V> immutableCopy();

    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder();

    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder(int var1);

    public @NonNull ImmutableMap<K, V> view();

    public @NonNull java.util.Map<K, V> toJava();

    public @NonNull String toString();

    default public void toString(@NonNull StringBuilder builder) {
        this.toString(builder, START_STRING, ENTRY_SEPARATOR_STRING, KEY_VALUE_SEPARATOR_STRING, END_STRING);
    }

    default public @NonNull String toString(@NonNull String open, @NonNull String entrySeparator, @NonNull String keyValueSeparator, @NonNull String close) {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, open, entrySeparator, keyValueSeparator, close);
        String string = builder.toString();
        string.getClass();
        string.getClass();
        return string;
    }

    default public void toString(@NonNull StringBuilder builder, @NonNull String open, @NonNull String entrySeparator, @NonNull String keyValueSeparator, @NonNull String close) {
        builder.append(open);
        if (this.isEmpty()) {
            builder.append(close);
            return;
        }
        Iterator<Entry<K, V>> iterator = this.iterator();
        Entry<K, V> entry = iterator.next();
        builder.append(entry.getKey()).append(keyValueSeparator).append(entry.getValue());
        while (iterator.hasNext()) {
            entry = iterator.next();
            builder.append(entrySeparator).append(entry.getKey()).append(keyValueSeparator).append(entry.getValue());
        }
        builder.append(close);
    }

    public boolean equals(@Primitive Object var1);

    public int hashCode();

    public static @NonNull String mapToString(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> map) {
        StringBuilder builder = new StringBuilder();
        map.toString(builder);
        String string = builder.toString();
        string.getClass();
        string.getClass();
        return string;
    }

    public static boolean mapEquals(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> map, @Primitive Object obj) {
        return obj instanceof Map && Map.mapEquals(map, (Map)obj);
    }

    public static boolean mapEquals(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> map, @NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> other) {
        if (map.size() != other.size()) {
            return false;
        }
        for (Entry entry : map) {
            if (other.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public static int mapHashCode(@NonNull Map<? extends @Primitive Object, ? extends @Primitive Object> map) {
        int sum = 0;
        int product = 1;
        for (Entry entry : map) {
            Object keyHash232 = entry.getKey();
            int keyHash232 = keyHash232 != null ? keyHash232.hashCode() : 0;
            Object valueHash232 = entry.getValue();
            int valueHash232 = valueHash232 != null ? valueHash232.hashCode() : 0;
            int hash = keyHash232 * 31 + valueHash232;
            sum += hash;
            product += hash;
        }
        return sum * 31 + product;
    }
}

