/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.collection.Range;
import dyvil.function.Function;
import dyvil.lang.Objects;
import dyvil.ref.ObjectRef;
import dyvil.runtime.DynamicLinker;
import dyvil.runtime.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_List_$__TE____$___")
public class Lists {
    private static void lambda$0(@NonNull Object object, List list) {
        list.add(0, object);
    }

    private static boolean lambda$1(@NonNull Object object, List list) {
        return list.add(object);
    }

    private static boolean lambda$2(@NonNull List list, List list2) {
        return list2.addAll(list);
    }

    private static boolean lambda$3(@NonNull Object object, List list) {
        return list.removeAll(Collections.singleton(object));
    }

    private static boolean lambda$4(@NonNull Collection collection, List list) {
        return list.removeAll(collection);
    }

    private static void lambda$5(@NonNull int n, List list) {
        Lists.rotate(list, n);
    }

    private static void lambda$6(@NonNull Random random, List list) {
        Lists.shuffle(list, random);
    }

    private static void lambda$7(@NonNull Comparator comparator, List list) {
        list.sort(comparator);
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @NonNull List<E> $plus(E lhs, @NonNull List<? extends E> rhs) {
        return Lists.copyWith(rhs, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.lang.Object java.util.List ), (Ljava/util/List;)V)(lhs));
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @NonNull List<E> $plus(@NonNull List<? extends E> lhs, E rhs) {
        return Lists.copyWith(lhs, (Function.Of1<List, boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(java.lang.Object java.util.List ), (Ljava/util/List;)Z)(rhs));
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @NonNull List<E> $plus$plus(@NonNull List<? extends E> lhs, @NonNull List<? extends E> rhs) {
        return Lists.copyWith(lhs, (Function.Of1<List, boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(java.util.List java.util.List ), (Ljava/util/List;)Z)(rhs));
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @NonNull List<E> $minus(@NonNull List<E> lhs, @Primitive Object rhs) {
        return Lists.copyWith(lhs, (Function.Of1<List, boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(java.lang.Object java.util.List ), (Ljava/util/List;)Z)((Object)rhs));
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @NonNull List<E> $minus$minus(@NonNull List<E> lhs, @NonNull Collection<? extends @Primitive Object> rhs) {
        return Lists.copyWith(lhs, (Function.Of1<List, boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(java.util.Collection java.util.List ), (Ljava/util/List;)Z)(rhs));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> empty() {
        List list = Collections.emptyList();
        list.getClass();
        return list;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> of(E element) {
        List<E> list = Collections.singletonList(element);
        list.getClass();
        return list;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> of(E ... elements) {
        return Lists.unmodifiableView(Arrays.asList(elements));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> copyOf(@NonNull Collection<? extends E> c) {
        return Lists.unmodifiableView(new ArrayList<E>(c));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> build(@DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull List<E>, @Primitive Void> configure) {
        ArrayList list = new ArrayList();
        configure.apply(list);
        return Lists.unmodifiableView(list);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> repeat(int n, @DyvilModifiers(value=0x400000L) E element) {
        List<E> list = Collections.nCopies(n, element);
        list.getClass();
        return list;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> generate(int n, @DyvilModifiers(value=0x400000L) @NonNull IntFunction<? extends E> generator) {
        ArrayList<E> list = new ArrayList<E>(n);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            list.add(generator.apply(i));
        }
        return Lists.unmodifiableView(list);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static <E> @Immutable @NonNull List<E> generate(int n, @DyvilModifiers(value=0x400000L) @NonNull Supplier<? extends E> supplier) {
        ArrayList<E> list = new ArrayList<E>(n);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            list.add(supplier.get());
        }
        return Lists.unmodifiableView(list);
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="indexOf")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> int indexOfSubList(List<E> this_, @NonNull List<? extends @Primitive Object> subList) {
        return Collections.indexOfSubList(this_, subList);
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="lastIndexOf")
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> int lastIndexOfSubList(List<E> this_, @NonNull List<? extends @Primitive Object> subList) {
        return Collections.lastIndexOfSubList(this_, subList);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> int binarySearch(List<E> this_, E key, @NonNull Comparator<? super E> comparator) {
        return Collections.binarySearch(this_, key, comparator);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> E subscript(List<E> this_, int index) {
        return this_.get(index);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void subscript_$eq(List<E> this_, int index, E element) {
        this_.set(index, element);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull ObjectRef<E> subscript_$amp(List<E> this_, int index) {
        return new ListRef<E>(this_, index);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> subscript(List<E> this_, @NonNull Range<@NonNull Integer> range) {
        List<E> list = this_.subList(range.first(), range.size());
        list.getClass();
        return list;
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void subscript_$eq(List<E> this_, @NonNull Range<@NonNull Integer> range, @NonNull List<? extends E> values) {
        if (values.size() != range.size()) {
            throw new IllegalArgumentException("range size and list size must be equal");
        }
        Collections.copy(Lists.subscript(this_, range), values);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void subscript_$eq(List<E> this_, @NonNull Range<@NonNull Integer> range, E @NonNull [] values) {
        List<E> list = Arrays.asList(values);
        list.getClass();
        Lists.subscript_$eq(this_, range, list);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void replaceAll(List<E> this_, @Primitive Object oldVal, E newVal) {
        Collections.replaceAll(this_, oldVal, newVal);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void swap(List<E> this_, int i, int j) {
        Collections.swap(this_, i, j);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void reverse(List<E> this_) {
        Collections.reverse(this_);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void rotate(List<E> this_, int distance) {
        Collections.rotate(this_, distance);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void shuffle(List<E> this_) {
        Collections.shuffle(this_);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void shuffle(List<E> this_, @NonNull Random random) {
        Collections.shuffle(this_, random);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> void sort(List<E> this_) {
        this_.sort(null);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> unmodifiableView(List<E> this_) {
        List<E> list = Collections.unmodifiableList(this_);
        list.getClass();
        return list;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> synchronizedView(List<E> this_) {
        List<E> list = Collections.synchronizedList(this_);
        list.getClass();
        return list;
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    private static final <E> @NonNull List<E> copyWith(List<E> this_, @DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull List<E>, @Primitive Void> operation) {
        return Lists.finalizeCopy(this_, Objects.use(Lists.modifiableCopy(this_), operation));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    private static final <E, R> @NonNull List<R> finalizeCopy(List<E> this_, @NonNull List<R> copy) {
        void var1_1;
        return DynamicLinker.linkExtension("isUnmodifiableView", isUnmodifiableView(java.util.Collection<E> ), this_) != false ? Lists.unmodifiableView(copy) : var1_1;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> copy(List<E> this_) {
        return DynamicLinker.linkExtension("isUnmodifiableView", isUnmodifiableView(java.util.Collection<E> ), this_) != false ? Lists.unmodifiableCopy(this_) : Lists.modifiableCopy(this_);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> modifiableCopy(List<E> this_) {
        return new ArrayList<E>(this_);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> unmodifiableCopy(List<E> this_) {
        return Lists.unmodifiableView(new ArrayList<E>(this_));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> filtered(List<E> this_, @NonNull Predicate<? super E> predicate) {
        List list = this_.stream().filter(predicate).collect(Collectors.toList());
        list.getClass();
        return Lists.finalizeCopy(this_, list);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E, R> @NonNull List<R> mapped(List<E> this_, @NonNull Function<? super E, ? extends R> function) {
        List list = this_.stream().map(function).collect(Collectors.toList());
        list.getClass();
        return Lists.finalizeCopy(this_, list);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E, R> @NonNull List<R> flatMapped(List<E> this_, @NonNull Function<? super E, ? extends @NonNull Stream<? extends R>> function) {
        List list = this_.stream().flatMap(function).collect(Collectors.toList());
        list.getClass();
        return Lists.finalizeCopy(this_, list);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> reversed(List<E> this_) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, reverse(java.util.List<E> ), (Ljava/util/List;)V)());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> rotated(List<E> this_, int distance) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(int java.util.List ), (Ljava/util/List;)V)((int)distance));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> shuffled(List<E> this_) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, shuffle(java.util.List<E> ), (Ljava/util/List;)V)());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> shuffled(List<E> this_, @NonNull Random random) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(java.util.Random java.util.List ), (Ljava/util/List;)V)((Random)random));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> sorted(List<E> this_) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, sort(java.util.List<E> ), (Ljava/util/List;)V)());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/List<TE;>;")
    public static final <E> @NonNull List<E> sorted(List<E> this_, @NonNull Comparator<? super E> comparator) {
        return Lists.copyWith(this_, (Function.Of1<List, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(java.util.Comparator java.util.List ), (Ljava/util/List;)V)(comparator));
    }

    @ClassParameters(names={"list", "index"})
    private static class ListRef<E>
    implements ObjectRef<E> {
        protected final @NonNull List<E> list;
        protected final int index;

        public ListRef(@NonNull List<E> list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public E get() {
            return this.list.get(this.index);
        }

        @Override
        public void set(E value) {
            this.list.set(this.index, value);
        }
    }
}

