/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.BidiQueryable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.MutableList;
import dyvil.collection.Range;
import dyvil.lang.LiteralConvertible;
import dyvil.ref.ObjectRef;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;

@Deprecated
@dyvil.annotation.Deprecated(replacements={"java.util.List"})
@LiteralConvertible.FromArray
public interface List<E>
extends Collection<E>,
BidiQueryable<E> {
    public static <E> @NonNull ImmutableList<E> empty() {
        return ImmutableList.apply();
    }

    public static <E> @NonNull MutableList<E> apply() {
        return MutableList.apply();
    }

    public static <E> @NonNull ImmutableList<E> apply(E element) {
        return ImmutableList.apply(element);
    }

    @SafeVarargs
    public static <E> @NonNull ImmutableList<E> apply(E ... elements) {
        return ImmutableList.apply(elements);
    }

    public static <E> @NonNull ImmutableList<E> from(E @NonNull [] array) {
        return ImmutableList.from(array);
    }

    public static <E> @NonNull ImmutableList<E> from(@NonNull Iterable<? extends E> array) {
        return ImmutableList.from(array);
    }

    public static <E> @NonNull ImmutableList<E> from(@NonNull Collection<? extends E> array) {
        return ImmutableList.from(array);
    }

    public static <E> @NonNull ImmutableList<E> repeat(int count, E repeatedValue) {
        return ImmutableList.repeat(count, repeatedValue);
    }

    public static <E> @NonNull ImmutableList<E> generate(int count, @NonNull IntFunction<E> generator) {
        return ImmutableList.generate(count, generator);
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    public @NonNull Iterator<E> reverseIterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 64);
    }

    default public E subscript(int index) {
        return this.get(index);
    }

    default public @NonNull List<E> subscript(@NonNull Range<Integer> range) {
        return this.subList(range.first(), range.size());
    }

    default public @NonNull ObjectRef<E> subscript_$amp(final int index) {
        return new ObjectRef<E>(){

            @Override
            public @Nullable E get() {
                return List.this.get(index);
            }

            @Override
            public void set(E value) {
                List.this.setResizing(index, value);
            }
        };
    }

    public E get(int var1);

    public @NonNull List<E> subList(int var1, int var2);

    @Override
    public @NonNull List<E> added(E var1);

    @Override
    public @NonNull List<E> union(@NonNull Collection<? extends E> var1);

    @Override
    public @NonNull List<E> removed(@Nullable Object var1);

    @Override
    public @NonNull List<E> difference(@NonNull Collection<?> var1);

    @Override
    public @NonNull List<E> intersection(@NonNull Collection<? extends E> var1);

    @Override
    public <R> @NonNull List<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public <R> @NonNull List<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> var1);

    @Override
    public @NonNull List<E> filtered(@NonNull Predicate<? super E> var1);

    public @NonNull List<E> reversed();

    public @NonNull List<E> sorted();

    public @NonNull List<E> sorted(@NonNull Comparator<? super E> var1);

    public @NonNull List<E> distinct();

    public @NonNull List<E> distinct(@NonNull Comparator<? super E> var1);

    @Override
    public void clear();

    default public void ensureCapacity(int minSize) {
    }

    default public void subscript_$eq(int index, E element) {
        this.set(index, element);
    }

    default public void subscript_$eq(@NonNull Range<Integer> range, E @NonNull [] elements) {
        int elementIndex = 0;
        for (int rangeIndex : range) {
            this.subscript_$eq(rangeIndex, elements[elementIndex++]);
        }
    }

    default public void subscript_$eq(@NonNull Range<Integer> range, @NonNull List<? extends E> elements) {
        int elementIndex = 0;
        for (int rangeIndex : range) {
            this.subscript_$eq(rangeIndex, elements.subscript(elementIndex++));
        }
    }

    public @Nullable E set(int var1, E var2);

    public @Nullable E setResizing(int var1, E var2);

    public void insert(int var1, E var2);

    default public void insertResizing(int index, E element) {
        if (index > this.size()) {
            this.setResizing(index, element);
            return;
        }
        this.insert(index, element);
    }

    public void addElement(E var1);

    @Override
    default public boolean add(E element) {
        this.addElement(element);
        return true;
    }

    @Override
    public boolean remove(Object var1);

    default public boolean removeFirst(@Nullable Object element) {
        int index = this.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    default public boolean removeLast(@Nullable Object element) {
        int index = this.lastIndexOf(element);
        if (index < 0) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public void removeAt(int var1);

    @Override
    public void map(@NonNull Function<? super E, ? extends E> var1);

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> var1);

    public void reverse();

    public void sort();

    public void sort(@NonNull Comparator<? super E> var1);

    public void distinguish();

    public void distinguish(@NonNull Comparator<? super E> var1);

    public int indexOf(Object var1);

    public int lastIndexOf(Object var1);

    @Override
    public @NonNull List<E> copy();

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy();

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int var1);

    @Override
    public @NonNull MutableList<E> mutable();

    @Override
    public @NonNull MutableList<E> mutableCopy();

    @Override
    public @NonNull ImmutableList<E> immutable();

    @Override
    public @NonNull ImmutableList<E> immutableCopy();

    @Override
    public <RE> @NonNull ImmutableList.Builder<RE> immutableBuilder();

    @Override
    public <RE> @NonNull ImmutableList.Builder<RE> immutableBuilder(int var1);

    @Override
    public @NonNull ImmutableList<E> view();

    @Override
    public @NonNull java.util.List<E> toJava();

    public static void rangeCheck(int index, int size) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("List index out of bounds: index < 0: " + index + " < 0");
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException("List index out of bounds: index >= size: " + index + " >= " + size);
        }
    }

    public static <E> boolean listEquals(@NonNull List<E> list, Object o) {
        return o instanceof List && List.listEquals(list, (List)o);
    }

    public static <E> boolean listEquals(@NonNull List<E> c1, @NonNull List<E> c2) {
        return c1.size() == c2.size() && Collection.orderedEquals(c1, c2);
    }

    public static <E> int listHashCode(@NonNull List<E> list) {
        int result = 1;
        for (E o : list) {
            result = 31 * result + (o == null ? 0 : o.hashCode());
        }
        return result;
    }
}

