/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.ReceiverType;
import dyvil.collection.iterator.AppendIterator;
import dyvil.collection.iterator.ArrayIterator;
import dyvil.collection.iterator.ConcatIterator;
import dyvil.collection.iterator.EmptyIterator;
import dyvil.collection.iterator.FilterIterator;
import dyvil.collection.iterator.FlatMapIterator;
import dyvil.collection.iterator.MapIterator;
import dyvil.collection.iterator.PrependIterator;
import dyvil.collection.iterator.SingletonIterator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_Iterator_$__TE____$___")
public class Iterators {
    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> empty() {
        return EmptyIterator.apply();
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> of(E element) {
        return SingletonIterator.apply(element);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> of(E ... elements) {
        return ArrayIterator.apply(elements);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus$plus")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> concat(@NonNull Iterator<? extends E> lhs, @NonNull Iterator<? extends E> rhs) {
        return ConcatIterator.apply(lhs, rhs);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> prepend(E lhs, @NonNull Iterator<? extends E> rhs) {
        return PrependIterator.apply(lhs, rhs);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus")
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> append(@NonNull Iterator<? extends E> lhs, E rhs) {
        return AppendIterator.apply(lhs, rhs);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E> @NonNull Iterator<E> filtered(Iterator<E> this_, @NonNull Predicate<? super E> predicate) {
        return FilterIterator.apply(this_, predicate);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E, R> @NonNull Iterator<R> mapped(Iterator<E> this_, @NonNull Function<? super E, ? extends R> mapper) {
        return MapIterator.apply(this_, mapper);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Iterator<TE;>;")
    public static <E, R> @NonNull Iterator<R> flatMapped(Iterator<E> this_, @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>> mapper) {
        return FlatMapIterator.apply(this_, mapper);
    }
}

