/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.collection.Iterators;
import dyvil.function.Function;
import dyvil.lang.Objects;
import dyvil.lang.Strings;
import dyvil.runtime.DynamicLinker;
import dyvil.runtime.LambdaMetafactory;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_lang_Iterable_$__TE____$___")
public class Iterables {
    private static Iterator lambda$0(Iterable iterable, Iterable iterable2) {
        Iterator iterator = iterable.iterator();
        iterator.getClass();
        Iterator iterator2 = iterable2.iterator();
        iterator2.getClass();
        return Iterators.concat(iterator, iterator2);
    }

    private static Iterator lambda$1(Iterable iterable, Object object) {
        Iterator iterator = iterable.iterator();
        iterator.getClass();
        return Iterators.append(iterator, object);
    }

    private static Iterator lambda$2(Object object, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        iterator.getClass();
        return Iterators.prepend(object, iterator);
    }

    private static boolean lambda$3(Iterable iterable, Object object) {
        return DynamicLinker.linkExtension("contains", contains(java.lang.Iterable<E> java.lang.Object ), (Iterable)iterable, (Object)object) == false;
    }

    private static boolean lambda$4(Object object, Object object2) {
        return !Objects.equals(object, object2);
    }

    private static Iterator lambda$5(Iterable iterable, Predicate predicate) {
        return DynamicLinker.linkExtension("filtered", filtered(java.util.Iterator<E> java.util.function.Predicate<? super E> ), iterable.iterator(), (Predicate)predicate);
    }

    private static Iterator lambda$6(Iterable iterable, Function function) {
        return DynamicLinker.linkExtension("mapped", mapped(java.util.Iterator<E> java.util.function.Function<? super E, ? extends R> ), iterable.iterator(), (Function)function);
    }

    private static Iterator lambda$7(Function function, Object object) {
        Iterator iterator = ((Iterable)function.apply(object)).iterator();
        iterator.getClass();
        return iterator;
    }

    private static Iterator lambda$8(Iterable iterable, Function function) {
        return DynamicLinker.linkExtension("flatMapped", flatMapped(java.util.Iterator<E> java.util.function.Function<? super E, ? extends java.util.Iterator<? extends R>> ), iterable.iterator(), (Function<Object, Iterator>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(java.util.function.Function java.lang.Object ), (Ljava/lang/Object;)Ljava/util/Iterator;)((Function)function));
    }

    private static void lambda$9(@NonNull Iterable iterable, StringBuilder stringBuilder) {
        DynamicLinker.linkExtension("toString", toString(java.lang.Iterable<E> java.lang.StringBuilder ), (Iterable)iterable, (StringBuilder)stringBuilder);
    }

    private static void lambda$10(@NonNull Iterable iterable, String string, String string2, String string3, StringBuilder stringBuilder) {
        DynamicLinker.linkExtension("toString", toString(java.lang.Iterable<E> java.lang.StringBuilder java.lang.String java.lang.String java.lang.String ), (Iterable)iterable, (StringBuilder)stringBuilder, (String)string, (String)string2, (String)string3);
    }

    @DyvilModifiers(value=327688L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static int $bar_$bar(@NonNull Iterable<? extends @Primitive Object> it) {
        return (int)DynamicLinker.linkExtension("size", size(java.lang.Iterable<E> ), it);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus$plus")
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> concat(@NonNull Iterable<? extends E> lhs, @NonNull Iterable<? extends E> rhs) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$0(java.lang.Iterable java.lang.Iterable ), ()Ljava/util/Iterator;)(lhs, rhs);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus")
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> append(@NonNull Iterable<? extends E> lhs, E rhs) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$1(java.lang.Iterable java.lang.Object ), ()Ljava/util/Iterator;)(lhs, rhs);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$plus")
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> prepend(E lhs, @NonNull Iterable<? extends E> rhs) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$2(java.lang.Object java.lang.Iterable ), ()Ljava/util/Iterator;)(lhs, rhs);
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$minus$minus")
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> removedAll(@NonNull Iterable<? extends E> lhs, @NonNull Iterable<? extends @Primitive Object> rhs) {
        return DynamicLinker.linkExtension("filtered", filtered(java.lang.Iterable<E> java.util.function.Predicate<? super E> ), lhs, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(java.lang.Iterable java.lang.Object ), (Ljava/lang/Object;)Z)(rhs));
    }

    @DyvilModifiers(value=393224L)
    @DyvilName(value="$minus")
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> removed(@NonNull Iterable<? extends E> lhs, @Primitive Object rhs) {
        return DynamicLinker.linkExtension("filtered", filtered(java.lang.Iterable<E> java.util.function.Predicate<? super E> ), lhs, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(java.lang.Object java.lang.Object ), (Ljava/lang/Object;)Z)((Object)rhs));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> int size(Iterable<E> this_) {
        void var1_1;
        int size = 0;
        for (E e : this_) {
            ++size;
        }
        return (int)var1_1;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> boolean isEmpty(Iterable<E> this_) {
        return !this_.iterator().hasNext();
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @Nullable E first(Iterable<E> this_) {
        Iterator<E> it = this_.iterator();
        return it.hasNext() ? (E)it.next() : null;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @Nullable E last(Iterable<E> this_) {
        void var1_1;
        Object last = null;
        for (E e : this_) {
            last = e;
        }
        return var1_1;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> boolean allMatch(Iterable<E> this_, @NonNull Predicate<? super E> predicate) {
        for (E e : this_) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> boolean anyMatch(Iterable<E> this_, @NonNull Predicate<? super E> predicate) {
        for (E e : this_) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> boolean contains(Iterable<E> this_, @Primitive Object element) {
        for (E e : this_) {
            if (!Objects.equals(element, e)) continue;
            return true;
        }
        return false;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @Nullable E find(Iterable<E> this_, @NonNull Predicate<? super E> predicate) {
        for (E e : this_) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> int count(Iterable<E> this_, @Primitive Object element) {
        void var2_2;
        int count = 0;
        for (E e : this_) {
            if (!Objects.equals(element, e)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> int count(Iterable<E> this_, @DyvilModifiers(value=0x400000L) @NonNull Predicate<? super E> predicate) {
        void var2_2;
        int count = 0;
        for (E e : this_) {
            if (!predicate.test(e)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E, R> R fold(Iterable<E> this_, R initial, @NonNull BiFunction<? super R, ? super E, ? extends R> reducer) {
        void var1_1;
        for (E e : this_) {
            initial = reducer.apply(initial, e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @Nullable E reduce(Iterable<E> this_, @NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        void var3_3;
        if (DynamicLinker.linkExtension("isEmpty", isEmpty(java.lang.Iterable<E> ), this_) != false) {
            return null;
        }
        Iterator<E> iterator = this_.iterator();
        E initial = iterator.next();
        Iterator<E> iterator2 = iterator;
        iterator2.getClass();
        Iterator<E> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            E e = iterator3.next();
            initial = reducer.apply(initial, e);
        }
        return var3_3;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull Iterable<E> filtered(Iterable<E> this_, @NonNull Predicate<? super E> predicate) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$5(java.lang.Iterable java.util.function.Predicate ), ()Ljava/util/Iterator;)(this_, predicate);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E, R> @NonNull Iterable<R> mapped(Iterable<E> this_, @NonNull Function<? super E, ? extends R> mapper) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$6(java.lang.Iterable java.util.function.Function ), ()Ljava/util/Iterator;)(this_, mapper);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E, R> @NonNull Iterable<R> flatMapped(Iterable<E> this_, @NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return (Iterable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$8(java.lang.Iterable java.util.function.Function ), ()Ljava/util/Iterator;)(this_, mapper);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @Primitive Object @NonNull [] toArray(Iterable<E> this_) {
        void var2_2;
        CallSite size = DynamicLinker.linkExtension("size", size(java.lang.Iterable<E> ), this_);
        Object[] array = new Object[size];
        int index = 0;
        for (E e : this_) {
            array[index] = e;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull String toString(Iterable<E> this_) {
        return Strings.build((Function.Of1<StringBuilder, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$9(java.lang.Iterable java.lang.StringBuilder ), (Ljava/lang/StringBuilder;)V)(this_));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> void toString(Iterable<E> this_, @NonNull StringBuilder builder) {
        DynamicLinker.linkExtension("toString", toString(java.lang.Iterable<E> java.lang.StringBuilder java.lang.String java.lang.String java.lang.String ), this_, (StringBuilder)builder, (String)"[", (String)", ", (String)"]");
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> @NonNull String toString(Iterable<E> this_, @NonNull String start, @NonNull String separator, @NonNull String end) {
        return Strings.build((Function.Of1<StringBuilder, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$10(java.lang.Iterable java.lang.String java.lang.String java.lang.String java.lang.StringBuilder ), (Ljava/lang/StringBuilder;)V)(this_, (String)start, (String)separator, (String)end));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/Iterable<TE;>;")
    public static <E> void toString(Iterable<E> this_, @NonNull StringBuilder builder, @NonNull String start, @NonNull String separator, @NonNull String end) {
        builder.append(start);
        if (DynamicLinker.linkExtension("isEmpty", isEmpty(java.lang.Iterable<E> ), this_) != false) {
            builder.append(end);
            return;
        }
        Iterator<E> iterator = this_.iterator();
        builder.append(iterator.next());
        Iterator<E> iterator2 = iterator;
        iterator2.getClass();
        Iterator<E> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            E e = iterator3.next();
            builder.append(separator).append(e);
        }
        builder.append(end);
    }
}

