/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.Matrix;
import dyvil.collection.MutableMatrix;
import dyvil.collection.immutable.ArrayMatrix;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import dyvil.util.ImmutableException;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@LiteralConvertible.FromArray
public interface ImmutableMatrix<@Covariant E>
extends Matrix<E> {
    public static <E> @NonNull ImmutableMatrix<E> apply(E[] ... elements) {
        return new ArrayMatrix<E>(elements);
    }

    public static <E> @NonNull ImmutableMatrix<E> create(int rows, int columns) {
        return new ArrayMatrix(rows, columns);
    }

    @Override
    default public boolean isImmutable() {
        return true;
    }

    @Override
    public int rows();

    @Override
    public int columns();

    @Override
    public boolean contains(Object var1);

    @Override
    public E subscript(int var1, int var2);

    @Override
    public E get(int var1, int var2);

    @Override
    public @NonNull ImmutableMatrix<E> subMatrix(int var1, int var2, int var3, int var4);

    @Override
    public @NonNull ImmutableList<E> row(int var1);

    @Override
    public @NonNull ImmutableList<E> column(int var1);

    @Override
    public @NonNull ImmutableList<E> flatten();

    @Override
    public @NonNull ImmutableMatrix<E> transposed();

    @Override
    public <R> @NonNull ImmutableMatrix<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    default public void resize(int rows, int columns) {
        throw new ImmutableException("resize() on Immutable Matrix");
    }

    @Override
    default public void addRow(List<E> row) {
        throw new ImmutableException("addRow() on Immutable Matrix");
    }

    @Override
    default public void addColumn(List<E> column) {
        throw new ImmutableException("addColumn() on Immutable Matrix");
    }

    @Override
    default public void insertRow(int index, @NonNull List<E> row) {
        throw new ImmutableException("insertRow() on Immutable Matrix");
    }

    @Override
    default public void insertColumn(int index, @NonNull List<E> column) {
        throw new ImmutableException("insertColumn() on Immutable Matrix");
    }

    @Override
    default public void subscript_$eq(int row, int column, E element) {
        throw new ImmutableException("update() on Immutable Matrix");
    }

    @Override
    default public @NonNull E set(int row, int column, E element) {
        throw new ImmutableException("set() on Immutable Matrix");
    }

    @Override
    default public void removeRow(int index) {
        throw new ImmutableException("removeRow() on Immutable Matrix");
    }

    @Override
    default public void removeColumn(int column) {
        throw new ImmutableException("removeColumn() on Immutable Matrix");
    }

    @Override
    default public void clear() {
        throw new ImmutableException("clear() on Immutable Matrix");
    }

    @Override
    default public void transpose() {
        throw new ImmutableException("transpose() on Immutable Matrix");
    }

    @Override
    default public void map(@NonNull UnaryOperator<E> mapper) {
        throw new ImmutableException("map() on Immutable Matrix");
    }

    @Override
    public int rowOf(Object var1);

    @Override
    public int columnOf(Object var1);

    @Override
    public @Nullable Tuple.Of2<Integer, Integer> cellOf(Object var1);

    @Override
    public void rowArray(int var1, Object[] var2);

    @Override
    public void columnArray(int var1, Object[] var2);

    @Override
    public void toArray(Object[][] var1);

    @Override
    public void toCellArray(Object[] var1);

    @Override
    public @NonNull ImmutableMatrix<E> copy();

    @Override
    public @NonNull MutableMatrix<E> mutable();

    @Override
    default public @NonNull MutableMatrix<E> mutableCopy() {
        return this.mutable();
    }

    @Override
    default public @NonNull ImmutableMatrix<E> immutable() {
        return this;
    }

    @Override
    default public @NonNull ImmutableMatrix<E> immutableCopy() {
        return this.copy();
    }

    @Override
    default public @NonNull ImmutableMatrix<E> view() {
        return this;
    }
}

