/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Mutating;
import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.immutable.ArrayMap;
import dyvil.collection.immutable.EmptyMap;
import dyvil.collection.immutable.SingletonMap;
import dyvil.collection.immutable.TupleMap;
import dyvil.lang.LiteralConvertible;
import dyvil.util.ImmutableException;
import dyvil.util.Option;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated
@dyvil.annotation.Deprecated(replacements={"java.util.Map"})
@LiteralConvertible.FromArray
@LiteralConvertible.FromMap
public interface ImmutableMap<@Covariant K, @Covariant V>
extends Map<K, V> {
    public static <K, V> @NonNull ImmutableMap<K, V> singleton(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public static <K, V> @NonNull ImmutableMap<K, V> apply() {
        return EmptyMap.apply();
    }

    public static <K, V> @NonNull ImmutableMap<K, V> apply(@NonNull Entry<? extends K, ? extends V> entry) {
        return SingletonMap.apply(entry.getKey(), entry.getValue());
    }

    @SafeVarargs
    public static <K, V> @NonNull ImmutableMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        switch (entries.length) {
            case 0: {
                return EmptyMap.apply();
            }
            case 1: {
                return SingletonMap.apply(entries[0]);
            }
        }
        return TupleMap.apply(entries);
    }

    public static <K, V> @NonNull ImmutableMap<K, V> apply(K @NonNull [] keys, V @NonNull [] values) {
        return new ArrayMap<K, V>(keys, values, true);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new ArrayMap.Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(int capacity) {
        return new ArrayMap.Builder(capacity);
    }

    @Override
    default public boolean isImmutable() {
        return true;
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator();

    @Override
    default public @NonNull Spliterator<Entry<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1024);
    }

    @Override
    public @NonNull Iterator<K> keyIterator();

    @Override
    default public @NonNull Spliterator<K> keySpliterator() {
        return Spliterators.spliterator(this.keyIterator(), (long)this.size(), 1024);
    }

    @Override
    public @NonNull Iterator<V> valueIterator();

    @Override
    default public @NonNull Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), 1024);
    }

    @Override
    public @Nullable V get(Object var1);

    @Override
    public @Nullable Entry<K, V> getEntry(Object var1);

    @Override
    public @NonNull Option<V> getOption(Object var1);

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K var1, V var2);

    @Override
    default public @NonNull ImmutableMap<K, V> withEntry(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.withEntry((Object)entry.getKey(), (Object)entry.getValue());
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> var1);

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object var1);

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object var1, Object var2);

    @Override
    default public @NonNull ImmutableMap<K, V> removed(@NonNull Entry<?, ?> entry) {
        return this.removed(entry.getKey(), entry.getValue());
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object var1);

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> var1);

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> var1);

    @Override
    default public <NK> ImmutableMap<NK, V> keyMapped(@NonNull Function<? super K, ? extends NK> mapper) {
        return this.keyMapped((T k, U v) -> mapper.apply((Object)k));
    }

    @Override
    public <NK> ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> var1);

    @Override
    default public <NV> @Nullable Map<K, NV> valueMapped(@NonNull Function<? super V, ? extends NV> mapper) {
        return this.valueMapped((T k, U v) -> mapper.apply((Object)v));
    }

    @Override
    public <NV> @Nullable ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> var1);

    @Override
    public <NK, NV> ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> var1);

    @Override
    public <NK, NV> @Nullable ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> var1);

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> var1);

    @Override
    default public @NonNull ImmutableMap<K, V> filteredByKey(@NonNull Predicate<? super K> predicate) {
        return this.filtered((T k, U v) -> predicate.test((Object)k));
    }

    @Override
    default public @NonNull ImmutableMap<K, V> filteredByValue(@NonNull Predicate<? super V> predicate) {
        return this.filtered((T k, U v) -> predicate.test((Object)v));
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted();

    @Override
    @Mutating
    default public void clear() {
        throw new ImmutableException("clear() on Immutable Map");
    }

    @Override
    @Mutating
    default public void subscript_$eq(K key, V value) {
        throw new ImmutableException("() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V put(K key, V value) {
        throw new ImmutableException("put() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V put(@NonNull Entry<? extends K, ? extends V> entry) {
        throw new ImmutableException("put() on Immutable Map");
    }

    @Override
    @Mutating
    default public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        throw new ImmutableException("putAll() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V putIfAbsent(K key, V value) {
        throw new ImmutableException("putIfAbsent() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V putIfAbsent(@NonNull Entry<? extends K, ? extends V> entry) {
        throw new ImmutableException("putIfAbsent() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean replace(K key, V oldValue, V newValue) {
        throw new ImmutableException("replace() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V replace(@NonNull Entry<? extends K, ? extends V> entry) {
        throw new ImmutableException("replace() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V replace(K key, V newValue) {
        throw new ImmutableException("replace() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V remap(Object key, K newKey) {
        throw new ImmutableException("remap() on Immutable Map");
    }

    @Override
    @Mutating
    default public @NonNull V removeKey(Object key) {
        throw new ImmutableException("removeKey() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean removeValue(Object value) {
        throw new ImmutableException("removeValue() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean remove(Object key, Object value) {
        throw new ImmutableException("remove() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean remove(@NonNull Entry<?, ?> entry) {
        throw new ImmutableException("remove() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean removeKeys(@NonNull Collection<?> keys) {
        throw new ImmutableException("removeKeys() on Immutable Map");
    }

    @Override
    @Mutating
    default public boolean removeAll(@NonNull Map<?, ?> map) {
        throw new ImmutableException("removeAll() on Immutable Map");
    }

    @Override
    @Mutating
    default public void mapKeys(@NonNull Function<? super K, ? extends K> mapper) {
        throw new ImmutableException("mapKeys() on Immutable Map");
    }

    @Override
    @Mutating
    default public void mapKeys(@NonNull BiFunction<? super K, ? super V, ? extends K> mapper) {
        throw new ImmutableException("mapKeys() on Immutable Map");
    }

    @Override
    @Mutating
    default public void mapValues(@NonNull Function<? super V, ? extends V> mapper) {
        throw new ImmutableException("mapValues() on Immutable Map");
    }

    @Override
    @Mutating
    default public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        throw new ImmutableException("mapValues() on Immutable Map");
    }

    @Override
    @Mutating
    default public void mapEntries(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends K, ? extends V>> mapper) {
        throw new ImmutableException("mapEntries() on Immutable Map");
    }

    @Override
    @Mutating
    default public void flatMap(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>>> mapper) {
        throw new ImmutableException("flatMap() on Immutable Map");
    }

    @Override
    @Mutating
    default public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        throw new ImmutableException("filter() on Immutable Map");
    }

    @Override
    @Mutating
    default public void filterByKey(@NonNull Predicate<? super K> condition) {
        throw new ImmutableException("filterByKey() on Immutable Map");
    }

    @Override
    @Mutating
    default public void filterByValue(@NonNull Predicate<? super V> condition) {
        throw new ImmutableException("filterByValue() on Immutable Map");
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy();

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy();

    @Override
    default public <RK, RV> MutableMap<RK, RV> emptyCopy(int capacity) {
        return this.emptyCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable();

    @Override
    default public @NonNull MutableMap<K, V> mutableCopy() {
        return this.mutable();
    }

    @Override
    public <RK, RV> Builder<RK, RV> immutableBuilder();

    @Override
    default public <RK, RV> Builder<RK, RV> immutableBuilder(int capacity) {
        return this.immutableBuilder();
    }

    @Override
    default public @NonNull ImmutableMap<K, V> immutable() {
        return this;
    }

    @Override
    default public @NonNull ImmutableMap<K, V> immutableCopy() {
        return this.copy();
    }

    @Override
    default public @NonNull ImmutableMap<K, V> view() {
        return this;
    }

    @Override
    public java.util.Map<K, V> toJava();

    public static interface Builder<K, V> {
        public void put(K var1, V var2);

        default public void put(@NonNull Entry<? extends K, ? extends V> entry) {
            this.put(entry.getKey(), entry.getValue());
        }

        default public void putAll(@NonNull Map<? extends K, ? extends V> map) {
            for (Entry<K, V> entry : map) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public ImmutableMap<K, V> build();
    }
}

