/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableCollection;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.Range;
import dyvil.collection.immutable.AppendList;
import dyvil.collection.immutable.ArrayList;
import dyvil.collection.immutable.EmptyList;
import dyvil.collection.immutable.SingletonList;
import dyvil.lang.LiteralConvertible;
import dyvil.ref.ObjectRef;
import dyvil.util.ImmutableException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;

@Deprecated
@Immutable
@dyvil.annotation.Deprecated(replacements={"java.util.List"})
@LiteralConvertible.FromArray
public interface ImmutableList<@Covariant E>
extends List<E>,
ImmutableCollection<E> {
    public static <E> @NonNull ImmutableList<E> apply() {
        return EmptyList.apply();
    }

    public static <E> @NonNull ImmutableList<E> apply(E element) {
        return SingletonList.apply(element);
    }

    public static <E> @NonNull ImmutableList<E> apply(E e1, E e2) {
        return ArrayList.apply(new Object[]{e1, e2});
    }

    public static <E> @NonNull ImmutableList<E> apply(E e1, E e2, E e3) {
        return ArrayList.apply(new Object[]{e1, e2, e3});
    }

    @SafeVarargs
    public static <E> @NonNull ImmutableList<E> apply(E ... elements) {
        return ArrayList.apply(elements);
    }

    public static <E> @NonNull ImmutableList<E> from(E @NonNull [] array) {
        return ArrayList.from(array);
    }

    public static <E> @NonNull ImmutableList<E> from(@NonNull Iterable<? extends E> iterable) {
        return ArrayList.from(iterable);
    }

    public static <E> @NonNull ImmutableList<E> from(@NonNull Collection<? extends E> collection) {
        return ArrayList.from(collection);
    }

    public static <E> @NonNull ImmutableList<E> repeat(int count, E repeatedValue) {
        Object[] elements = new Object[count];
        for (int i = 0; i < count; ++i) {
            elements[i] = repeatedValue;
        }
        return new ArrayList<Object>(elements, count, true);
    }

    public static <E> @NonNull ImmutableList<E> generate(int count, @NonNull IntFunction<E> generator) {
        Object[] elements = new Object[count];
        for (int i = 0; i < count; ++i) {
            elements[i] = generator.apply(i);
        }
        return new ArrayList<Object>(elements, count, true);
    }

    @SafeVarargs
    public static <E> @NonNull ImmutableList<E> linked(E ... elements) {
        return AppendList.apply(elements);
    }

    public static <E> @NonNull Builder<E> builder() {
        return ArrayList.builder();
    }

    public static <E> @NonNull Builder<E> builder(int capacity) {
        return ArrayList.builder(capacity);
    }

    public static <E> @NonNull Builder<E> linkedBuilder() {
        return AppendList.builder();
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    public @NonNull Iterator<E> reverseIterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1088);
    }

    @Override
    public E get(int var1);

    @Override
    public @NonNull ImmutableList<E> subList(int var1, int var2);

    @Override
    public @NonNull ImmutableList<E> added(E var1);

    @Override
    public @NonNull ImmutableList<E> union(@NonNull Collection<? extends E> var1);

    @Override
    public @NonNull ImmutableList<E> removed(Object var1);

    @Override
    public @NonNull ImmutableList<E> difference(@NonNull Collection<?> var1);

    @Override
    public @NonNull ImmutableList<E> intersection(@NonNull Collection<? extends E> var1);

    @Override
    public <R> @NonNull ImmutableList<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public <R> @NonNull ImmutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> var1);

    @Override
    public @NonNull ImmutableList<E> filtered(@NonNull Predicate<? super E> var1);

    @Override
    public @NonNull ImmutableList<E> reversed();

    @Override
    public @NonNull ImmutableList<E> sorted();

    @Override
    public @NonNull ImmutableList<E> sorted(@NonNull Comparator<? super E> var1);

    @Override
    public @NonNull ImmutableList<E> distinct();

    @Override
    public @NonNull ImmutableList<E> distinct(@NonNull Comparator<? super E> var1);

    @Override
    @Mutating
    default public void clear() {
        throw new ImmutableException("clear() on Immutable List");
    }

    @Override
    @Mutating
    default public void ensureCapacity(int minSize) {
    }

    @Override
    @Mutating
    default public void subscript_$eq(int index, E element) {
        throw new ImmutableException("subscript() on Immutable List");
    }

    @Override
    @Mutating
    default public @NonNull List<E> subscript(@NonNull Range<Integer> range) {
        throw new ImmutableException("subscript() on Immutable List");
    }

    @Override
    @Mutating
    default public void subscript_$eq(@NonNull Range<Integer> range, E @NonNull [] elements) {
        throw new ImmutableException("subscript_=() on Immutable List");
    }

    @Override
    @Mutating
    default public void subscript_$eq(@NonNull Range<Integer> range, @NonNull List<? extends E> elements) {
        throw new ImmutableException("subscript_=() on Immutable List");
    }

    @Override
    @Mutating
    default public @NonNull ObjectRef<E> subscript_$amp(int index) {
        throw new ImmutableException("subscript_&() on Immutable List");
    }

    @Override
    @Mutating
    default public @NonNull E set(int index, E element) {
        throw new ImmutableException("set() on Immutable List");
    }

    @Override
    @Mutating
    default public @NonNull E setResizing(int index, E element) {
        throw new ImmutableException("setResizing() on Immutable List");
    }

    @Override
    @Mutating
    default public void insert(int index, E element) {
        throw new ImmutableException("insert() on Immutable List");
    }

    @Override
    @Mutating
    default public void insertResizing(int index, E element) {
        throw new ImmutableException("insertResizing() on Immutable List");
    }

    @Override
    @Mutating
    default public void addElement(E element) {
        throw new ImmutableException("addElement() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean add(E element) {
        throw new ImmutableException("add() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean addAll(@NonNull Collection<? extends E> collection) {
        throw new ImmutableException("addAll() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean remove(Object element) {
        throw new ImmutableException("remove() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean removeFirst(Object element) {
        throw new ImmutableException("removeFirst() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean removeLast(Object element) {
        throw new ImmutableException("removeLast() on Immutable List");
    }

    @Override
    @Mutating
    default public void removeAt(int index) {
        throw new ImmutableException("removeAt() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean removeAll(@NonNull Collection<?> collection) {
        throw new ImmutableException("removeAll() on Immutable List");
    }

    @Override
    @Mutating
    default public boolean retainAll(@NonNull Collection<? extends E> collection) {
        throw new ImmutableException("intersect() on Immutable List");
    }

    @Override
    @Mutating
    default public void filter(@NonNull Predicate<? super E> predicate) {
        throw new ImmutableException("filter() on Immutable List");
    }

    @Override
    @Mutating
    default public void map(@NonNull Function<? super E, ? extends E> mapper) {
        throw new ImmutableException("map() on Immutable List");
    }

    @Override
    @Mutating
    default public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        throw new ImmutableException("flatMap() on Immutable List");
    }

    @Override
    @Mutating
    default public void reverse() {
        throw new ImmutableException("reverse() on Immutable List");
    }

    @Override
    @Mutating
    default public void sort() {
        throw new ImmutableException("sort() on Immutable List");
    }

    @Override
    @Mutating
    default public void sort(@NonNull Comparator<? super E> comparator) {
        throw new ImmutableException("sort() on Immutable List");
    }

    @Override
    @Mutating
    default public void distinguish() {
        throw new ImmutableException("distinguish() on Immutable List");
    }

    @Override
    @Mutating
    default public void distinguish(@NonNull Comparator<? super E> comparator) {
        throw new ImmutableException("disinguish() on Immutable List");
    }

    @Override
    public int indexOf(Object var1);

    @Override
    public int lastIndexOf(Object var1);

    @Override
    public @NonNull ImmutableList<E> copy();

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy();

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int var1);

    @Override
    public @NonNull MutableList<E> mutable();

    @Override
    default public @NonNull MutableList<E> mutableCopy() {
        return this.mutable();
    }

    @Override
    default public @NonNull ImmutableList<E> immutable() {
        return this;
    }

    @Override
    default public @NonNull ImmutableList<E> immutableCopy() {
        return this.copy();
    }

    @Override
    public <RE> Builder<RE> immutableBuilder();

    @Override
    public <RE> Builder<RE> immutableBuilder(int var1);

    @Override
    default public @NonNull ImmutableList<E> view() {
        return this;
    }

    public static interface Builder<E>
    extends ImmutableCollection.Builder<E> {
        @Override
        public ImmutableList<E> build();
    }
}

