/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Deprecated;
import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Collection;
import dyvil.collection.MutableCollection;
import dyvil.util.ImmutableException;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@Deprecated(replacements={"java.util.Collection"})
public interface ImmutableCollection<E>
extends Collection<E> {
    @Override
    @DyvilModifiers(value=16L)
    default public boolean isImmutable() {
        return true;
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        Spliterator<E> spliterator = Spliterators.spliterator(this.iterator(), (long)this.size(), Spliterator.IMMUTABLE);
        spliterator.getClass();
        return spliterator;
    }

    @Override
    public @NonNull ImmutableCollection<E> added(E var1);

    @Override
    public @NonNull ImmutableCollection<E> union(@NonNull Collection<? extends E> var1);

    @Override
    public @NonNull ImmutableCollection<E> removed(@Primitive Object var1);

    @Override
    public @NonNull ImmutableCollection<E> difference(@NonNull Collection<? extends @Primitive Object> var1);

    @Override
    public @NonNull ImmutableCollection<E> intersection(@NonNull Collection<? extends E> var1);

    @Override
    public <R> @NonNull ImmutableCollection<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public <R> @NonNull ImmutableCollection<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> var1);

    @Override
    public @NonNull ImmutableCollection<E> filtered(@NonNull Predicate<? super E> var1);

    @Override
    @Mutating
    default public void clear() {
        throw new ImmutableException("clear() on Immutable Collection");
    }

    @Override
    @Mutating
    default public boolean add(E element) {
        throw new ImmutableException("add() on Immutable Collection");
    }

    @Override
    @Mutating
    default public boolean addAll(@NonNull Collection<? extends E> elements) {
        throw new ImmutableException("addAll() on Immutable Collection");
    }

    @Override
    @Mutating
    default public boolean remove(@Primitive Object element) {
        throw new ImmutableException("remove() on Immutable Collection");
    }

    @Override
    @Mutating
    default public boolean removeAll(@NonNull Collection<? extends @Primitive Object> elements) {
        throw new ImmutableException("removeAll() on Immutable Collection");
    }

    @Override
    @Mutating
    default public boolean retainAll(@NonNull Collection<? extends E> elements) {
        throw new ImmutableException("intersect() on Immutable Collection");
    }

    @Override
    @Mutating
    default public void map(@NonNull Function<? super E, ? extends E> mapper) {
        throw new ImmutableException("map() on Immutable Collection");
    }

    @Override
    @Mutating
    default public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        throw new ImmutableException("flatMap() on Immutable Collection");
    }

    @Override
    @Mutating
    default public void filter(@NonNull Predicate<? super E> predicate) {
        throw new ImmutableException("filter() on Immutable Collection");
    }

    @Override
    public @NonNull ImmutableCollection<E> copy();

    @Override
    @DyvilModifiers(value=16L)
    default public @NonNull MutableCollection<E> mutableCopy() {
        return this.mutable();
    }

    @Override
    @DyvilModifiers(value=16L)
    default public @NonNull ImmutableCollection<E> immutable() {
        return this;
    }

    @Override
    @DyvilModifiers(value=16L)
    default public @NonNull ImmutableCollection<E> immutableCopy() {
        return this.copy();
    }

    @Override
    @DyvilModifiers(value=16L)
    default public @NonNull ImmutableCollection<E> view() {
        return this;
    }

    public static interface Builder<E> {
        public void add(E var1);

        default public void addAll(@NonNull Iterable<? extends E> elements) {
            for (E e : elements) {
                this.add(e);
            }
        }

        public ImmutableCollection<E> build();
    }
}

