/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.ReceiverType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_HashSet__")
public class HashSets {
    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> empty() {
        return new HashSet();
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> of(E element) {
        HashSet<E> hashSet = new HashSet<E>();
        hashSet.add(element);
        return hashSet;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> of(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> copyOf(@DyvilModifiers(value=0x400000L) @NonNull Collection<? extends E> collection) {
        return new HashSet<E>(collection);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> withCapacity(@DyvilModifiers(value=0x400000L) int capacity) {
        return new HashSet(capacity);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/HashSet;")
    public static <E> @NonNull HashSet<E> withCapacity(@DyvilModifiers(value=0x400000L) int capacity, @DyvilModifiers(value=0x400000L) float loadFactor) {
        return new HashSet(capacity, loadFactor);
    }
}

