/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.lang.Objects;
import dyvil.runtime.LambdaMetafactory;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.util.Comparator;

public interface Entry<@Covariant K, @Covariant V>
extends Serializable {
    private static int lambda$0(@NonNull Entry entry, @NonNull Entry entry2) {
        return ((Comparable)entry.getKey()).compareTo(entry2.getKey());
    }

    private static int lambda$1(@NonNull Entry entry, @NonNull Entry entry2) {
        return ((Comparable)entry.getValue()).compareTo(entry2.getValue());
    }

    private static int lambda$2(@NonNull Comparator comparator, @NonNull Entry entry, Entry entry2) {
        return comparator.compare(entry.getKey(), entry2.getKey());
    }

    private static int lambda$3(@NonNull Comparator comparator, @NonNull Entry entry, Entry entry2) {
        return comparator.compare(entry.getValue(), entry2.getValue());
    }

    public K getKey();

    public V getValue();

    default public @NonNull Tuple.Of2<K, V> toTuple() {
        return new Tuple.Of2<K, V>(this.getKey(), this.getValue());
    }

    public static <K extends Comparable<? super K>, V> @NonNull Comparator<@NonNull Entry<K, V>> comparingByKey() {
        return (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(dyvil.collection.Entry dyvil.collection.Entry ), (Ldyvil/collection/Entry;Ldyvil/collection/Entry;)I)();
    }

    public static <K, V extends Comparable<? super V>> @NonNull Comparator<@NonNull Entry<K, V>> comparingByValue() {
        return (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$1(dyvil.collection.Entry dyvil.collection.Entry ), (Ldyvil/collection/Entry;Ldyvil/collection/Entry;)I)();
    }

    public static <K, V> @NonNull Comparator<@NonNull Entry<K, V>> comparingByKey(@NonNull Comparator<? super K> cmp) {
        return (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$2(java.util.Comparator dyvil.collection.Entry dyvil.collection.Entry ), (Ldyvil/collection/Entry;Ldyvil/collection/Entry;)I)(cmp);
    }

    public static <K, V> @NonNull Comparator<@NonNull Entry<K, V>> comparingByValue(@NonNull Comparator<? super V> cmp) {
        return (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$3(java.util.Comparator dyvil.collection.Entry dyvil.collection.Entry ), (Ldyvil/collection/Entry;Ldyvil/collection/Entry;)I)(cmp);
    }

    public static @NonNull String entryToString(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> entry) {
        return new StringBuilder(44).append("").append(entry.getKey()).append(" -> ").append(entry.getValue()).append("").toString();
    }

    public static boolean entryEquals(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> entry, @Primitive Object obj) {
        return obj instanceof Entry && Entry.entryEquals(entry, (Entry)obj);
    }

    public static boolean entryEquals(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> entry, @NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> other) {
        return Objects.equals(entry.getKey(), other.getKey()) && Objects.equals(entry.getValue(), other.getValue());
    }

    public static int entryHashCode(@NonNull Entry<? extends @Primitive Object, ? extends @Primitive Object> entry) {
        Object key = entry.getKey();
        Object value = entry.getValue();
        int hash = key.hashCode() + value.hashCode();
        return hash * 31 + hash;
    }
}

