/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.ImmutableCollection;
import dyvil.collection.MutableCollection;
import dyvil.collection.Queryable;
import dyvil.collection.Set;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated(replacements={"java.util.Collection"})
@LiteralConvertible.FromArray
public interface Collection<E>
extends Queryable<E> {
    public static final @NonNull String EMPTY_STRING = "[]";
    public static final @NonNull String START_STRING = "[";
    public static final @NonNull String END_STRING = "]";
    public static final @NonNull String ELEMENT_SEPARATOR_STRING = ", ";

    public boolean isImmutable();

    @Override
    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean isDistinct() {
        int size = this.size();
        if (size < 2) {
            return true;
        }
        Object[] array = this.toArray();
        return Set.isDistinct(array, size);
    }

    default public boolean isSorted() {
        return this.size() < 2 || Collection.iteratorSorted(this.iterator());
    }

    default public boolean isSorted(@NonNull Comparator<? super E> comparator) {
        return this.size() < 2 || Collection.iteratorSorted(this.iterator(), comparator);
    }

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        Spliterator<E> spliterator = Spliterators.spliterator(this.iterator(), (long)this.size(), Spliterator.SIZED);
        spliterator.getClass();
        return spliterator;
    }

    @Override
    default public boolean contains(@Primitive Object element) {
        return Collection.iterableContains(this, element);
    }

    default public boolean intersects(@NonNull Collection<? extends @Primitive Object> collection) {
        if (collection.size() < this.size()) {
            for (Object t : this) {
                if (!collection.contains(t)) continue;
                return true;
            }
            return false;
        }
        for (Object t : collection) {
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    public Collection<E> added(E var1);

    public Collection<E> removed(@Primitive Object var1);

    public Collection<E> union(@NonNull Collection<? extends E> var1);

    public Collection<E> difference(@NonNull Collection<? extends @Primitive Object> var1);

    public Collection<E> intersection(@NonNull Collection<? extends E> var1);

    @Override
    public <R> @NonNull Collection<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public <R> @NonNull Collection<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> var1);

    @Override
    public @NonNull Collection<E> filtered(@NonNull Predicate<? super E> var1);

    public void clear();

    public boolean add(E var1);

    /*
     * WARNING - void declaration
     */
    default public boolean addAll(@NonNull Iterable<? extends E> elements) {
        void var2_2;
        boolean changed = false;
        for (E e : elements) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return (boolean)var2_2;
    }

    default public boolean addAll(@NonNull Collection<? extends E> elements) {
        return this.addAll((Iterable<? extends E>)elements);
    }

    public boolean remove(@Primitive Object var1);

    /*
     * WARNING - void declaration
     */
    default public boolean removeAll(@NonNull Iterable<? extends @Primitive Object> elements) {
        void var2_2;
        boolean changed = false;
        for (Object object : elements) {
            changed |= this.remove(object);
        }
        return (boolean)var2_2;
    }

    default public boolean removeAll(@NonNull Collection<? extends @Primitive Object> elements) {
        return this.removeAll((Iterable<? extends Object>)elements);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean retainAll(@NonNull Collection<? extends E> elements) {
        void var3_3;
        Iterator<E> it = this.iterator();
        boolean changed = false;
        Iterator<E> iterator = it;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (elements.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return (boolean)var3_3;
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> var1);

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> var1);

    @Override
    default public void filter(@NonNull Predicate<? super E> predicate) {
        Iterator<E> it;
        Iterator<E> iterator = it = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (predicate.test(e)) continue;
            it.remove();
        }
    }

    default public Object @NonNull [] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.toArray(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    default public <R> R @NonNull [] toArray(@NonNull Class<R> of) {
        void var2_2;
        Object[] array = (Object[])Array.newInstance(of, this.size());
        this.toArray(array);
        return var2_2;
    }

    default public void toArray(Object @NonNull [] store) {
        this.toArray(0, store);
    }

    default public void toArray(int index, Object @NonNull [] store) {
        for (Object e : this) {
            store[index] = e;
            ++index;
        }
    }

    public @NonNull Collection<E> copy();

    public <R> @NonNull MutableCollection<R> emptyCopy();

    public <R> @NonNull MutableCollection<R> emptyCopy(int var1);

    public @NonNull MutableCollection<E> mutable();

    public @NonNull MutableCollection<E> mutableCopy();

    public @NonNull ImmutableCollection<E> immutable();

    public @NonNull ImmutableCollection<E> immutableCopy();

    public <R> @NonNull ImmutableCollection.Builder<R> immutableBuilder();

    public <R> @NonNull ImmutableCollection.Builder<R> immutableBuilder(int var1);

    public @NonNull ImmutableCollection<E> view();

    public @NonNull java.util.Collection<E> toJava();

    public @NonNull String toString();

    @Override
    default public void toString(@NonNull StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append(EMPTY_STRING);
            return;
        }
        this.toString(builder, START_STRING, ELEMENT_SEPARATOR_STRING, END_STRING);
    }

    public boolean equals(@Primitive Object var1);

    public int hashCode();

    public static boolean iterableContains(@NonNull Iterable<? extends @Primitive Object> iterable, @Primitive Object element) {
        Iterator<? extends Object> iterator = iterable.iterator();
        iterator.getClass();
        return Collection.iteratorContains(iterator, element);
    }

    public static boolean iteratorContains(@NonNull Iterator<? extends @Primitive Object> iterator, @Primitive Object element) {
        if (element == null) {
            Iterator<? extends Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e != null) continue;
                return true;
            }
            return false;
        }
        Iterator<? extends Object> iterator3 = iterator;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            if (!element.equals(e)) continue;
            return true;
        }
        return false;
    }

    public static @NonNull String collectionToString(@NonNull Queryable<? extends @Primitive Object> collection) {
        if (collection.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        collection.toString(builder);
        String string = builder.toString();
        string.getClass();
        string.getClass();
        return string;
    }

    public static boolean orderedEquals(@NonNull Queryable<? extends @Primitive Object> lhs, @NonNull Queryable<? extends @Primitive Object> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator it1 = lhs.iterator();
        Iterator it2 = rhs.iterator();
        while (it1.hasNext()) {
            if (!(!Objects.equals(it1.next(), it2.next()))) continue;
            return false;
        }
        return true;
    }

    public static boolean unorderedEquals(@NonNull Queryable<? extends @Primitive Object> lhs, @NonNull Queryable<? extends @Primitive Object> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (Object t : lhs) {
            if (rhs.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static int unorderedHashCode(@NonNull Iterable<? extends @Primitive Object> collection) {
        int sum = 0;
        int product = 0;
        for (Object object : collection) {
            int hash = object.hashCode();
            sum += hash;
            product *= hash;
        }
        return sum * 31 + product;
    }

    public static boolean isSorted(Object @NonNull [] array, int size) {
        if (size < 2) {
            return true;
        }
        int n = size;
        for (int i = 1; i < n; ++i) {
            Comparable right = (Comparable)array[i];
            Comparable left = (Comparable)array[i - 1];
            if (!Objects.$lt(right, left)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isSorted(E @NonNull [] array, int size, @NonNull Comparator<? super E> comparator) {
        if (size < 2) {
            return true;
        }
        int n = size;
        for (int i = 1; i < n; ++i) {
            if (comparator.compare(array[i - 1], array[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean iteratorSorted(@NonNull Iterator<? extends @Primitive Object> iterator) {
        if (!iterator.hasNext()) {
            return true;
        }
        Comparable curr = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable next = (Comparable)iterator.next();
            if (Objects.$lt(next, curr)) {
                return false;
            }
            curr = next;
        }
        return true;
    }

    public static <E> boolean iteratorSorted(@NonNull Iterator<E> iterator, @NonNull Comparator<? super E> comparator) {
        if (!iterator.hasNext()) {
            return true;
        }
        E curr = iterator.next();
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (comparator.compare(curr, next) > 0) {
                return false;
            }
            curr = next;
        }
        return true;
    }
}

