/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.lang.Objects;
import dyvil.tuple.Tuple;
import java.io.Serializable;

public interface Cell<@Covariant R, @Covariant C, @Covariant V>
extends Serializable {
    public R getRow();

    public C getColumn();

    public V getValue();

    default public @NonNull Tuple.Of3<R, C, V> toTuple() {
        return new Tuple.Of3<R, C, V>(this.getRow(), this.getColumn(), this.getValue());
    }

    public static @NonNull String cellToString(@NonNull Cell<? extends @Primitive Object, ? extends @Primitive Object, ? extends @Primitive Object> cell) {
        return new StringBuilder(68).append("(").append(cell.getRow()).append(", ").append(cell.getColumn()).append(") -> ").append(cell.getValue()).append("").toString();
    }

    public static boolean cellEquals(@NonNull Cell<? extends @Primitive Object, ? extends @Primitive Object, ? extends @Primitive Object> cell, @Primitive Object obj) {
        return obj instanceof Cell && Cell.cellEquals(cell, (Cell)obj);
    }

    public static boolean cellEquals(@NonNull Cell<? extends @Primitive Object, ? extends @Primitive Object, ? extends @Primitive Object> cell, @NonNull Cell<? extends @Primitive Object, ? extends @Primitive Object, ? extends @Primitive Object> other) {
        return Objects.equals(cell.getRow(), other.getRow()) && Objects.equals(cell.getColumn(), other.getColumn()) && Objects.equals(cell.getValue(), other.getValue());
    }

    public static int cellHashCode(@NonNull Cell<? extends @Primitive Object, ? extends @Primitive Object, ? extends @Primitive Object> cell) {
        Object row = cell.getRow();
        Object column = cell.getColumn();
        Object value = cell.getValue();
        int keyHash = row.hashCode() * 31 + column.hashCode();
        return keyHash * 31 + value.hashCode();
    }
}

