/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.function.Function;
import dyvil.ref.ShortRef;
import dyvil.ref.array.ShortArrayRef;
import java.util.Arrays;

public abstract class ShortArray {
    public static final short @Immutable @NonNull [] EMPTY = new short[0];

    private ShortArray() {
    }

    @DyvilModifiers(value=65536L)
    public static short @NonNull [] apply() {
        return new short[0];
    }

    @DyvilModifiers(value=65536L)
    public static short @NonNull [] apply(int size) {
        return new short[size];
    }

    @DyvilModifiers(value=65536L)
    public static short @NonNull [] apply(short @NonNull [] array) {
        return ShortArray.copy(array);
    }

    /*
     * WARNING - void declaration
     */
    public static short @NonNull [] apply(int size, short repeatedValue) {
        void var2_2;
        short[] array = new short[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Short> valueSupplier) {
        void var2_2;
        short[] array = new short[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Short> valueMapper) {
        void var2_2;
        short[] array = new short[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static short @NonNull [] rangeClosed(short from, short to) {
        void var2_2;
        short[] array = new short[to - from + 1];
        int index = 0;
        int i = from;
        short s = to;
        while (i <= s) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static short @NonNull [] rangeOpen(short from, @DyvilModifiers(value=0x400000L) short toExclusive) {
        void var2_2;
        short[] array = new short[toExclusive - from];
        int index = 0;
        int i = from;
        short s = toExclusive;
        while (i < s) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(short @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(short @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(short @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 53})
    public static short subscript(short @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 86})
    public static void subscript_$eq(short @NonNull [] array, int index, short newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] subscript(short @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        short[] result = new short[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(short @NonNull [] array, @NonNull Range<@Primitive Integer> range, short @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull ShortRef subscript_$amp(short @NonNull [] array, int index) {
        return new ShortArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(short @NonNull [] array, @NonNull Function.Of1<@Primitive Short, @Primitive Void> action) {
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short value = sArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static short @NonNull [] $dot$dot$dot(short @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(short[] lhs, short[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(short[] lhs, short[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] added(short @NonNull [] array, short value) {
        void var3_3;
        int size = array.length;
        short[] result = new short[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] inserted(short @NonNull [] array, int index, short value) {
        int size = array.length;
        short[] result = new short[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] union(short @NonNull [] array, short @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        short[] result = new short[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] removed(short @NonNull [] array, short value) {
        void var3_3;
        int size = array.length;
        short[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                short element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new short[size];
        index = 0;
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short element;
                if ((element = sArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] difference(short @NonNull [] array, short @NonNull [] from) {
        int size = array.length;
        short[] result = new short[size];
        int index = 0;
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short v;
                if (ShortArray.contains(from, v = sArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ShortArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] intersection(short @NonNull [] array, short @NonNull [] with) {
        int size = array.length;
        short[] result = new short[size];
        int index = 0;
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short v;
                if (!ShortArray.contains(with, v = sArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ShortArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] mappedToShort(short @NonNull [] array, @NonNull Function.Of1<@Primitive Short, @Primitive Short> mapper) {
        void var3_3;
        int size = array.length;
        short[] result = new short[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(short @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Short, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] flatMappedToShort(short @NonNull [] array, @NonNull Function.Of1<@Primitive Short, short @NonNull []> mapper) {
        int size = 0;
        short[] result = new short[array.length << 2];
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short v;
                short[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = sArray[n2])).length) >= result.length) {
                    result = ShortArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return ShortArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(short @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Short, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short value = sArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] filtered(short @NonNull [] array, @NonNull Function.Of1<@Primitive Short, @Primitive Boolean> condition) {
        int size = array.length;
        short[] result = new short[size];
        int index = 0;
        short[] sArray = array;
        int n = sArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                short v;
                if (!condition.apply(v = sArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ShortArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] sorted(short @NonNull [] array) {
        void var1_1;
        short[] result = ShortArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(short @NonNull [] array, short value) {
        return ShortArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(short @NonNull [] array, short value) {
        return ShortArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(short @NonNull [] array, short value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(short @NonNull [] array, short value) {
        return ShortArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(short @NonNull [] array, short value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] copy(short @NonNull [] array) {
        return (short[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static short @NonNull [] copy(short @NonNull [] array, int size) {
        void var2_2;
        short[] result = new short[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static short @NonNull [] trim(short @NonNull [] array, int size) {
        return array.length <= size ? array : ShortArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Short @NonNull [] boxed(short @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Short[] boxed = new Short[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Short> asIterable(short @NonNull [] array) {
        return ShortArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Short> asList(short @Immutable @NonNull [] array) {
        return ShortArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Short> toList(short @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Short>(ShortArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(short[] array, short[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(short[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(short[] array) {
        String string;
        short[] sArray = array;
        if (sArray != null) {
            int size = sArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            ShortArray.append(sArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(short[] array, @NonNull StringBuilder builder) {
        short[] sArray = array;
        if (sArray != null) {
            int size = sArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            ShortArray.append(sArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(short @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

