/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.BooleanArray;
import dyvil.array.ByteArray;
import dyvil.array.CharArray;
import dyvil.array.DoubleArray;
import dyvil.array.FloatArray;
import dyvil.array.IntArray;
import dyvil.array.LongArray;
import dyvil.array.ShortArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.function.Function;
import dyvil.ref.ObjectRef;
import dyvil.ref.array.ObjectArrayRef;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class ObjectArray {
    public static final Object @Immutable @NonNull [] EMPTY = new Object[0];

    private ObjectArray() {
    }

    @DyvilModifiers(value=65536L)
    public static <T> T @NonNull [] apply(@NonNull Class clazz) {
        return new Object[0];
    }

    @DyvilModifiers(value=65536L)
    public static <T> T @NonNull [] apply(@NonNull int size, Class clazz) {
        return ObjectArray.ofType(size, clazz);
    }

    @DyvilName(value="apply")
    public static <T> T @NonNull [] ofType(int size, @NonNull Class<T> elementType) {
        return (Object[])Array.newInstance(elementType, size);
    }

    @DyvilModifiers(value=65536L)
    public static <T> T @NonNull [] apply(T @NonNull [] array) {
        return ObjectArray.copy(array);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T @NonNull [] apply(@NonNull int size, T repeatedValue, Class clazz) {
        void var3_3;
        T[] array = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T @NonNull [] apply(@NonNull int size, @NonNull Function.Of0<T> valueSupplier, Class clazz) {
        void var3_3;
        T[] array = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T @NonNull [] apply(@NonNull int size, @NonNull Function.Of1<@Primitive Integer, T> valueMapper, Class clazz) {
        void var3_3;
        T[] array = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var3_3;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static <T> int size(T @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static <T> int $bar_$bar(T @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static <T> boolean isEmpty(T @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 50})
    public static <T> T subscript(T @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 83})
    public static <T> void subscript_$eq(T @NonNull [] array, int index, T newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] subscript(T @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static <T> void subscript_$eq(T @NonNull [] array, @NonNull Range<@Primitive Integer> range, T @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static <T> @NonNull ObjectRef subscript_$amp(T @NonNull [] array, int index) {
        return new ObjectArrayRef<T>(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static <T> void forEach(T @NonNull [] array, @NonNull Function.Of1<T, @Primitive Void> action) {
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T value = TArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=131072L)
    public static <T> @NonNull Class<T> elementType(T @NonNull [] array) {
        return array.getClass().getComponentType();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> @NonNull Class<? extends @Primitive Object> deepElementType(T @NonNull [] array) {
        void var1_1;
        Class<?> elementType;
        Class<?> clazz = array.getClass();
        clazz.getClass();
        Class<?> result = clazz;
        while ((elementType = result.getComponentType()) != null) {
            elementType.getClass();
        }
        return var1_1;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static <T> T @NonNull [] $dot$dot$dot(T @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static <T> boolean $eq$eq(T[] lhs, T[] rhs) {
        return Arrays.deepEquals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> boolean $bang$eq(T[] lhs, T[] rhs) {
        return !Arrays.deepEquals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] added(T @NonNull [] array, T value) {
        void var3_3;
        int size = array.length;
        T[] result = ObjectArray.ofType(size + 1, ObjectArray.elementType(array));
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] inserted(T @NonNull [] array, int index, T value) {
        int size = array.length;
        T[] result = ObjectArray.ofType(size + 1, ObjectArray.elementType(array));
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] union(T @NonNull [] array, T @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] removed(T @NonNull [] array, T value) {
        void var3_3;
        int size = array.length;
        T[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                T element;
                if (!(element = result[n]).equals(value)) continue;
                --size;
            } while (++n < index);
        }
        result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        index = 0;
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T element;
                if (!(!(element = TArray[n2]).equals(value))) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] difference(T @NonNull [] array, T @NonNull [] from) {
        int size = array.length;
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        int index = 0;
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T v;
                if (ObjectArray.contains(from, v = TArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ObjectArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] intersection(T @NonNull [] array, T @NonNull [] with) {
        int size = array.length;
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        int index = 0;
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T v;
                if (!ObjectArray.contains(with, v = TArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ObjectArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <T, U> U @NonNull [] mapped(T @NonNull @NonNull [] array, @NonNull Function.Of1<T, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <T, U> U @NonNull [] flatMapped(T @NonNull @NonNull [] array, @NonNull Function.Of1<T, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T value = TArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] filtered(T @NonNull [] array, @NonNull Function.Of1<T, @Primitive Boolean> condition) {
        int size = array.length;
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        int index = 0;
        T[] TArray = array;
        int n = TArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                T v;
                if (!condition.apply(v = TArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ObjectArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] sorted(T @NonNull [] array) {
        void var1_1;
        Object[] result = ObjectArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static <T> boolean contains(T @NonNull [] array, T value) {
        return ObjectArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static <T> int indexOf(T @NonNull [] array, T value) {
        return ObjectArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static <T> int indexOf(T @NonNull [] array, T value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex].equals(value)) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static <T> int lastIndexOf(T @NonNull [] array, T value) {
        return ObjectArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static <T> int lastIndexOf(T @NonNull [] array, T value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex].equals(value)) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] copy(T @NonNull [] array) {
        return (Object[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] copy(T @NonNull [] array, int size) {
        void var2_2;
        T[] result = ObjectArray.ofType(size, ObjectArray.elementType(array));
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static <T> T @NonNull [] trim(T @NonNull [] array, int size) {
        return array.length <= size ? array : ObjectArray.copy(array, size);
    }

    @DyvilModifiers(value=0x230000L)
    public static <T> @NonNull Iterable<T> asIterable(T @NonNull [] array) {
        return ObjectArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static <T> @NonNull ImmutableList<T> asList(T @Immutable @NonNull [] array) {
        return ObjectArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static <T> @NonNull ImmutableList<T> toList(T @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<T>(array);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(Object[] array, Object[] other) {
        return Arrays.deepEquals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(Object[] array) {
        return Arrays.deepHashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static boolean arrayEquals(@Primitive Object lhs, @Primitive Object rhs) {
        return ObjectArray.equals(new Object[]{lhs}, new Object[]{rhs});
    }

    @DyvilModifiers(value=131072L)
    public static int arrayHashCode(@Primitive Object obj) {
        return ObjectArray.hashCode(new Object[]{obj});
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(Object[] array) {
        String string;
        Object[] objectArray = array;
        if (objectArray != null) {
            int size = objectArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            ObjectArray.append(objectArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(Object[] array, @NonNull StringBuilder builder) {
        Object[] objectArray = array;
        if (objectArray != null) {
            int size = objectArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            ObjectArray.append(objectArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(Object @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[");
        ObjectArray.arrayToString(array[0], builder);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ");
            ObjectArray.arrayToString(array[i], builder);
        }
        builder.append("]");
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String arrayToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> objectClass = obj.getClass();
        if (!objectClass.isArray()) {
            String string = obj.toString();
            string.getClass();
            return string;
        }
        if (objectClass == boolean[].class) {
            return BooleanArray.toString((boolean[])obj);
        }
        if (objectClass == byte[].class) {
            return ByteArray.toString((byte[])obj);
        }
        if (objectClass == short[].class) {
            return ShortArray.toString((short[])obj);
        }
        if (objectClass == char[].class) {
            return CharArray.toString((char[])obj);
        }
        if (objectClass == int[].class) {
            return IntArray.toString((int[])obj);
        }
        if (objectClass == long[].class) {
            return LongArray.toString((long[])obj);
        }
        if (objectClass == float[].class) {
            return FloatArray.toString((float[])obj);
        }
        if (objectClass == double[].class) {
            return DoubleArray.toString((double[])obj);
        }
        return ObjectArray.toString((Object[])obj);
    }

    @DyvilModifiers(value=131072L)
    public static void arrayToString(Object obj, @NonNull StringBuilder builder) {
        if (obj == null) {
            builder.append("null");
            return;
        }
        Class<?> objectClass = obj.getClass();
        if (!objectClass.isArray()) {
            builder.append(obj);
            return;
        }
        if (objectClass == boolean[].class) {
            BooleanArray.toString((boolean[])obj, builder);
            return;
        }
        if (objectClass == byte[].class) {
            ByteArray.toString((byte[])obj, builder);
            return;
        }
        if (objectClass == short[].class) {
            ShortArray.toString((short[])obj, builder);
            return;
        }
        if (objectClass == char[].class) {
            CharArray.toString((char[])obj, builder);
            return;
        }
        if (objectClass == int[].class) {
            IntArray.toString((int[])obj, builder);
            return;
        }
        if (objectClass == long[].class) {
            LongArray.toString((long[])obj, builder);
            return;
        }
        if (objectClass == float[].class) {
            FloatArray.toString((float[])obj, builder);
            return;
        }
        if (objectClass == double[].class) {
            DoubleArray.toString((double[])obj, builder);
            return;
        }
        ObjectArray.toString((Object[])obj, builder);
    }
}

