/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.range.closed.LongRange;
import dyvil.function.Function;
import dyvil.ref.LongRef;
import dyvil.ref.array.LongArrayRef;
import java.util.Arrays;

public abstract class LongArray {
    public static final long @Immutable @NonNull [] EMPTY = new long[0];

    private LongArray() {
    }

    @DyvilModifiers(value=65536L)
    public static long @NonNull [] apply() {
        return new long[0];
    }

    @DyvilModifiers(value=65536L)
    public static long @NonNull [] apply(int size) {
        return new long[size];
    }

    @DyvilModifiers(value=65536L)
    public static long @NonNull [] apply(long @NonNull [] array) {
        return LongArray.copy(array);
    }

    public static long @NonNull [] apply(@NonNull LongRange range) {
        return range.toLongArray();
    }

    /*
     * WARNING - void declaration
     */
    public static long @NonNull [] apply(int size, long repeatedValue) {
        void var3_2;
        long[] array = new long[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Long> valueSupplier) {
        void var2_2;
        long[] array = new long[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Long> valueMapper) {
        void var2_2;
        long[] array = new long[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    @DyvilName(value="apply")
    public static long @NonNull [] rangeClosed(long from, long to) {
        long[] array = new long[(int)(to - from + 1L)];
        int index = 0;
        long i = from;
        long l = to;
        while (i <= l) {
            array[index] = i++;
            ++index;
        }
        return array;
    }

    @DyvilName(value="apply")
    public static long @NonNull [] rangeOpen(long from, @DyvilModifiers(value=0x400000L) long toExclusive) {
        long[] array = new long[(int)(toExclusive - from)];
        int index = 0;
        long i = from;
        long l = toExclusive;
        while (i < l) {
            array[index] = i++;
            ++index;
        }
        return array;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(long @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(long @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(long @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 47})
    public static long subscript(long @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 80})
    public static void subscript_$eq(long @NonNull [] array, int index, long newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static long @NonNull [] subscript(long @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        long[] result = new long[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(long @NonNull [] array, @NonNull Range<@Primitive Integer> range, long @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull LongRef subscript_$amp(long @NonNull [] array, int index) {
        return new LongArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(long @NonNull [] array, @NonNull Function.Of1<@Primitive Long, @Primitive Void> action) {
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long value = lArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static long @NonNull [] $dot$dot$dot(long @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(long[] lhs, long[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(long[] lhs, long[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] added(long @NonNull [] array, long value) {
        int size = array.length;
        long[] result = new long[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] inserted(long @NonNull [] array, int index, long value) {
        int size = array.length;
        long[] result = new long[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] union(long @NonNull [] array, long @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        long[] result = new long[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] removed(long @NonNull [] array, long value) {
        int size = array.length;
        long[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                long element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new long[size];
        index = 0;
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long element;
                if ((element = lArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] difference(long @NonNull [] array, long @NonNull [] from) {
        int size = array.length;
        long[] result = new long[size];
        int index = 0;
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                if (LongArray.contains(from, v = lArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return LongArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] intersection(long @NonNull [] array, long @NonNull [] with) {
        int size = array.length;
        long[] result = new long[size];
        int index = 0;
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                if (!LongArray.contains(with, v = lArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return LongArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static long @NonNull [] mappedToLong(long @NonNull [] array, @NonNull Function.Of1<@Primitive Long, @Primitive Long> mapper) {
        void var3_3;
        int size = array.length;
        long[] result = new long[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(long @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Long, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] flatMappedToLong(long @NonNull [] array, @NonNull Function.Of1<@Primitive Long, long @NonNull []> mapper) {
        int size = 0;
        long[] result = new long[array.length << 2];
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                long[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = lArray[n2])).length) >= result.length) {
                    result = LongArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return LongArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(long @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Long, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long value = lArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] filtered(long @NonNull [] array, @NonNull Function.Of1<@Primitive Long, @Primitive Boolean> condition) {
        int size = array.length;
        long[] result = new long[size];
        int index = 0;
        long[] lArray = array;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                if (!condition.apply(v = lArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return LongArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static long @NonNull [] sorted(long @NonNull [] array) {
        void var1_1;
        long[] result = LongArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(long @NonNull [] array, long value) {
        return LongArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(long @NonNull [] array, long value) {
        return LongArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(long @NonNull [] array, long value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(long @NonNull [] array, long value) {
        return LongArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(long @NonNull [] array, long value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] copy(long @NonNull [] array) {
        return (long[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static long @NonNull [] copy(long @NonNull [] array, int size) {
        void var2_2;
        long[] result = new long[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static long @NonNull [] trim(long @NonNull [] array, int size) {
        return array.length <= size ? array : LongArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Long @NonNull [] boxed(long @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Long[] boxed = new Long[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Long> asIterable(long @NonNull [] array) {
        return LongArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Long> asList(long @Immutable @NonNull [] array) {
        return LongArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Long> toList(long @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Long>(LongArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(long[] array, long[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(long[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(long[] array) {
        String string;
        long[] lArray = array;
        if (lArray != null) {
            int size = lArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            LongArray.append(lArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(long[] array, @NonNull StringBuilder builder) {
        long[] lArray = array;
        if (lArray != null) {
            int size = lArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            LongArray.append(lArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(long @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

