/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.range.closed.IntRange;
import dyvil.function.Function;
import dyvil.ref.IntRef;
import dyvil.ref.array.IntArrayRef;
import java.util.Arrays;

public abstract class IntArray {
    public static final int @Immutable @NonNull [] EMPTY = new int[0];

    private IntArray() {
    }

    @DyvilModifiers(value=65536L)
    public static int @NonNull [] apply() {
        return new int[0];
    }

    @DyvilModifiers(value=65536L)
    public static int @NonNull [] apply(int size) {
        return new int[size];
    }

    @DyvilModifiers(value=65536L)
    public static int @NonNull [] apply(int @NonNull [] array) {
        return IntArray.copy(array);
    }

    public static int @NonNull [] apply(@NonNull IntRange range) {
        return range.toIntArray();
    }

    /*
     * WARNING - void declaration
     */
    public static int @NonNull [] apply(int size, int repeatedValue) {
        void var2_2;
        int[] array = new int[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Integer> valueSupplier) {
        void var2_2;
        int[] array = new int[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Integer> valueMapper) {
        void var2_2;
        int[] array = new int[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static int @NonNull [] rangeClosed(int from, int to) {
        void var2_2;
        int[] array = new int[to - from + 1];
        int index = 0;
        int i = from;
        int n = to;
        while (i <= n) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static int @NonNull [] rangeOpen(int from, @DyvilModifiers(value=0x400000L) int toExclusive) {
        void var2_2;
        int[] array = new int[toExclusive - from];
        int index = 0;
        int i = from;
        int n = toExclusive;
        while (i < n) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(int @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(int @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(int @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 46})
    public static int subscript(int @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 79})
    public static void subscript_$eq(int @NonNull [] array, int index, int newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] subscript(int @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        int[] result = new int[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(int @NonNull [] array, @NonNull Range<@Primitive Integer> range, int @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull IntRef subscript_$amp(int @NonNull [] array, int index) {
        return new IntArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(int @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, @Primitive Void> action) {
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int value = nArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static int @NonNull [] $dot$dot$dot(int @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(int[] lhs, int[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(int[] lhs, int[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] added(int @NonNull [] array, int value) {
        void var3_3;
        int size = array.length;
        int[] result = new int[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] inserted(int @NonNull [] array, int index, int value) {
        int size = array.length;
        int[] result = new int[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] union(int @NonNull [] array, int @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        int[] result = new int[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] removed(int @NonNull [] array, int value) {
        void var3_3;
        int size = array.length;
        int[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                int element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new int[size];
        index = 0;
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int element;
                if ((element = nArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] difference(int @NonNull [] array, int @NonNull [] from) {
        int size = array.length;
        int[] result = new int[size];
        int index = 0;
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                if (IntArray.contains(from, v = nArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return IntArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] intersection(int @NonNull [] array, int @NonNull [] with) {
        int size = array.length;
        int[] result = new int[size];
        int index = 0;
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                if (!IntArray.contains(with, v = nArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return IntArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] mappedToInt(int @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, @Primitive Integer> mapper) {
        void var3_3;
        int size = array.length;
        int[] result = new int[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(int @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] flatMappedToInt(int @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, int @NonNull []> mapper) {
        int size = 0;
        int[] result = new int[array.length << 2];
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                int[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = nArray[n2])).length) >= result.length) {
                    result = IntArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return IntArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(int @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int value = nArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] filtered(int @NonNull [] array, @NonNull Function.Of1<@Primitive Integer, @Primitive Boolean> condition) {
        int size = array.length;
        int[] result = new int[size];
        int index = 0;
        int[] nArray = array;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                if (!condition.apply(v = nArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return IntArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] sorted(int @NonNull [] array) {
        void var1_1;
        int[] result = IntArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(int @NonNull [] array, int value) {
        return IntArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(int @NonNull [] array, int value) {
        return IntArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(int @NonNull [] array, int value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(int @NonNull [] array, int value) {
        return IntArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(int @NonNull [] array, int value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] copy(int @NonNull [] array) {
        return (int[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static int @NonNull [] copy(int @NonNull [] array, int size) {
        void var2_2;
        int[] result = new int[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static int @NonNull [] trim(int @NonNull [] array, int size) {
        return array.length <= size ? array : IntArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Integer @NonNull [] boxed(int @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Integer[] boxed = new Integer[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Integer> asIterable(int @NonNull [] array) {
        return IntArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Integer> asList(int @Immutable @NonNull [] array) {
        return IntArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Integer> toList(int @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Integer>(IntArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(int[] array, int[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(int[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(int[] array) {
        String string;
        int[] nArray = array;
        if (nArray != null) {
            int size = nArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            IntArray.append(nArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(int[] array, @NonNull StringBuilder builder) {
        int[] nArray = array;
        if (nArray != null) {
            int size = nArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            IntArray.append(nArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(int @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

