/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.range.closed.FloatRange;
import dyvil.function.Function;
import dyvil.ref.FloatRef;
import dyvil.ref.array.FloatArrayRef;
import java.util.Arrays;

public abstract class FloatArray {
    public static final float @Immutable @NonNull [] EMPTY = new float[0];

    private FloatArray() {
    }

    @DyvilModifiers(value=65536L)
    public static float @NonNull [] apply() {
        return new float[0];
    }

    @DyvilModifiers(value=65536L)
    public static float @NonNull [] apply(int size) {
        return new float[size];
    }

    @DyvilModifiers(value=65536L)
    public static float @NonNull [] apply(float @NonNull [] array) {
        return FloatArray.copy(array);
    }

    public static float @NonNull [] apply(@NonNull FloatRange range) {
        return range.toFloatArray();
    }

    /*
     * WARNING - void declaration
     */
    public static float @NonNull [] apply(int size, float repeatedValue) {
        void var2_2;
        float[] array = new float[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Float> valueSupplier) {
        void var2_2;
        float[] array = new float[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply().floatValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Float> valueMapper) {
        void var2_2;
        float[] array = new float[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i).floatValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static float @NonNull [] rangeClosed(float from, float to) {
        void var2_2;
        float[] array = new float[(int)(to - from + 1.0f)];
        int index = 0;
        float f = to;
        for (float i = from; i <= f; i += 1.0f) {
            array[index] = i;
            ++index;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static float @NonNull [] rangeOpen(float from, @DyvilModifiers(value=0x400000L) float toExclusive) {
        void var2_2;
        float[] array = new float[(int)(toExclusive - from)];
        int index = 0;
        float f = toExclusive;
        for (float i = from; i < f; i += 1.0f) {
            array[index] = i;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(float @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(float @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(float @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 48})
    public static float subscript(float @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 81})
    public static void subscript_$eq(float @NonNull [] array, int index, float newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] subscript(float @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        float[] result = new float[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(float @NonNull [] array, @NonNull Range<@Primitive Integer> range, float @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull FloatRef subscript_$amp(float @NonNull [] array, int index) {
        return new FloatArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(float @NonNull [] array, @NonNull Function.Of1<@Primitive Float, @Primitive Void> action) {
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float value = fArray[n2];
                action.apply(Float.valueOf(value));
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static float @NonNull [] $dot$dot$dot(float @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(float[] lhs, float[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(float[] lhs, float[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] added(float @NonNull [] array, float value) {
        void var3_3;
        int size = array.length;
        float[] result = new float[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] inserted(float @NonNull [] array, int index, float value) {
        int size = array.length;
        float[] result = new float[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] union(float @NonNull [] array, float @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        float[] result = new float[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] removed(float @NonNull [] array, float value) {
        void var3_3;
        int size = array.length;
        float[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                float element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new float[size];
        index = 0;
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float element;
                if ((element = fArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] difference(float @NonNull [] array, float @NonNull [] from) {
        int size = array.length;
        float[] result = new float[size];
        int index = 0;
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                if (FloatArray.contains(from, v = fArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return FloatArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] intersection(float @NonNull [] array, float @NonNull [] with) {
        int size = array.length;
        float[] result = new float[size];
        int index = 0;
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                if (!FloatArray.contains(with, v = fArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return FloatArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] mappedToFloat(float @NonNull [] array, @NonNull Function.Of1<@Primitive Float, @Primitive Float> mapper) {
        void var3_3;
        int size = array.length;
        float[] result = new float[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(Float.valueOf(array[i])).floatValue();
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(float @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Float, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(Float.valueOf(array[i]));
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] flatMappedToFloat(float @NonNull [] array, @NonNull Function.Of1<@Primitive Float, float @NonNull []> mapper) {
        int size = 0;
        float[] result = new float[array.length << 2];
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                float[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(Float.valueOf(v = fArray[n2]))).length) >= result.length) {
                    result = FloatArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return FloatArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(float @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Float, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float value = fArray[n2];
                list.addAll(mapper.apply(Float.valueOf(value)));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] filtered(float @NonNull [] array, @NonNull Function.Of1<@Primitive Float, @Primitive Boolean> condition) {
        int size = array.length;
        float[] result = new float[size];
        int index = 0;
        float[] fArray = array;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                if (!condition.apply(Float.valueOf(v = fArray[n2])).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return FloatArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] sorted(float @NonNull [] array) {
        void var1_1;
        float[] result = FloatArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(float @NonNull [] array, float value) {
        return FloatArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(float @NonNull [] array, float value) {
        return FloatArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(float @NonNull [] array, float value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(float @NonNull [] array, float value) {
        return FloatArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(float @NonNull [] array, float value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] copy(float @NonNull [] array) {
        return (float[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static float @NonNull [] copy(float @NonNull [] array, int size) {
        void var2_2;
        float[] result = new float[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static float @NonNull [] trim(float @NonNull [] array, int size) {
        return array.length <= size ? array : FloatArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Float @NonNull [] boxed(float @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Float[] boxed = new Float[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = Float.valueOf(array[i]);
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Float> asIterable(float @NonNull [] array) {
        return FloatArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Float> asList(float @Immutable @NonNull [] array) {
        return FloatArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Float> toList(float @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Float>(FloatArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(float[] array, float[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(float[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(float[] array) {
        String string;
        float[] fArray = array;
        if (fArray != null) {
            int size = fArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            FloatArray.append(fArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(float[] array, @NonNull StringBuilder builder) {
        float[] fArray = array;
        if (fArray != null) {
            int size = fArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            FloatArray.append(fArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(float @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

