/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.range.closed.DoubleRange;
import dyvil.function.Function;
import dyvil.ref.DoubleRef;
import dyvil.ref.array.DoubleArrayRef;
import java.util.Arrays;

public abstract class DoubleArray {
    public static final double @Immutable @NonNull [] EMPTY = new double[0];

    private DoubleArray() {
    }

    @DyvilModifiers(value=65536L)
    public static double @NonNull [] apply() {
        return new double[0];
    }

    @DyvilModifiers(value=65536L)
    public static double @NonNull [] apply(int size) {
        return new double[size];
    }

    @DyvilModifiers(value=65536L)
    public static double @NonNull [] apply(double @NonNull [] array) {
        return DoubleArray.copy(array);
    }

    public static double @NonNull [] apply(@NonNull DoubleRange range) {
        return range.toDoubleArray();
    }

    /*
     * WARNING - void declaration
     */
    public static double @NonNull [] apply(int size, double repeatedValue) {
        void var3_2;
        double[] array = new double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Double> valueSupplier) {
        void var2_2;
        double[] array = new double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Double> valueMapper) {
        void var2_2;
        double[] array = new double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    @DyvilName(value="apply")
    public static double @NonNull [] rangeClosed(double from, double to) {
        double[] array = new double[(int)(to - from + 1.0)];
        int index = 0;
        double d = to;
        for (double i = from; i <= d; i += 1.0) {
            array[index] = i;
            ++index;
        }
        return array;
    }

    @DyvilName(value="apply")
    public static double @NonNull [] rangeOpen(double from, @DyvilModifiers(value=0x400000L) double toExclusive) {
        double[] array = new double[(int)(toExclusive - from)];
        int index = 0;
        double d = toExclusive;
        for (double i = from; i < d; i += 1.0) {
            array[index] = i;
            ++index;
        }
        return array;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(double @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(double @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(double @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 49})
    public static double subscript(double @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 82})
    public static void subscript_$eq(double @NonNull [] array, int index, double newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static double @NonNull [] subscript(double @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        double[] result = new double[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(double @NonNull [] array, @NonNull Range<@Primitive Integer> range, double @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull DoubleRef subscript_$amp(double @NonNull [] array, int index) {
        return new DoubleArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(double @NonNull [] array, @NonNull Function.Of1<@Primitive Double, @Primitive Void> action) {
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double value = dArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static double @NonNull [] $dot$dot$dot(double @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(double[] lhs, double[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(double[] lhs, double[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] added(double @NonNull [] array, double value) {
        int size = array.length;
        double[] result = new double[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] inserted(double @NonNull [] array, int index, double value) {
        int size = array.length;
        double[] result = new double[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] union(double @NonNull [] array, double @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        double[] result = new double[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] removed(double @NonNull [] array, double value) {
        int size = array.length;
        double[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                double element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new double[size];
        index = 0;
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double element;
                if ((element = dArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] difference(double @NonNull [] array, double @NonNull [] from) {
        int size = array.length;
        double[] result = new double[size];
        int index = 0;
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                if (DoubleArray.contains(from, v = dArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return DoubleArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] intersection(double @NonNull [] array, double @NonNull [] with) {
        int size = array.length;
        double[] result = new double[size];
        int index = 0;
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                if (!DoubleArray.contains(with, v = dArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return DoubleArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static double @NonNull [] mappedToDouble(double @NonNull [] array, @NonNull Function.Of1<@Primitive Double, @Primitive Double> mapper) {
        void var3_3;
        int size = array.length;
        double[] result = new double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(double @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Double, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] flatMappedToDouble(double @NonNull [] array, @NonNull Function.Of1<@Primitive Double, double @NonNull []> mapper) {
        int size = 0;
        double[] result = new double[array.length << 2];
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                double[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = dArray[n2])).length) >= result.length) {
                    result = DoubleArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return DoubleArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(double @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Double, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double value = dArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] filtered(double @NonNull [] array, @NonNull Function.Of1<@Primitive Double, @Primitive Boolean> condition) {
        int size = array.length;
        double[] result = new double[size];
        int index = 0;
        double[] dArray = array;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                if (!condition.apply(v = dArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return DoubleArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static double @NonNull [] sorted(double @NonNull [] array) {
        void var1_1;
        double[] result = DoubleArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(double @NonNull [] array, double value) {
        return DoubleArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(double @NonNull [] array, double value) {
        return DoubleArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(double @NonNull [] array, double value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(double @NonNull [] array, double value) {
        return DoubleArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(double @NonNull [] array, double value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] copy(double @NonNull [] array) {
        return (double[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static double @NonNull [] copy(double @NonNull [] array, int size) {
        void var2_2;
        double[] result = new double[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static double @NonNull [] trim(double @NonNull [] array, int size) {
        return array.length <= size ? array : DoubleArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Double @NonNull [] boxed(double @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Double[] boxed = new Double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Double> asIterable(double @NonNull [] array) {
        return DoubleArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Double> asList(double @Immutable @NonNull [] array) {
        return DoubleArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Double> toList(double @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Double>(DoubleArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(double[] array, double[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(double[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(double[] array) {
        String string;
        double[] dArray = array;
        if (dArray != null) {
            int size = dArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            DoubleArray.append(dArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(double[] array, @NonNull StringBuilder builder) {
        double[] dArray = array;
        if (dArray != null) {
            int size = dArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            DoubleArray.append(dArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(double @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

