/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.function.Function;
import dyvil.ref.CharRef;
import dyvil.ref.array.CharArrayRef;
import java.util.Arrays;

public abstract class CharArray {
    public static final char @Immutable @NonNull [] EMPTY = new char[0];

    private CharArray() {
    }

    @DyvilModifiers(value=65536L)
    public static char @NonNull [] apply() {
        return new char[0];
    }

    @DyvilModifiers(value=65536L)
    public static char @NonNull [] apply(int size) {
        return new char[size];
    }

    @DyvilModifiers(value=65536L)
    public static char @NonNull [] apply(char @NonNull [] array) {
        return CharArray.copy(array);
    }

    /*
     * WARNING - void declaration
     */
    public static char @NonNull [] apply(int size, char repeatedValue) {
        void var2_2;
        char[] array = new char[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Character> valueSupplier) {
        void var2_2;
        char[] array = new char[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply().charValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Character> valueMapper) {
        void var2_2;
        char[] array = new char[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i).charValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static char @NonNull [] rangeClosed(char from, char to) {
        void var2_2;
        char[] array = new char[to - from + 1];
        int index = 0;
        int i = from;
        char c = to;
        while (i <= c) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static char @NonNull [] rangeOpen(char from, @DyvilModifiers(value=0x400000L) char toExclusive) {
        void var2_2;
        char[] array = new char[toExclusive - from];
        int index = 0;
        int i = from;
        char c = toExclusive;
        while (i < c) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(char @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(char @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(char @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 52})
    public static char subscript(char @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 85})
    public static void subscript_$eq(char @NonNull [] array, int index, char newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] subscript(char @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        char[] result = new char[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(char @NonNull [] array, @NonNull Range<@Primitive Integer> range, char @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull CharRef subscript_$amp(char @NonNull [] array, int index) {
        return new CharArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(char @NonNull [] array, @NonNull Function.Of1<@Primitive Character, @Primitive Void> action) {
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char value = cArray[n2];
                action.apply(Character.valueOf(value));
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static char @NonNull [] $dot$dot$dot(char @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(char[] lhs, char[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(char[] lhs, char[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] added(char @NonNull [] array, char value) {
        void var3_3;
        int size = array.length;
        char[] result = new char[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] inserted(char @NonNull [] array, int index, char value) {
        int size = array.length;
        char[] result = new char[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] union(char @NonNull [] array, char @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        char[] result = new char[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] removed(char @NonNull [] array, char value) {
        void var3_3;
        int size = array.length;
        char[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                char element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new char[size];
        index = 0;
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char element;
                if ((element = cArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] difference(char @NonNull [] array, char @NonNull [] from) {
        int size = array.length;
        char[] result = new char[size];
        int index = 0;
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char v;
                if (CharArray.contains(from, v = cArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return CharArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] intersection(char @NonNull [] array, char @NonNull [] with) {
        int size = array.length;
        char[] result = new char[size];
        int index = 0;
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char v;
                if (!CharArray.contains(with, v = cArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return CharArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] mappedToChar(char @NonNull [] array, @NonNull Function.Of1<@Primitive Character, @Primitive Character> mapper) {
        void var3_3;
        int size = array.length;
        char[] result = new char[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(Character.valueOf(array[i])).charValue();
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(char @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Character, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(Character.valueOf(array[i]));
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] flatMappedToChar(char @NonNull [] array, @NonNull Function.Of1<@Primitive Character, char @NonNull []> mapper) {
        int size = 0;
        char[] result = new char[array.length << 2];
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char v;
                char[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(Character.valueOf(v = cArray[n2]))).length) >= result.length) {
                    result = CharArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return CharArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(char @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Character, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char value = cArray[n2];
                list.addAll(mapper.apply(Character.valueOf(value)));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] filtered(char @NonNull [] array, @NonNull Function.Of1<@Primitive Character, @Primitive Boolean> condition) {
        int size = array.length;
        char[] result = new char[size];
        int index = 0;
        char[] cArray = array;
        int n = cArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                char v;
                if (!condition.apply(Character.valueOf(v = cArray[n2])).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return CharArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] sorted(char @NonNull [] array) {
        void var1_1;
        char[] result = CharArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(char @NonNull [] array, char value) {
        return CharArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(char @NonNull [] array, char value) {
        return CharArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(char @NonNull [] array, char value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(char @NonNull [] array, char value) {
        return CharArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(char @NonNull [] array, char value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] copy(char @NonNull [] array) {
        return (char[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static char @NonNull [] copy(char @NonNull [] array, int size) {
        void var2_2;
        char[] result = new char[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static char @NonNull [] trim(char @NonNull [] array, int size) {
        return array.length <= size ? array : CharArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Character @NonNull [] boxed(char @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Character[] boxed = new Character[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = Character.valueOf(array[i]);
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Character> asIterable(char @NonNull [] array) {
        return CharArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Character> asList(char @Immutable @NonNull [] array) {
        return CharArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Character> toList(char @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Character>(CharArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(char[] array, char[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(char[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(char[] array) {
        String string;
        char[] cArray = array;
        if (cArray != null) {
            int size = cArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            CharArray.append(cArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(char[] array, @NonNull StringBuilder builder) {
        char[] cArray = array;
        if (cArray != null) {
            int size = cArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            CharArray.append(cArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(char @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

