/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.function.Function;
import dyvil.ref.ByteRef;
import dyvil.ref.array.ByteArrayRef;
import java.util.Arrays;

public abstract class ByteArray {
    public static final byte @Immutable @NonNull [] EMPTY = new byte[0];

    private ByteArray() {
    }

    @DyvilModifiers(value=65536L)
    public static byte @NonNull [] apply() {
        return new byte[0];
    }

    @DyvilModifiers(value=65536L)
    public static byte @NonNull [] apply(int size) {
        return new byte[size];
    }

    @DyvilModifiers(value=65536L)
    public static byte @NonNull [] apply(byte @NonNull [] array) {
        return ByteArray.copy(array);
    }

    /*
     * WARNING - void declaration
     */
    public static byte @NonNull [] apply(int size, byte repeatedValue) {
        void var2_2;
        byte[] array = new byte[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Byte> valueSupplier) {
        void var2_2;
        byte[] array = new byte[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Byte> valueMapper) {
        void var2_2;
        byte[] array = new byte[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static byte @NonNull [] rangeClosed(byte from, byte to) {
        void var2_2;
        byte[] array = new byte[to - from + 1];
        int index = 0;
        int i = from;
        byte by = to;
        while (i <= by) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilName(value="apply")
    public static byte @NonNull [] rangeOpen(byte from, @DyvilModifiers(value=0x400000L) byte toExclusive) {
        void var2_2;
        byte[] array = new byte[toExclusive - from];
        int index = 0;
        int i = from;
        byte by = toExclusive;
        while (i < by) {
            array[index] = i++;
            ++index;
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(byte @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(byte @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(byte @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 51})
    public static byte subscript(byte @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 84})
    public static void subscript_$eq(byte @NonNull [] array, int index, byte newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] subscript(byte @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        byte[] result = new byte[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(byte @NonNull [] array, @NonNull Range<@Primitive Integer> range, byte @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull ByteRef subscript_$amp(byte @NonNull [] array, int index) {
        return new ByteArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(byte @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, @Primitive Void> action) {
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte value = byArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static byte @NonNull [] $dot$dot$dot(byte @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(byte[] lhs, byte[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(byte[] lhs, byte[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] added(byte @NonNull [] array, byte value) {
        void var3_3;
        int size = array.length;
        byte[] result = new byte[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] inserted(byte @NonNull [] array, int index, byte value) {
        int size = array.length;
        byte[] result = new byte[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] union(byte @NonNull [] array, byte @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        byte[] result = new byte[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] removed(byte @NonNull [] array, byte value) {
        void var3_3;
        int size = array.length;
        byte[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                byte element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new byte[size];
        index = 0;
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte element;
                if ((element = byArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] difference(byte @NonNull [] array, byte @NonNull [] from) {
        int size = array.length;
        byte[] result = new byte[size];
        int index = 0;
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte v;
                if (ByteArray.contains(from, v = byArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ByteArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] intersection(byte @NonNull [] array, byte @NonNull [] with) {
        int size = array.length;
        byte[] result = new byte[size];
        int index = 0;
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte v;
                if (!ByteArray.contains(with, v = byArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ByteArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] mappedToByte(byte @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, @Primitive Byte> mapper) {
        void var3_3;
        int size = array.length;
        byte[] result = new byte[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(byte @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] flatMappedToByte(byte @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, byte @NonNull []> mapper) {
        int size = 0;
        byte[] result = new byte[array.length << 2];
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte v;
                byte[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = byArray[n2])).length) >= result.length) {
                    result = ByteArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return ByteArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(byte @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte value = byArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] filtered(byte @NonNull [] array, @NonNull Function.Of1<@Primitive Byte, @Primitive Boolean> condition) {
        int size = array.length;
        byte[] result = new byte[size];
        int index = 0;
        byte[] byArray = array;
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                byte v;
                if (!condition.apply(v = byArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return ByteArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] sorted(byte @NonNull [] array) {
        void var1_1;
        byte[] result = ByteArray.copy(array);
        Arrays.sort(result);
        return var1_1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(byte @NonNull [] array, byte value) {
        return ByteArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(byte @NonNull [] array, byte value) {
        return ByteArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(byte @NonNull [] array, byte value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(byte @NonNull [] array, byte value) {
        return ByteArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(byte @NonNull [] array, byte value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] copy(byte @NonNull [] array) {
        return (byte[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] copy(byte @NonNull [] array, int size) {
        void var2_2;
        byte[] result = new byte[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static byte @NonNull [] trim(byte @NonNull [] array, int size) {
        return array.length <= size ? array : ByteArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Byte @NonNull [] boxed(byte @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Byte[] boxed = new Byte[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Byte> asIterable(byte @NonNull [] array) {
        return ByteArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Byte> asList(byte @Immutable @NonNull [] array) {
        return ByteArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Byte> toList(byte @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Byte>(ByteArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(byte[] array, byte[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(byte[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(byte[] array) {
        String string;
        byte[] byArray = array;
        if (byArray != null) {
            int size = byArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            ByteArray.append(byArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(byte[] array, @NonNull StringBuilder builder) {
        byte[] byArray = array;
        if (byArray != null) {
            int size = byArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            ByteArray.append(byArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(byte @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append((char)array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append((char)array[i]);
        }
        builder.append("]");
    }
}

