/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.Mutating;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.ObjectArray;
import dyvil.collection.ImmutableList;
import dyvil.collection.Range;
import dyvil.collection.mutable.ArrayList;
import dyvil.function.Function;
import dyvil.ref.BooleanRef;
import dyvil.ref.array.BooleanArrayRef;
import java.util.Arrays;

public abstract class BooleanArray {
    public static final boolean @Immutable @NonNull [] EMPTY = new boolean[0];

    private BooleanArray() {
    }

    @DyvilModifiers(value=65536L)
    public static boolean @NonNull [] apply() {
        return new boolean[0];
    }

    @DyvilModifiers(value=65536L)
    public static boolean @NonNull [] apply(int size) {
        return new boolean[size];
    }

    @DyvilModifiers(value=65536L)
    public static boolean @NonNull [] apply(boolean @NonNull [] array) {
        return BooleanArray.copy(array);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean @NonNull [] apply(int size, boolean repeatedValue) {
        void var2_2;
        boolean[] array = new boolean[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = repeatedValue;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean @NonNull [] apply(int size, @NonNull Function.Of0<@Primitive Boolean> valueSupplier) {
        void var2_2;
        boolean[] array = new boolean[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueSupplier.apply();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean @NonNull [] apply(int size, @NonNull Function.Of1<@Primitive Integer, @Primitive Boolean> valueMapper) {
        void var2_2;
        boolean[] array = new boolean[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            array[i] = valueMapper.apply(i);
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190})
    public static int size(boolean @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40000000L)
    @Intrinsic(value={-1, 190})
    public static int $bar_$bar(boolean @NonNull [] array) {
        return array.length;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, 190, 348})
    public static boolean isEmpty(boolean @NonNull [] array) {
        return array.length == 0;
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, 51})
    public static boolean subscript(boolean @NonNull [] array, int index) {
        return array[index];
    }

    @Mutating
    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={-1, -2, -3, 84})
    public static void subscript_$eq(boolean @NonNull [] array, int index, boolean newValue) {
        array[index] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] subscript(boolean @NonNull [] array, @NonNull Range<@Primitive Integer> range) {
        void var3_3;
        int size = range.size();
        boolean[] result = new boolean[size];
        System.arraycopy(array, range.first(), result, 0, size);
        return var3_3;
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static void subscript_$eq(boolean @NonNull [] array, @NonNull Range<@Primitive Integer> range, boolean @NonNull [] newValues) {
        System.arraycopy(newValues, 0, array, range.first(), range.size());
    }

    @Mutating
    @DyvilModifiers(value=131072L)
    public static @NonNull BooleanRef subscript_$amp(boolean @NonNull [] array, int index) {
        return new BooleanArrayRef(array, index);
    }

    @DyvilModifiers(value=131072L)
    public static void forEach(boolean @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, @Primitive Void> action) {
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean value = blArray[n2];
                action.apply(value);
            } while (++n2 < n);
        }
    }

    @DyvilModifiers(value=0x40020000L)
    @Intrinsic(value={}, compilerCode=6)
    public static boolean @NonNull [] $dot$dot$dot(boolean @NonNull [] array) {
        return array;
    }

    @DyvilModifiers(value=196608L)
    public static boolean $eq$eq(boolean[] lhs, boolean[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $bang$eq(boolean[] lhs, boolean[] rhs) {
        return !Arrays.equals(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] added(boolean @NonNull [] array, boolean value) {
        void var3_3;
        int size = array.length;
        boolean[] result = new boolean[size + 1];
        System.arraycopy(array, 0, result, 0, size);
        result[size] = value;
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] inserted(boolean @NonNull [] array, int index, boolean value) {
        int size = array.length;
        boolean[] result = new boolean[size + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, size - index);
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] union(boolean @NonNull [] array, boolean @NonNull [] with) {
        int size1 = array.length;
        int size2 = with.length;
        int size = size1 + size2;
        boolean[] result = new boolean[size];
        System.arraycopy(array, 0, result, 0, size1);
        System.arraycopy(with, 0, result, size1, size2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] removed(boolean @NonNull [] array, boolean value) {
        void var3_3;
        int size = array.length;
        boolean[] result = array;
        int index = result.length;
        if (index > 0) {
            int n = 0;
            do {
                boolean element;
                if ((element = result[n]) != value) continue;
                --size;
            } while (++n < index);
        }
        result = new boolean[size];
        index = 0;
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean element;
                if ((element = blArray[n2]) == value) continue;
                result[index] = element;
                ++index;
            } while (++n2 < n);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] difference(boolean @NonNull [] array, boolean @NonNull [] from) {
        int size = array.length;
        boolean[] result = new boolean[size];
        int index = 0;
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean v;
                if (BooleanArray.contains(from, v = blArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return BooleanArray.trim(result, index);
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] intersection(boolean @NonNull [] array, boolean @NonNull [] with) {
        int size = array.length;
        boolean[] result = new boolean[size];
        int index = 0;
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean v;
                if (!BooleanArray.contains(with, v = blArray[n2])) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return BooleanArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] mappedToBoolean(boolean @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, @Primitive Boolean> mapper) {
        void var3_3;
        int size = array.length;
        boolean[] result = new boolean[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return var3_3;
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] mapped(boolean @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, U> mapper, Class clazz) {
        int size = array.length;
        T[] result = ObjectArray.apply(size, clazz);
        int n = size;
        for (int i = 0; i < n; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] flatMappedToBoolean(boolean @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, boolean @NonNull []> mapper) {
        int size = 0;
        boolean[] result = new boolean[array.length << 2];
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean v;
                boolean[] inner;
                int newSize;
                if (size + (newSize = (inner = mapper.apply(v = blArray[n2])).length) >= result.length) {
                    result = BooleanArray.copy(result, size + newSize << 1);
                }
                System.arraycopy(inner, 0, result, size, newSize);
                size += newSize;
            } while (++n2 < n);
        }
        return BooleanArray.trim(result, size);
    }

    @DyvilModifiers(value=131072L)
    @OverloadPriority
    public static <U> U @NonNull [] flatMapped(boolean @NonNull @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, @NonNull Iterable<? extends U>> mapper, Class clazz) {
        ArrayList<? extends U> list = new ArrayList<U>(array.length << 2);
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean value = blArray[n2];
                list.addAll(mapper.apply(value));
            } while (++n2 < n);
        }
        return list.toArray(clazz);
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] filtered(boolean @NonNull [] array, @NonNull Function.Of1<@Primitive Boolean, @Primitive Boolean> condition) {
        int size = array.length;
        boolean[] result = new boolean[size];
        int index = 0;
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean v;
                if (!condition.apply(v = blArray[n2]).booleanValue()) continue;
                result[index] = v;
                ++index;
            } while (++n2 < n);
        }
        return BooleanArray.trim(result, index);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] sorted(boolean @NonNull [] array) {
        void var2_2;
        int size = array.length;
        boolean[] result = new boolean[size];
        int falseEntries = 0;
        boolean[] blArray = array;
        int n = blArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                boolean value;
                if (value = blArray[n2]) continue;
                ++falseEntries;
            } while (++n2 < n);
        }
        n = size;
        for (int i = falseEntries; i < n; ++i) {
            result[i] = true;
        }
        return var2_2;
    }

    @DyvilModifiers(value=196608L)
    public static boolean contains(boolean @NonNull [] array, boolean value) {
        return BooleanArray.indexOf(array, value, 0) >= 0;
    }

    @DyvilModifiers(value=196608L)
    public static int indexOf(boolean @NonNull [] array, boolean value) {
        return BooleanArray.indexOf(array, value, 0);
    }

    @DyvilModifiers(value=131072L)
    public static int indexOf(boolean @NonNull [] array, boolean value, int startIndex) {
        while (startIndex < array.length) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(boolean @NonNull [] array, boolean value) {
        return BooleanArray.lastIndexOf(array, value, array.length - 1);
    }

    @DyvilModifiers(value=131072L)
    public static int lastIndexOf(boolean @NonNull [] array, boolean value, int startIndex) {
        while (startIndex >= 0) {
            if (array[startIndex] == value) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] copy(boolean @NonNull [] array) {
        return (boolean[])array.clone();
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] copy(boolean @NonNull [] array, int size) {
        void var2_2;
        boolean[] result = new boolean[size];
        System.arraycopy(array, 0, result, 0, Math.min(size, array.length));
        return var2_2;
    }

    @DyvilModifiers(value=131072L)
    public static boolean @NonNull [] trim(boolean @NonNull [] array, int size) {
        return array.length <= size ? array : BooleanArray.copy(array, size);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=131072L)
    public static @NonNull Boolean @NonNull [] boxed(boolean @NonNull [] array) {
        void var2_2;
        int size = array.length;
        Boolean[] boxed = new Boolean[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            boxed[i] = array[i];
        }
        return var2_2;
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull Iterable<@Primitive Boolean> asIterable(boolean @NonNull [] array) {
        return BooleanArray.toList(array);
    }

    @DyvilModifiers(value=0x230000L)
    public static @NonNull ImmutableList<@Primitive Boolean> asList(boolean @Immutable @NonNull [] array) {
        return BooleanArray.toList(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull ImmutableList<@Primitive Boolean> toList(boolean @NonNull [] array) {
        return new dyvil.collection.immutable.ArrayList<Boolean>(BooleanArray.boxed(array), true);
    }

    @DyvilModifiers(value=196608L)
    public static boolean equals(boolean[] array, boolean[] other) {
        return Arrays.equals(array, other);
    }

    @DyvilModifiers(value=196608L)
    public static int hashCode(boolean[] array) {
        return Arrays.hashCode(array);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull String toString(boolean[] array) {
        String string;
        boolean[] blArray = array;
        if (blArray != null) {
            int size = blArray.length;
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            BooleanArray.append(blArray, size, builder);
            string = builder.toString();
        } else {
            string = "null";
        }
        return string;
    }

    @DyvilModifiers(value=131072L)
    public static void toString(boolean[] array, @NonNull StringBuilder builder) {
        boolean[] blArray = array;
        if (blArray != null) {
            int size = blArray.length;
            if (size == 0) {
                builder.append("[]");
                return;
            }
            BooleanArray.append(blArray, size, builder);
        } else {
            builder.append("null");
        }
    }

    private static void append(boolean @NonNull [] array, int size, @NonNull StringBuilder builder) {
        builder.append("[").append(array[0]);
        int n = size;
        for (int i = 1; i < n; ++i) {
            builder.append(", ").append(array[i]);
        }
        builder.append("]");
    }
}

