/*
 * Decompiled with CFR 0.152.
 */
package dyvil.array;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.array.BooleanArray;
import dyvil.array.ByteArray;
import dyvil.array.CharArray;
import dyvil.array.DoubleArray;
import dyvil.array.FloatArray;
import dyvil.array.IntArray;
import dyvil.array.LongArray;
import dyvil.array.ObjectArray;
import dyvil.array.ShortArray;

public abstract class ArrayOperators {
    private ArrayOperators() {
    }

    @DyvilModifiers(value=196608L)
    public static <T> boolean in(T value, T @NonNull [] array) {
        return ObjectArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static <T> boolean $qmark(T @NonNull [] lhs, T rhs) {
        return ObjectArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] $plus(T @NonNull [] lhs, T rhs) {
        return ObjectArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] $plus(T lhs, T @NonNull [] rhs) {
        return ObjectArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] $plus$plus(T @NonNull [] lhs, T @NonNull [] rhs) {
        return ObjectArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] $minus(T @NonNull [] lhs, T rhs) {
        return ObjectArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static <T> T @NonNull [] $minus$minus(T @NonNull [] lhs, T @NonNull [] rhs) {
        return ObjectArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(boolean value, boolean @NonNull [] array) {
        return BooleanArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(boolean @NonNull [] lhs, boolean rhs) {
        return BooleanArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] $plus(boolean @NonNull [] lhs, boolean rhs) {
        return BooleanArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] $plus(boolean lhs, boolean @NonNull [] rhs) {
        return BooleanArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] $plus$plus(boolean @NonNull [] lhs, boolean @NonNull [] rhs) {
        return BooleanArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] $minus(boolean @NonNull [] lhs, boolean rhs) {
        return BooleanArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean @NonNull [] $minus$minus(boolean @NonNull [] lhs, boolean @NonNull [] rhs) {
        return BooleanArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(byte value, byte @NonNull [] array) {
        return ByteArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(byte @NonNull [] lhs, byte rhs) {
        return ByteArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] $plus(byte @NonNull [] lhs, byte rhs) {
        return ByteArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] $plus(byte lhs, byte @NonNull [] rhs) {
        return ByteArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] $plus$plus(byte @NonNull [] lhs, byte @NonNull [] rhs) {
        return ByteArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] $minus(byte @NonNull [] lhs, byte rhs) {
        return ByteArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static byte @NonNull [] $minus$minus(byte @NonNull [] lhs, byte @NonNull [] rhs) {
        return ByteArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(short value, short @NonNull [] array) {
        return ShortArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(short @NonNull [] lhs, short rhs) {
        return ShortArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] $plus(short @NonNull [] lhs, short rhs) {
        return ShortArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] $plus(short lhs, short @NonNull [] rhs) {
        return ShortArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] $plus$plus(short @NonNull [] lhs, short @NonNull [] rhs) {
        return ShortArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] $minus(short @NonNull [] lhs, short rhs) {
        return ShortArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static short @NonNull [] $minus$minus(short @NonNull [] lhs, short @NonNull [] rhs) {
        return ShortArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(char value, char @NonNull [] array) {
        return CharArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(char @NonNull [] lhs, char rhs) {
        return CharArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] $plus(char @NonNull [] lhs, char rhs) {
        return CharArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] $plus(char lhs, char @NonNull [] rhs) {
        return CharArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] $plus$plus(char @NonNull [] lhs, char @NonNull [] rhs) {
        return CharArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] $minus(char @NonNull [] lhs, char rhs) {
        return CharArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static char @NonNull [] $minus$minus(char @NonNull [] lhs, char @NonNull [] rhs) {
        return CharArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(int value, int @NonNull [] array) {
        return IntArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(int @NonNull [] lhs, int rhs) {
        return IntArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] $plus(int @NonNull [] lhs, int rhs) {
        return IntArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] $plus(int lhs, int @NonNull [] rhs) {
        return IntArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] $plus$plus(int @NonNull [] lhs, int @NonNull [] rhs) {
        return IntArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] $minus(int @NonNull [] lhs, int rhs) {
        return IntArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static int @NonNull [] $minus$minus(int @NonNull [] lhs, int @NonNull [] rhs) {
        return IntArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(long value, long @NonNull [] array) {
        return LongArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(long @NonNull [] lhs, long rhs) {
        return LongArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] $plus(long @NonNull [] lhs, long rhs) {
        return LongArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] $plus(long lhs, long @NonNull [] rhs) {
        return LongArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] $plus$plus(long @NonNull [] lhs, long @NonNull [] rhs) {
        return LongArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] $minus(long @NonNull [] lhs, long rhs) {
        return LongArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static long @NonNull [] $minus$minus(long @NonNull [] lhs, long @NonNull [] rhs) {
        return LongArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(float value, float @NonNull [] array) {
        return FloatArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(float @NonNull [] lhs, float rhs) {
        return FloatArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] $plus(float @NonNull [] lhs, float rhs) {
        return FloatArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] $plus(float lhs, float @NonNull [] rhs) {
        return FloatArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] $plus$plus(float @NonNull [] lhs, float @NonNull [] rhs) {
        return FloatArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] $minus(float @NonNull [] lhs, float rhs) {
        return FloatArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static float @NonNull [] $minus$minus(float @NonNull [] lhs, float @NonNull [] rhs) {
        return FloatArray.difference(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static boolean in(double value, double @NonNull [] array) {
        return DoubleArray.contains(array, value);
    }

    @DyvilModifiers(value=196608L)
    public static boolean $qmark(double @NonNull [] lhs, double rhs) {
        return DoubleArray.contains(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] $plus(double @NonNull [] lhs, double rhs) {
        return DoubleArray.added(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] $plus(double lhs, double @NonNull [] rhs) {
        return DoubleArray.added(rhs, lhs);
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] $plus$plus(double @NonNull [] lhs, double @NonNull [] rhs) {
        return DoubleArray.union(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] $minus(double @NonNull [] lhs, double rhs) {
        return DoubleArray.removed(lhs, rhs);
    }

    @DyvilModifiers(value=196608L)
    public static double @NonNull [] $minus$minus(double @NonNull [] lhs, double @NonNull [] rhs) {
        return DoubleArray.difference(lhs, rhs);
    }
}

