/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.CharactersEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.load.text.TextTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TokenizerByChar
implements TextTokenizer {
    private final Map<Character, TextEvent> recycling = new HashMap<Character, TextEvent>();

    @Override
    public List<TextEvent> tokenize(CharSequence seq) {
        if (seq == null) {
            return null;
        }
        if (seq.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TextEvent> events = new ArrayList<TextEvent>(seq.length());
        Character c = null;
        for (int i = 0; i < seq.length(); ++i) {
            c = Character.valueOf(seq.charAt(i));
            TextEvent e = this.recycling.get(c);
            if (e == null) {
                e = Character.isWhitespace(c.charValue()) ? SpaceEvent.getInstance(c.charValue()) : new CharactersEvent("" + c);
            }
            events.add(e);
        }
        return events;
    }

    @Override
    public TextGranularity granurality() {
        return TextGranularity.CHARACTER;
    }
}

