/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.Matrix;

public final class MatrixShort
implements Matrix {
    private short[][] matrix;

    @Override
    public void setup(int width, int height) {
        this.matrix = new short[width][height];
    }

    @Override
    public void set(int i, int j, int x) {
        this.matrix[i][j] = (short)x;
    }

    @Override
    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    @Override
    public void incrementPathBy(int i, int j, int n) {
        this.matrix[i][j] = (short)(this.matrix[i + 1][j + 1] + n);
    }

    @Override
    public void incrementByMaxPath(int i, int j) {
        this.matrix[i][j] = MatrixShort.max(this.matrix[i + 1][j], this.matrix[i][j + 1]);
    }

    @Override
    public boolean isGreaterX(int i, int j) {
        return this.matrix[i + 1][j] > this.matrix[i][j + 1];
    }

    @Override
    public boolean isGreaterY(int i, int j) {
        return this.matrix[i + 1][j] < this.matrix[i][j + 1];
    }

    @Override
    public boolean isSameXY(int i, int j) {
        return this.matrix[i + 1][j] == this.matrix[i][j + 1];
    }

    private static short max(short a, short b) {
        return a >= b ? a : b;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (int j = 0; j < this.matrix[0].length; ++j) {
            for (short[] element : this.matrix) {
                out.append(element[j] + "\t");
            }
            out.append('\n');
        }
        return out.toString();
    }

    @Override
    public void release() {
        this.matrix = null;
    }
}

