/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt.options;

import java.io.File;
import org.docstr.gwt.AbstractBaseOptions;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public abstract class GwtTestOptions
extends AbstractBaseOptions {
    public String getParameterString() {
        StringBuilder builder = new StringBuilder();
        this.dirArgIfSet(builder, "-war", this.getWar());
        this.dirArgIfSet(builder, "-deploy", this.getDeploy());
        this.dirArgIfSet(builder, "-extra", this.getExtra());
        this.dirArgIfSet(builder, "-workDir", this.getWorkDir());
        this.dirArgIfSet(builder, "-gen", this.getGen());
        this.argIfSet(builder, "-logLevel", this.getLogLevel());
        this.argIfSet(builder, "-sourceLevel", this.getSourceLevel());
        this.argIfSet(builder, "-port", this.getPort());
        this.argIfSet(builder, "-whitelist", this.getWhitelist());
        this.argIfSet(builder, "-blacklist", this.getBlacklist());
        this.dirArgIfSet(builder, "-logdir", this.getLogdir());
        this.argIfSet(builder, "-codeServerPort", this.getCodeServerPort());
        this.argIfSet(builder, "-style", this.getStyle());
        this.argIfEnabled(builder, this.getEa(), "-ea");
        this.argIfEnabled(builder, this.getDisableClassMetadata(), "-XdisableClassMetadata");
        this.argIfEnabled(builder, this.getDisableCastChecking(), "-XdisableCastChecking");
        this.argIfEnabled(builder, this.getDraftCompile(), "-draftCompile");
        this.argIfSet(builder, "-localWorkers", this.getLocalWorkers());
        this.argIfEnabled(builder, this.getProd(), "-prod");
        this.argIfSet(builder, "-testMethodTimeout", this.getTestMethodTimeout());
        this.argIfSet(builder, "-testBeginTimeout", this.getTestBeginTimeout());
        this.argIfSet(builder, "-runStyle", this.getRunStyle());
        this.argIfEnabled(builder, this.getNotHeadless(), "-notHeadless");
        this.argIfEnabled(builder, this.getStandardsMode(), "-standardsMode");
        this.argIfEnabled(builder, this.getQuirksMode(), "-quirksMode");
        this.argIfSet(builder, "-Xtries", this.getTries());
        this.argIfSet(builder, "-userAgents", this.getUserAgents());
        return builder.toString();
    }

    private void argIfEnabled(StringBuilder builder, Property<Boolean> condition, String arg) {
        if (condition.isPresent() && Boolean.TRUE.equals(condition.get())) {
            this.arg(builder, arg);
        }
    }

    private void dirArgIfSet(StringBuilder builder, String arg, DirectoryProperty dir) {
        if (dir != null && dir.isPresent()) {
            File dirAsFile = (File)dir.getAsFile().get();
            dirAsFile.mkdirs();
            this.arg(builder, arg, dirAsFile);
        }
    }

    private <T> void argIfSet(StringBuilder builder, String arg, Property<T> value) {
        if (value != null && value.isPresent()) {
            this.arg(builder, arg, value.get());
        }
    }

    private void arg(StringBuilder builder, Object ... args) {
        for (Object arg : args) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(arg.toString());
        }
    }

    public abstract Property<Integer> getPort();

    public abstract DirectoryProperty getLogdir();

    public abstract Property<String> getWhitelist();

    public abstract Property<String> getBlacklist();

    public abstract Property<Integer> getCodeServerPort();

    public abstract Property<Boolean> getEa();

    public abstract Property<Boolean> getDisableClassMetadata();

    public abstract Property<Boolean> getDisableCastChecking();

    public abstract Property<Boolean> getDraftCompile();

    public abstract Property<Integer> getLocalWorkers();

    public abstract Property<Boolean> getProd();

    public abstract Property<Integer> getTestMethodTimeout();

    public abstract Property<Integer> getTestBeginTimeout();

    public abstract Property<String> getRunStyle();

    public abstract Property<Boolean> getNotHeadless();

    public abstract Property<Boolean> getStandardsMode();

    public abstract Property<Boolean> getQuirksMode();

    public abstract Property<Integer> getTries();

    public abstract Property<String> getUserAgents();

    public abstract ListProperty<String> getTestTasks();

    public abstract Property<Boolean> getShowStandardStreams();
}

