/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMClassMethod;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JdoClassChecker
implements ClassVisitor {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ASMClassEnhancer enhancer;
    protected HashSet<ClassField> fieldsRequired = new HashSet();
    protected HashSet<ClassMethod> methodsRequired = new HashSet();
    protected boolean enhanced = false;
    protected boolean logErrors = true;

    public JdoClassChecker(ASMClassEnhancer enhancer, boolean logErrors) {
        this.enhancer = enhancer;
        this.logErrors = logErrors;
        if (enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.fieldsRequired.addAll(enhancer.getFieldsList());
            this.methodsRequired.addAll(enhancer.getMethodsList());
        }
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    protected void reportError(String msg) {
        if (this.logErrors) {
            DataNucleusEnhancer.LOGGER.error((Object)msg);
        } else if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            DataNucleusEnhancer.LOGGER.debug((Object)msg);
        }
        this.enhanced = false;
    }

    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.enhanced = true;
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            if (interfaces == null) {
                this.enhanced = false;
                return;
            }
            if (!this.hasInterface(interfaces, this.enhancer.getPersistableAsmClassName())) {
                this.reportError(LOCALISER.msg("Enhancer.Check.InterfaceMissing", (Object)this.enhancer.className, (Object)"javax.jdo.spi.PersistenceCapable"));
            }
            if (this.enhancer.getClassMetaData().isDetachable() && !this.hasInterface(interfaces, this.enhancer.getDetachableAsmClassName())) {
                this.reportError(LOCALISER.msg("Enhancer.Check.InterfaceMissing", (Object)this.enhancer.className, (Object)"javax.jdo.spi.Detachable"));
            }
        }
    }

    protected boolean hasInterface(String[] interfaces, String intf) {
        if (interfaces == null || interfaces.length <= 0) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(intf)) continue;
            return true;
        }
        return false;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            for (ClassField field : this.fieldsRequired) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldMissing", (Object)this.enhancer.className, (Object)field.getName()));
            }
            for (ClassMethod method : this.methodsRequired) {
                this.reportError(LOCALISER.msg("Enhancer.Check.MethodMissing", (Object)this.enhancer.className, (Object)method.getName()));
            }
        } else if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
            this.enhanced = false;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Iterator<ClassField> iter = this.fieldsRequired.iterator();
        while (iter.hasNext()) {
            ClassField field = iter.next();
            if (!field.getName().equals(name)) continue;
            if (field.getAccess() != access) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldIncorrectAccess", (Object)this.enhancer.className, (Object)name));
                continue;
            }
            if (!desc.equals(Type.getDescriptor((Class)((Class)field.getType())))) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldIncorrectType", (Object)this.enhancer.className, (Object)name));
                continue;
            }
            iter.remove();
            break;
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Iterator<ClassMethod> iter = this.methodsRequired.iterator();
        while (iter.hasNext()) {
            ASMClassMethod method = (ASMClassMethod)iter.next();
            if (!method.getName().equals(name) || !method.getDescriptor().equals(desc)) continue;
            if (method.getAccess() != access) {
                this.reportError(LOCALISER.msg("Enhancer.Check.MethodIncorrectAccess", (Object)this.enhancer.className, (Object)name));
                continue;
            }
            iter.remove();
            break;
        }
        return null;
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }
}

