/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.enhancer.AbstractClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.JdoClassAdapter;
import org.datanucleus.enhancer.asm.JdoClassChecker;
import org.datanucleus.enhancer.asm.method.InitFieldFlags;
import org.datanucleus.enhancer.asm.method.InitFieldNames;
import org.datanucleus.enhancer.asm.method.InitFieldTypes;
import org.datanucleus.enhancer.asm.method.InitPersistenceCapableSuperclass;
import org.datanucleus.enhancer.asm.method.JdoCopyField;
import org.datanucleus.enhancer.asm.method.JdoCopyFields;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId2;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId2;
import org.datanucleus.enhancer.asm.method.JdoGetInheritedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetManagedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetPersistenceManager;
import org.datanucleus.enhancer.asm.method.JdoGetTransactionalObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetVersion;
import org.datanucleus.enhancer.asm.method.JdoIsDeleted;
import org.datanucleus.enhancer.asm.method.JdoIsDetached;
import org.datanucleus.enhancer.asm.method.JdoIsDirty;
import org.datanucleus.enhancer.asm.method.JdoIsNew;
import org.datanucleus.enhancer.asm.method.JdoIsPersistent;
import org.datanucleus.enhancer.asm.method.JdoIsTransactional;
import org.datanucleus.enhancer.asm.method.JdoMakeDirty;
import org.datanucleus.enhancer.asm.method.JdoNewInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewInstance2;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance2;
import org.datanucleus.enhancer.asm.method.JdoPreSerialize;
import org.datanucleus.enhancer.asm.method.JdoProvideField;
import org.datanucleus.enhancer.asm.method.JdoProvideFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceDetachedState;
import org.datanucleus.enhancer.asm.method.JdoReplaceField;
import org.datanucleus.enhancer.asm.method.JdoReplaceFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceFlags;
import org.datanucleus.enhancer.asm.method.JdoReplaceStateManager;
import org.datanucleus.enhancer.asm.method.JdoSuperClone;
import org.datanucleus.enhancer.asm.method.LoadClass;
import org.datanucleus.enhancer.asm.primarykey.PrimaryKeyGenerator;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMClassEnhancer
extends AbstractClassEnhancer {
    protected static Localiser LOCALISER_CORE = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final String FN_StateManager = "jdoStateManager";
    public static final String FN_Flag = "jdoFlags";
    public static final String FN_FieldNames = "jdoFieldNames";
    public static final String FN_FieldTypes = "jdoFieldTypes";
    public static final String FN_FieldFlags = "jdoFieldFlags";
    public static final String FN_PersistableSuperclass = "jdoPersistenceCapableSuperclass";
    public static final String FN_InheritedFieldCount = "jdoInheritedFieldCount";
    public static final String FN_DetachedState = "jdoDetachedState";
    public static final String FN_SerialVersionUID = "serialVersionUID";
    public static final String MN_GetterPrefix = "jdoGet";
    public static final String MN_SetterPrefix = "jdoSet";
    public static final String MN_FieldNamesInitMethod = "__jdoFieldNamesInit";
    public static final String MN_FieldTypesInitMethod = "__jdoFieldTypesInit";
    public static final String MN_FieldFlagsInitMethod = "__jdoFieldFlagsInit";
    public static final String MN_GetObjectId = "jdoGetObjectId";
    public static final String MN_GetTransactionalObjectId = "jdoGetTransactionalObjectId";
    public static final String MN_GetVersion = "jdoGetVersion";
    public static final String MN_IsDetached = "jdoIsDetached";
    public static final String MN_IsDetachedInternal = "jdoIsDetachedInternal";
    public static final String MN_IsDeleted = "jdoIsDeleted";
    public static final String MN_IsDirty = "jdoIsDirty";
    public static final String MN_IsNew = "jdoIsNew";
    public static final String MN_IsPersistent = "jdoIsPersistent";
    public static final String MN_IsTransactional = "jdoIsTransactional";
    public static final String MN_GetPersistenceManager = "jdoGetPersistenceManager";
    public static final String MN_PreSerialize = "jdoPreSerialize";
    public static final String MN_GetInheritedFieldCount = "__jdoGetInheritedFieldCount";
    public static final String MN_SuperClone = "jdoSuperClone";
    public static final String MN_GetManagedFieldCount = "jdoGetManagedFieldCount";
    public static final String MN_PersistableSuperclassInit = "__jdoPersistenceCapableSuperclassInit";
    public static final String MN_LoadClass = "___jdo$loadClass";
    public static final String MN_CopyField = "jdoCopyField";
    public static final String MN_CopyFields = "jdoCopyFields";
    public static final String MN_CopyKeyFieldsFromObjectId = "jdoCopyKeyFieldsFromObjectId";
    public static final String MN_CopyKeyFieldsToObjectId = "jdoCopyKeyFieldsToObjectId";
    public static final String MN_ProvideField = "jdoProvideField";
    public static final String MN_ProvideFields = "jdoProvideFields";
    public static final String MN_ReplaceField = "jdoReplaceField";
    public static final String MN_ReplaceFields = "jdoReplaceFields";
    public static final String MN_ReplaceFlags = "jdoReplaceFlags";
    public static final String MN_ReplaceStateManager = "jdoReplaceStateManager";
    public static final String MN_ReplaceDetachedState = "jdoReplaceDetachedState";
    public static final String MN_MakeDirty = "jdoMakeDirty";
    public static final String MN_MakeDirtyDetached = "jdoMakeDirtyDetached";
    public static final String MN_NewInstance = "jdoNewInstance";
    public static final String MN_NewObjectIdInstance = "jdoNewObjectIdInstance";
    public static final Class CL_Detachable = Detachable.class;
    public static final Class CL_Persistable = PersistenceCapable.class;
    public static final Class CL_ObjectIdFieldConsumer = PersistenceCapable.ObjectIdFieldConsumer.class;
    public static final Class CL_ObjectIdFieldSupplier = PersistenceCapable.ObjectIdFieldSupplier.class;
    public static final Class CL_PersistenceManager = PersistenceManager.class;
    public static final Class CL_StateManager = StateManager.class;
    public static final String CN_JDOHelper = JDOHelper.class.getName();
    public static final String CN_JDOImplHelper = JDOImplHelper.class.getName();
    public static final String CN_JDOFatalInternalException = JDOFatalInternalException.class.getName();
    public static final String CN_DetachedFieldAccessException = JDODetachedFieldAccessException.class.getName();
    public static final String ACN_StateManager = CL_StateManager.getName().replace('.', '/');
    public static final String ACN_PersistenceManager = CL_PersistenceManager.getName().replace('.', '/');
    public static final String ACN_Persistable = CL_Persistable.getName().replace('.', '/');
    public static final String ACN_Detachable = CL_Detachable.getName().replace('.', '/');
    public static final String ACN_ObjectIdFieldConsumer = CL_ObjectIdFieldConsumer.getName().replace('.', '/');
    public static final String ACN_ObjectIdFieldSupplier = CL_ObjectIdFieldSupplier.getName().replace('.', '/');
    public static final String ACN_DetachedFieldAccessException = JDODetachedFieldAccessException.class.getName().replace('.', '/');
    public static final String ACN_FatalInternalException = JDOFatalInternalException.class.getName().replace('.', '/');
    public static final String ACN_Helper = JDOHelper.class.getName().replace('.', '/');
    public static final String ACN_ImplHelper = JDOImplHelper.class.getName().replace('.', '/');
    public static final String CD_ByteIdentity = Type.getDescriptor(ByteIdentity.class);
    public static final String CD_CharIdentity = Type.getDescriptor(CharIdentity.class);
    public static final String CD_IntIdentity = Type.getDescriptor(IntIdentity.class);
    public static final String CD_LongIdentity = Type.getDescriptor(LongIdentity.class);
    public static final String CD_ShortIdentity = Type.getDescriptor(ShortIdentity.class);
    public static final String CD_StringIdentity = Type.getDescriptor(StringIdentity.class);
    public static final String CD_ObjectIdentity = Type.getDescriptor(ObjectIdentity.class);
    public static final String CD_StateManager = Type.getDescriptor(StateManager.class);
    public static final String CD_PersistenceManager = Type.getDescriptor(PersistenceManager.class);
    public static final String CD_PersistenceCapable = Type.getDescriptor(PersistenceCapable.class);
    public static final String CD_Detachable = Type.getDescriptor((Class)CL_Detachable);
    public static final String CD_ObjectIdFieldConsumer = Type.getDescriptor(PersistenceCapable.ObjectIdFieldConsumer.class);
    public static final String CD_ObjectIdFieldSupplier = Type.getDescriptor(PersistenceCapable.ObjectIdFieldSupplier.class);
    public static final String CD_String = Type.getDescriptor(String.class);
    public static final String CD_Object = Type.getDescriptor(Object.class);
    protected String inputResourceName;
    protected byte[] inputBytes;
    protected final Class cls;
    protected byte[] classBytes = null;
    protected byte[] pkClassBytes = null;
    protected String asmClassName = null;
    protected String classDescriptor = null;

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr) {
        super(cmd, clr, mmgr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputResourceName = "/" + this.className.replace('.', '/') + ".class";
    }

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr, byte[] classBytes) {
        super(cmd, clr, mmgr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputBytes = classBytes;
    }

    public static String getClassNameForFileName(String filename) {
        MyClassVisitor vis = new MyClassVisitor();
        try {
            new ClassReader((InputStream)new FileInputStream(filename)).accept((ClassVisitor)vis, 0);
            return vis.getClassName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Class getClassEnhanced() {
        return this.cls;
    }

    public String getASMClassName() {
        return this.asmClassName;
    }

    public String getClassDescriptor() {
        return this.classDescriptor;
    }

    protected void initialiseMethodsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoGetObjectId.getInstance(this));
            this.methodsToAdd.add(JdoGetVersion.getInstance(this));
            this.methodsToAdd.add(JdoPreSerialize.getInstance(this));
            this.methodsToAdd.add(JdoGetPersistenceManager.getInstance(this));
            this.methodsToAdd.add(JdoGetTransactionalObjectId.getInstance(this));
            this.methodsToAdd.add(JdoIsDeleted.getInstance(this));
            this.methodsToAdd.add(JdoIsDirty.getInstance(this));
            this.methodsToAdd.add(JdoIsNew.getInstance(this));
            this.methodsToAdd.add(JdoIsPersistent.getInstance(this));
            this.methodsToAdd.add(JdoIsTransactional.getInstance(this));
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance2.getInstance(this));
            this.methodsToAdd.add(JdoProvideFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFlags.getInstance(this));
            this.methodsToAdd.add(JdoReplaceStateManager.getInstance(this));
        }
        if (this.cmd.getPersistenceCapableSuperclass() != null && this.cmd.isRootInstantiableClass()) {
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance2.getInstance(this));
        }
        if (this.requiresDetachable()) {
            this.methodsToAdd.add(JdoReplaceDetachedState.getInstance(this));
        }
        if (this.cmd.isDetachable() && this.cmd.getPersistenceCapableSuperclass() != null) {
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
        }
        this.methodsToAdd.add(JdoIsDetached.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance1.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance2.getInstance(this));
        this.methodsToAdd.add(JdoReplaceField.getInstance(this));
        this.methodsToAdd.add(JdoProvideField.getInstance(this));
        this.methodsToAdd.add(JdoCopyField.getInstance(this));
        this.methodsToAdd.add(JdoCopyFields.getInstance(this));
        this.methodsToAdd.add(InitFieldNames.getInstance(this));
        this.methodsToAdd.add(InitFieldTypes.getInstance(this));
        this.methodsToAdd.add(InitFieldFlags.getInstance(this));
        this.methodsToAdd.add(JdoGetInheritedFieldCount.getInstance(this));
        this.methodsToAdd.add(JdoGetManagedFieldCount.getInstance(this));
        this.methodsToAdd.add(InitPersistenceCapableSuperclass.getInstance(this));
        this.methodsToAdd.add(LoadClass.getInstance(this));
        this.methodsToAdd.add(JdoSuperClone.getInstance(this));
    }

    protected void initialiseFieldsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.fieldsToAdd.add(new ClassField(this, this.getStateManagerFieldName(), 132, CL_StateManager));
            this.fieldsToAdd.add(new ClassField(this, this.getFlagsFieldName(), 132, Byte.TYPE));
        }
        if (this.requiresDetachable()) {
            this.fieldsToAdd.add(new ClassField(this, this.getDetachedStateFieldName(), 4, Object[].class));
        }
        this.fieldsToAdd.add(new ClassField(this, this.getFieldFlagsFieldName(), 26, byte[].class));
        this.fieldsToAdd.add(new ClassField(this, this.getPersistableSuperclassFieldName(), 26, Class.class));
        this.fieldsToAdd.add(new ClassField(this, this.getFieldTypesFieldName(), 26, Class[].class));
        this.fieldsToAdd.add(new ClassField(this, this.getFieldNamesFieldName(), 26, String[].class));
        this.fieldsToAdd.add(new ClassField(this, this.getInheritedFieldCountFieldName(), 26, Integer.TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enhance() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        if (this.checkClassIsEnhanced(false)) {
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.ClassIsAlreadyEnhanced", (Object)this.className));
            return true;
        }
        try {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION && this.cmd.getObjectidClass() == null && this.cmd.getNoOfPrimaryKeyMembers() > 1) {
                if (this.hasOption("generate-primary-key")) {
                    String pkClassName = this.cmd.getFullClassName() + "_PK";
                    if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                        DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.GeneratePrimaryKey", (Object)this.cmd.getFullClassName(), (Object)pkClassName));
                    }
                    this.cmd.setObjectIdClass(pkClassName);
                    PrimaryKeyGenerator pkGen = new PrimaryKeyGenerator((AbstractClassMetaData)this.cmd, this);
                    this.pkClassBytes = pkGen.generate();
                } else {
                    throw new InvalidMetaDataException(LOCALISER_CORE, "044065", (Object)this.cmd.getFullClassName(), (Object)this.cmd.getNoOfPrimaryKeyMembers());
                }
            }
            ClassWriter cw = new ClassWriter(1);
            JdoClassAdapter cv = new JdoClassAdapter((ClassVisitor)cw, this);
            ClassReader cr = null;
            InputStream classReaderInputStream = null;
            try {
                if (this.inputBytes != null) {
                    cr = new ClassReader(this.inputBytes);
                } else {
                    classReaderInputStream = this.clr.getResource(this.inputResourceName, null).openStream();
                    cr = new ClassReader(classReaderInputStream);
                }
                cr.accept((ClassVisitor)cv, 0);
                this.classBytes = cw.toByteArray();
            }
            finally {
                if (classReaderInputStream != null) {
                    classReaderInputStream.close();
                }
            }
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
        this.update = true;
        return true;
    }

    public byte[] getClassBytes() {
        return this.classBytes;
    }

    public byte[] getPrimaryKeyClassBytes() {
        return this.pkClassBytes;
    }

    public boolean validate() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        return this.checkClassIsEnhanced(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkClassIsEnhanced(boolean logErrors) {
        try {
            JdoClassChecker checker = new JdoClassChecker(this, logErrors);
            InputStream classReaderInputStream = null;
            try {
                ClassReader cr = null;
                if (this.inputBytes != null) {
                    cr = new ClassReader(this.inputBytes);
                } else {
                    classReaderInputStream = this.clr.getResource(this.inputResourceName, null).openStream();
                    cr = new ClassReader(classReaderInputStream);
                }
                cr.accept((ClassVisitor)checker, 0);
            }
            finally {
                if (classReaderInputStream != null) {
                    classReaderInputStream.close();
                }
            }
            return checker.isEnhanced();
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
    }

    public String getStateManagerFieldName() {
        return FN_StateManager;
    }

    public String getFlagsFieldName() {
        return FN_Flag;
    }

    public String getFieldNamesFieldName() {
        return FN_FieldNames;
    }

    public String getFieldTypesFieldName() {
        return FN_FieldTypes;
    }

    public String getFieldFlagsFieldName() {
        return FN_FieldFlags;
    }

    public String getPersistableSuperclassFieldName() {
        return FN_PersistableSuperclass;
    }

    public String getInheritedFieldCountFieldName() {
        return FN_InheritedFieldCount;
    }

    public String getDetachedStateFieldName() {
        return FN_DetachedState;
    }

    public String getSerialVersionUidFieldName() {
        return FN_SerialVersionUID;
    }

    public String getFieldNamesInitMethodName() {
        return MN_FieldNamesInitMethod;
    }

    public String getFieldTypesInitMethodName() {
        return MN_FieldTypesInitMethod;
    }

    public String getFieldFlagsInitMethodName() {
        return MN_FieldFlagsInitMethod;
    }

    public String getGetObjectIdMethodName() {
        return MN_GetObjectId;
    }

    public String getGetTransactionalObjectIdMethodName() {
        return MN_GetTransactionalObjectId;
    }

    public String getGetVersionMethodName() {
        return MN_GetVersion;
    }

    public String getIsDetachedMethodName() {
        return MN_IsDetached;
    }

    public String getIsDetachedInternalMethodName() {
        return MN_IsDetachedInternal;
    }

    public String getIsDeletedMethodName() {
        return MN_IsDeleted;
    }

    public String getIsDirtyMethodName() {
        return MN_IsDirty;
    }

    public String getIsNewMethodName() {
        return MN_IsNew;
    }

    public String getIsPersistentMethodName() {
        return MN_IsPersistent;
    }

    public String getIsTransactionalMethodName() {
        return MN_IsTransactional;
    }

    public String getGetPersistenceManagerMethodName() {
        return MN_GetPersistenceManager;
    }

    public String getPreSerializeMethodName() {
        return MN_PreSerialize;
    }

    public String getGetInheritedFieldCountMethodName() {
        return MN_GetInheritedFieldCount;
    }

    public String getSuperCloneMethodName() {
        return MN_SuperClone;
    }

    public String getGetManagedFieldCountMethodName() {
        return MN_GetManagedFieldCount;
    }

    public String getPersistableSuperclassInitMethodName() {
        return MN_PersistableSuperclassInit;
    }

    public String getLoadClassMethodName() {
        return MN_LoadClass;
    }

    public String getCopyFieldMethodName() {
        return MN_CopyField;
    }

    public String getCopyFieldsMethodName() {
        return MN_CopyFields;
    }

    public String getCopyKeyFieldsFromObjectIdMethodName() {
        return MN_CopyKeyFieldsFromObjectId;
    }

    public String getCopyKeyFieldsToObjectIdMethodName() {
        return MN_CopyKeyFieldsToObjectId;
    }

    public String getProvideFieldMethodName() {
        return MN_ProvideField;
    }

    public String getProvideFieldsMethodName() {
        return MN_ProvideFields;
    }

    public String getReplaceFieldMethodName() {
        return MN_ReplaceField;
    }

    public String getReplaceFieldsMethodName() {
        return MN_ReplaceFields;
    }

    public String getReplaceFlagsMethodName() {
        return MN_ReplaceFlags;
    }

    public String getReplaceStateManagerMethodName() {
        return MN_ReplaceStateManager;
    }

    public String getReplaceDetachedStateMethodName() {
        return MN_ReplaceDetachedState;
    }

    public String getMakeDirtyMethodName() {
        return MN_MakeDirty;
    }

    public String getMakeDirtyDetachedMethodName() {
        return MN_MakeDirtyDetached;
    }

    public String getNewInstanceMethodName() {
        return MN_NewInstance;
    }

    public String getNewObjectIdInstanceMethodName() {
        return MN_NewObjectIdInstance;
    }

    public String getGetMethodPrefixMethodName() {
        return MN_GetterPrefix;
    }

    public String getSetMethodPrefixMethodName() {
        return MN_SetterPrefix;
    }

    public String getHelperClassName() {
        return CN_JDOHelper;
    }

    public String getImplHelperClassName() {
        return CN_JDOImplHelper;
    }

    public String getFatalInternalExceptionClassName() {
        return CN_JDOFatalInternalException;
    }

    public String getDetachedFieldAccessExceptionClassName() {
        return CN_DetachedFieldAccessException;
    }

    public String getStateManagerAsmClassName() {
        return ACN_StateManager;
    }

    public String getPersistenceManagerAsmClassName() {
        return ACN_PersistenceManager;
    }

    public String getPersistableAsmClassName() {
        return ACN_Persistable;
    }

    public String getDetachableAsmClassName() {
        return ACN_Detachable;
    }

    public String getObjectIdFieldConsumerAsmClassName() {
        return ACN_ObjectIdFieldConsumer;
    }

    public String getObjectIdFieldSupplierAsmClassName() {
        return ACN_ObjectIdFieldSupplier;
    }

    public String getDetachedFieldAccessExceptionAsmClassName() {
        return ACN_DetachedFieldAccessException;
    }

    public String getFatalInternalExceptionAsmClassName() {
        return ACN_FatalInternalException;
    }

    public String getHelperAsmClassName() {
        return ACN_Helper;
    }

    public String getImplHelperAsmClassName() {
        return ACN_ImplHelper;
    }

    public String getByteIdentityDescriptor() {
        return CD_ByteIdentity;
    }

    public String getCharIdentityDescriptor() {
        return CD_CharIdentity;
    }

    public String getIntIdentityDescriptor() {
        return CD_IntIdentity;
    }

    public String getLongIdentityDescriptor() {
        return CD_LongIdentity;
    }

    public String getShortIdentityDescriptor() {
        return CD_ShortIdentity;
    }

    public String getStringIdentityDescriptor() {
        return CD_StringIdentity;
    }

    public String getObjectIdentityDescriptor() {
        return CD_ObjectIdentity;
    }

    public String getStateManagerDescriptor() {
        return CD_StateManager;
    }

    public String getPersistenceManagerDescriptor() {
        return CD_PersistenceManager;
    }

    public String getPersistableDescriptor() {
        return CD_PersistenceCapable;
    }

    public String getDetachableDescriptor() {
        return CD_Detachable;
    }

    public String getSingleFieldIdentityDescriptor(String oidClassName) {
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return CD_LongIdentity;
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return CD_IntIdentity;
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return CD_StringIdentity;
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return CD_ShortIdentity;
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return CD_CharIdentity;
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return CD_ByteIdentity;
        }
        if (oidClassName.equals(ObjectIdentity.class.getName())) {
            return CD_ObjectIdentity;
        }
        return null;
    }

    public String getTypeDescriptorForSingleFieldIdentityGetKey(String oidClassName) {
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return CD_String;
        }
        if (oidClassName.equals(ObjectIdentity.class.getName())) {
            return CD_Object;
        }
        return null;
    }

    public String getTypeNameForUseWithSingleFieldIdentity(String oidClassName) {
        if (oidClassName == null) {
            return null;
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return "Byte";
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return "Char";
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return "Int";
        }
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return "Long";
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return "Short";
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return "String";
        }
        return "Object";
    }

    public String getObjectIdFieldConsumerDescriptor() {
        return CD_ObjectIdFieldConsumer;
    }

    public String getObjectIdFieldSupplierDescriptor() {
        return CD_ObjectIdFieldSupplier;
    }

    public Class getPersistenceManagerClass() {
        return CL_PersistenceManager;
    }

    public Class getStateManagerClass() {
        return CL_StateManager;
    }

    public Class getPersistableClass() {
        return CL_Persistable;
    }

    public Class getDetachableClass() {
        return CL_Detachable;
    }

    public Class getObjectIdFieldSupplierClass() {
        return CL_ObjectIdFieldSupplier;
    }

    public Class getObjectIdFieldConsumerClass() {
        return CL_ObjectIdFieldConsumer;
    }

    public Class getObjectIdentityClass() {
        return ObjectIdentity.class;
    }

    public static class MyClassVisitor
    implements ClassVisitor {
        String className = null;

        public String getClassName() {
            return this.className;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visit(int version, int access, String name, String sig, String supername, String[] intfs) {
            this.className = name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] excpts) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitEnd() {
        }
    }
}

