/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.NucleusEnhanceException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNucleusEnhancer {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.Enhancer");
    private NucleusContext nucleusContext;
    private ClassLoaderResolver clr;
    private String apiName = "JDO";
    private String enhancerName = "ASM";
    private String outputDirectory = null;
    private boolean verbose = false;
    private boolean systemOut = false;
    private boolean generatePK = true;
    private boolean generateConstructor = true;
    protected ClassLoader userClassLoader = null;
    private Class classEnhancerClass = null;
    private Collection<EnhanceComponent> componentsToEnhance = new ArrayList<EnhanceComponent>();
    private Map<String, byte[]> bytesForClassesToEnhanceByClassName = null;
    private Map<String, byte[]> enhancedBytesByClassName = null;

    public DataNucleusEnhancer() {
        this("JDO", "ASM");
    }

    public DataNucleusEnhancer(String api, String enhancerName) {
        this(api, enhancerName, null);
    }

    public DataNucleusEnhancer(String apiName, String enhancerName, Properties props) {
        LOGGER.info((Object)LOCALISER.msg("Enhancer.ClassEnhancer", (Object)enhancerName, (Object)apiName));
        this.apiName = apiName;
        this.enhancerName = enhancerName;
        this.nucleusContext = new NucleusContext(apiName, NucleusContext.ContextType.ENHANCEMENT, (Map)props);
        if (props != null) {
            this.nucleusContext.getPersistenceConfiguration().setPersistenceProperties((Map)props);
        }
        this.clr = this.nucleusContext.getClassLoaderResolver(null);
    }

    private void init() {
        if (this.classEnhancerClass != null) {
            return;
        }
        ConfigurationElement elem = null;
        try {
            elem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.enhancer.enhancer", new String[]{"name", "api"}, new String[]{this.enhancerName, this.apiName});
        }
        catch (Exception e) {
            throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.ClassEnhancerNotFound", (Object)this.enhancerName), e);
        }
        if (elem == null) {
            throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.ClassEnhancerTestClassNotFound", (Object)this.enhancerName));
        }
        String enhancerTestClass = elem.getAttribute("test-class");
        if (enhancerTestClass != null) {
            try {
                this.clr.classForName(enhancerTestClass);
            }
            catch (Exception e) {
                throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.ClassEnhancerTestClassNotFound", (Object)this.enhancerName));
            }
        }
        String classEnhancerClassName = elem.getAttribute("class-name");
        this.classEnhancerClass = this.clr.classForName(classEnhancerClassName, DataNucleusEnhancer.class.getClassLoader());
    }

    public MetaDataManager getMetaDataManager() {
        return this.nucleusContext.getMetaDataManager();
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public DataNucleusEnhancer setOutputDirectory(String dir) {
        this.resetEnhancement();
        this.outputDirectory = dir;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.userClassLoader;
    }

    public DataNucleusEnhancer setClassLoader(ClassLoader loader) {
        this.resetEnhancement();
        this.userClassLoader = loader;
        if (this.userClassLoader != null) {
            this.clr.registerUserClassLoader(this.userClassLoader);
        }
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public DataNucleusEnhancer setVerbose(boolean verbose) {
        this.resetEnhancement();
        this.verbose = verbose;
        return this;
    }

    public DataNucleusEnhancer setSystemOut(boolean sysout) {
        this.resetEnhancement();
        this.systemOut = sysout;
        return this;
    }

    public DataNucleusEnhancer setGeneratePK(boolean flag) {
        this.resetEnhancement();
        this.generatePK = flag;
        return this;
    }

    public DataNucleusEnhancer setGenerateConstructor(boolean flag) {
        this.resetEnhancement();
        this.generateConstructor = flag;
        return this;
    }

    public DataNucleusEnhancer addClass(String className, byte[] bytes) {
        this.init();
        if (className == null) {
            return this;
        }
        if (this.bytesForClassesToEnhanceByClassName == null) {
            this.bytesForClassesToEnhanceByClassName = new HashMap<String, byte[]>();
        }
        this.bytesForClassesToEnhanceByClassName.put(className, bytes);
        this.componentsToEnhance.add(new EnhanceComponent(0, className));
        return this;
    }

    public DataNucleusEnhancer addClasses(String ... classNames) {
        this.init();
        if (classNames == null) {
            return this;
        }
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < classNames.length; ++i) {
            if (classNames[i].endsWith(".class")) {
                String name = classNames[i];
                String msg = null;
                if (!StringUtils.getFileForFilename((String)classNames[i]).exists()) {
                    msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classNames[i]);
                    this.addMessage(msg, true);
                    name = null;
                } else {
                    try {
                        Method method = ClassUtils.getMethodForClass((Class)this.classEnhancerClass, (String)"getClassNameForFileName", (Class[])new Class[]{String.class});
                        name = (String)method.invoke(null, (Object[])new String[]{classNames[i]});
                    }
                    catch (InvocationTargetException ex) {
                        msg = LOCALISER.msg("Enhancer.ClassEnhancer.MethodNotFound", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)"getClassNameForFileName", (Object)ex.getTargetException());
                        this.addMessage(msg, true);
                        name = null;
                    }
                    catch (Exception e) {
                        msg = LOCALISER.msg("Enhancer.ClassEnhancer.MethodNotFound", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)"getClassNameForFileName", (Object)e);
                        this.addMessage(msg, true);
                        name = null;
                    }
                }
                if (name == null) continue;
                names.add(name);
                continue;
            }
            try {
                this.clr.classForName(classNames[i], false);
            }
            catch (ClassNotResolvedException cnre) {
                this.addMessage("Class " + classNames[i] + " not found in CLASSPATH!", true);
            }
            names.add(classNames[i]);
        }
        if (names.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(0, names.toArray(new String[names.size()])));
        }
        return this;
    }

    public DataNucleusEnhancer addFiles(String ... filenames) {
        this.init();
        if (filenames == null) {
            return this;
        }
        ArrayList<String> classFiles = new ArrayList<String>();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        HashSet<String> jarFiles = new HashSet<String>();
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i].endsWith(".class")) {
                classFiles.add(filenames[i]);
                continue;
            }
            if (filenames[i].endsWith(".jar")) {
                jarFiles.add(filenames[i]);
                continue;
            }
            mappingFiles.add(filenames[i]);
        }
        if (mappingFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(2, mappingFiles.toArray(new String[mappingFiles.size()])));
        }
        if (jarFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(3, jarFiles.toArray(new String[jarFiles.size()])));
        }
        if (classFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(1, classFiles.toArray(new String[classFiles.size()])));
        }
        return this;
    }

    public DataNucleusEnhancer addJar(String jarFileName) {
        this.init();
        if (jarFileName == null) {
            return this;
        }
        this.componentsToEnhance.add(new EnhanceComponent(3, jarFileName));
        return this;
    }

    public DataNucleusEnhancer addPersistenceUnit(String persistenceUnitName) {
        this.init();
        if (persistenceUnitName == null) {
            return this;
        }
        this.componentsToEnhance.add(new EnhanceComponent(4, persistenceUnitName));
        return this;
    }

    public int enhance() {
        this.init();
        if (this.componentsToEnhance.isEmpty()) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        Collection<FileMetaData> fileMetaData = this.getFileMetadataForInput();
        long inputTime = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        Iterator<FileMetaData> filemdIter = fileMetaData.iterator();
        boolean success = true;
        while (filemdIter.hasNext()) {
            FileMetaData filemd = filemdIter.next();
            for (int packagenum = 0; packagenum < filemd.getNoOfPackages(); ++packagenum) {
                PackageMetaData pmd = filemd.getPackage(packagenum);
                for (int classnum = 0; classnum < pmd.getNoOfClasses(); ++classnum) {
                    ClassMetaData cmd = pmd.getClass(classnum);
                    if (classNames.contains(cmd.getFullClassName())) continue;
                    classNames.add(cmd.getFullClassName());
                    byte[] bytes = this.bytesForClassesToEnhanceByClassName != null ? this.bytesForClassesToEnhanceByClassName.get(cmd.getFullClassName()) : null;
                    ClassEnhancer classEnhancer = this.getClassEnhancer(cmd, bytes);
                    boolean clsSuccess = this.enhanceClass(cmd, classEnhancer, bytes == null);
                    if (clsSuccess) continue;
                    success = false;
                }
            }
        }
        if (!success) {
            throw new NucleusException("Failure during enhancement of classes - see the log for details");
        }
        long enhanceTime = System.currentTimeMillis();
        String msg = LOCALISER.msg("Enhancer.Success", (Object)classNames.size(), (Object)("" + (inputTime - startTime)), (Object)("" + (enhanceTime - inputTime)), (Object)("" + (enhanceTime - startTime)));
        this.addMessage(msg, false);
        if (this.bytesForClassesToEnhanceByClassName != null) {
            this.bytesForClassesToEnhanceByClassName.clear();
            this.bytesForClassesToEnhanceByClassName = null;
        }
        this.componentsToEnhance.clear();
        return classNames.size();
    }

    public int validate() {
        this.init();
        if (this.componentsToEnhance.isEmpty()) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        Collection<FileMetaData> fileMetaData = this.getFileMetadataForInput();
        long inputTime = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        for (FileMetaData filemd : fileMetaData) {
            for (int packagenum = 0; packagenum < filemd.getNoOfPackages(); ++packagenum) {
                PackageMetaData pmd = filemd.getPackage(packagenum);
                for (int classnum = 0; classnum < pmd.getNoOfClasses(); ++classnum) {
                    ClassMetaData cmd = pmd.getClass(classnum);
                    if (classNames.contains(cmd.getFullClassName())) continue;
                    classNames.add(cmd.getFullClassName());
                    byte[] bytes = this.bytesForClassesToEnhanceByClassName != null ? this.bytesForClassesToEnhanceByClassName.get(cmd.getFullClassName()) : null;
                    ClassEnhancer classEnhancer = this.getClassEnhancer(cmd, bytes);
                    this.validateClass(cmd, classEnhancer);
                }
            }
        }
        long enhanceTime = System.currentTimeMillis();
        String msg = LOCALISER.msg("Enhancer.Success", (Object)classNames.size(), (Object)("" + (inputTime - startTime)), (Object)("" + (enhanceTime - inputTime)), (Object)("" + (enhanceTime - startTime)));
        this.addMessage(msg, false);
        if (this.bytesForClassesToEnhanceByClassName != null) {
            this.bytesForClassesToEnhanceByClassName.clear();
            this.bytesForClassesToEnhanceByClassName = null;
        }
        this.componentsToEnhance.clear();
        return classNames.size();
    }

    protected Collection<FileMetaData> getFileMetadataForInput() {
        MetaDataManager metadataMgr = this.getMetaDataManager();
        Iterator<EnhanceComponent> iter = this.componentsToEnhance.iterator();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        while (iter.hasNext()) {
            EnhanceComponent comp = iter.next();
            FileMetaData[] filemds = null;
            switch (comp.getType()) {
                case 0: {
                    if (comp.getValue() instanceof String) {
                        String className = (String)comp.getValue();
                        if (this.bytesForClassesToEnhanceByClassName != null && this.bytesForClassesToEnhanceByClassName.get(className) != null) {
                            AbstractClassMetaData cmd = metadataMgr.getMetaDataForClass(className, this.clr);
                            if (cmd == null) break;
                            filemds = new FileMetaData[]{cmd.getPackageMetaData().getFileMetaData()};
                            break;
                        }
                        filemds = metadataMgr.loadClasses(new String[]{(String)comp.getValue()}, this.userClassLoader);
                        break;
                    }
                    filemds = metadataMgr.loadClasses((String[])comp.getValue(), this.userClassLoader);
                    break;
                }
                case 1: {
                    if (comp.getValue() instanceof String) {
                        String className = null;
                        String classFilename = (String)comp.getValue();
                        if (!StringUtils.getFileForFilename((String)classFilename).exists()) {
                            String msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classFilename);
                            this.addMessage(msg, true);
                        } else {
                            className = this.getClassNameForFilename(classFilename);
                        }
                        if (className == null) break;
                        filemds = metadataMgr.loadClasses(new String[]{className}, this.userClassLoader);
                        break;
                    }
                    ArrayList<String> classNames = new ArrayList<String>();
                    String[] classFilenames = (String[])comp.getValue();
                    for (int i = 0; i < classFilenames.length; ++i) {
                        String className = null;
                        if (!StringUtils.getFileForFilename((String)classFilenames[i]).exists()) {
                            String msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classFilenames[i]);
                            this.addMessage(msg, true);
                        } else {
                            className = this.getClassNameForFilename(classFilenames[i]);
                        }
                        if (className == null) continue;
                        classNames.add(className);
                    }
                    filemds = metadataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), this.userClassLoader);
                    break;
                }
                case 2: {
                    if (comp.getValue() instanceof String) {
                        filemds = metadataMgr.loadMetadataFiles(new String[]{(String)comp.getValue()}, this.userClassLoader);
                        break;
                    }
                    filemds = metadataMgr.loadMetadataFiles((String[])comp.getValue(), this.userClassLoader);
                    break;
                }
                case 3: {
                    if (comp.getValue() instanceof String) {
                        filemds = metadataMgr.loadJar((String)comp.getValue(), this.userClassLoader);
                        break;
                    }
                    String[] jarFilenames = (String[])comp.getValue();
                    HashSet<FileMetaData> filemdsColl = new HashSet<FileMetaData>();
                    for (int i = 0; i < jarFilenames.length; ++i) {
                        FileMetaData[] fmds = metadataMgr.loadJar(jarFilenames[i], this.userClassLoader);
                        for (int j = 0; j < fmds.length; ++j) {
                            filemdsColl.add(fmds[j]);
                        }
                    }
                    filemds = filemdsColl.toArray(new FileMetaData[filemdsColl.size()]);
                    break;
                }
                case 4: {
                    PersistenceUnitMetaData pumd = null;
                    try {
                        pumd = this.getMetaDataManager().getMetaDataForPersistenceUnit((String)comp.getValue());
                    }
                    catch (NucleusException ne) {
                        throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.PersistenceUnit.NoPersistenceFiles", comp.getValue()));
                    }
                    if (pumd == null) {
                        throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.PersistenceUnit.NoSuchUnit", comp.getValue()));
                    }
                    filemds = metadataMgr.loadPersistenceUnit(pumd, this.userClassLoader);
                    break;
                }
            }
            if (filemds == null) continue;
            for (int i = 0; i < filemds.length; ++i) {
                fileMetaData.add(filemds[i]);
            }
        }
        return fileMetaData;
    }

    public byte[] getEnhancedBytes(String className) {
        byte[] bytes;
        if (this.enhancedBytesByClassName != null && (bytes = this.enhancedBytesByClassName.get(className)) != null) {
            return bytes;
        }
        throw new NucleusException("No enhanced bytes available for " + className);
    }

    protected void resetEnhancement() {
        if (this.enhancedBytesByClassName != null) {
            this.enhancedBytesByClassName.clear();
            this.enhancedBytesByClassName = null;
        }
    }

    protected ClassEnhancer getClassEnhancer(ClassMetaData cmd, byte[] bytes) {
        ClassEnhancer classEnhancer = null;
        try {
            Constructor ctr = null;
            if (bytes != null) {
                ctr = this.classEnhancerClass.getConstructor(ClassMetaData.class, ClassLoaderResolver.class, MetaDataManager.class, byte[].class);
                classEnhancer = (ClassEnhancer)ctr.newInstance(cmd, this.clr, this.nucleusContext.getMetaDataManager(), bytes);
            } else {
                ctr = this.classEnhancerClass.getConstructor(ClassMetaData.class, ClassLoaderResolver.class, MetaDataManager.class);
                classEnhancer = (ClassEnhancer)ctr.newInstance(cmd, this.clr, this.nucleusContext.getMetaDataManager());
            }
        }
        catch (NoSuchMethodException e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorNotFound", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)e.getMessage());
            LOGGER.error((Object)msg, (Throwable)e);
            throw new NucleusEnhanceException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorError", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)e.getTargetException());
            LOGGER.error((Object)msg, (Throwable)e);
            throw new NucleusEnhanceException(msg, e);
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorError", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)e.getMessage());
            LOGGER.error((Object)msg, (Throwable)e);
            throw new NucleusEnhanceException(msg, e);
        }
        HashSet<String> options = new HashSet<String>();
        if (this.generatePK) {
            options.add("generate-primary-key");
        }
        if (this.generateConstructor) {
            options.add("generate-default-constructor");
        }
        classEnhancer.setOptions(options);
        return classEnhancer;
    }

    protected String getClassNameForFilename(String filename) {
        String className = null;
        try {
            Method method = ClassUtils.getMethodForClass((Class)this.classEnhancerClass, (String)"getClassNameForFileName", (Class[])new Class[]{String.class});
            className = (String)method.invoke(null, (Object[])new String[]{filename});
        }
        catch (InvocationTargetException ex) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.MethodNotFound", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)"getClassNameForFileName", (Object)ex.getTargetException());
            this.addMessage(msg, true);
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.MethodNotFound", (Object)this.enhancerName, (Object)this.classEnhancerClass.getName(), (Object)"getClassNameForFileName", (Object)e);
            this.addMessage(msg, true);
        }
        return className;
    }

    protected void addMessage(String msg, boolean error) {
        if (error) {
            LOGGER.error((Object)msg);
        } else {
            LOGGER.info((Object)msg);
        }
        if (this.systemOut) {
            System.out.println(msg);
        }
    }

    protected boolean enhanceClass(ClassMetaData cmd, ClassEnhancer enhancer, boolean store) {
        boolean success = true;
        try {
            boolean enhanced;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)LOCALISER.msg("Enhancer.EnhanceClassStart", (Object)cmd.getFullClassName()));
            }
            if (enhanced = enhancer.enhance()) {
                if (this.enhancedBytesByClassName == null) {
                    this.enhancedBytesByClassName = new HashMap<String, byte[]>();
                }
                this.enhancedBytesByClassName.put(cmd.getFullClassName(), enhancer.getClassBytes());
                if (store) {
                    enhancer.save(this.getOutputDirectory());
                }
                if (this.isVerbose()) {
                    if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                        this.addMessage("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
                    } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                        this.addMessage("ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
                    } else {
                        this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                    }
                }
            } else {
                if (this.isVerbose()) {
                    if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                        this.addMessage("ERROR (PersistenceCapable) : " + cmd.getFullClassName(), false);
                    } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                        this.addMessage("ERROR (PersistenceAware) : " + cmd.getFullClassName(), false);
                    } else {
                        this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                    }
                }
                if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                    success = false;
                }
            }
        }
        catch (IOException ioe) {
            if (this.isVerbose()) {
                this.addMessage("ERROR (NonPersistent) : " + cmd.getFullClassName(), false);
            }
            String msg = LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)cmd.getFullClassName(), (Object)ioe.getMessage());
            LOGGER.error((Object)msg, (Throwable)ioe);
            System.out.println(msg);
            success = false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)LOCALISER.msg("Enhancer.EnhanceClassEnd", (Object)cmd.getFullClassName()));
        }
        return success;
    }

    protected boolean validateClass(ClassMetaData cmd, ClassEnhancer enhancer) {
        boolean enhanced;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)LOCALISER.msg("Enhancer.ValidateClassStart", (Object)cmd.getFullClassName()));
        }
        if (enhanced = enhancer.validate()) {
            if (this.isVerbose()) {
                if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    this.addMessage("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
                } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                    this.addMessage("ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
                } else {
                    this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                }
            }
        } else if (this.isVerbose()) {
            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                this.addMessage("NOT ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
            } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                this.addMessage("NOT ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
            } else {
                this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)LOCALISER.msg("Enhancer.ValidateClassEnd", (Object)cmd.getFullClassName()));
        }
        return true;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("VendorName", "DataNucleus");
        props.setProperty("VersionNumber", this.nucleusContext.getPluginManager().getVersionForBundle("org.datanucleus.enhancer"));
        props.setProperty("API", this.apiName);
        props.setProperty("EnhancerName", this.enhancerName);
        return props;
    }

    public static void main(String[] args) throws Exception {
        String val;
        CommandLine cmd = new CommandLine();
        cmd.addOption("pu", "persistenceUnit", "<name-of-persistence-unit>", "name of the persistence unit to enhance");
        cmd.addOption("d", "dest", "<directory>", "output directory");
        cmd.addOption("checkonly", "checkonly", null, "only check if the class is enhanced");
        cmd.addOption("q", "quiet", null, "no output");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("api", "api", "<api-name>", "API Name (JDO, JPA, etc)");
        cmd.addOption("enhancerName", "enhancerName", "<enhancer-name>", "Class Enhancer name (ASM, etc)");
        cmd.addOption("generatePK", "generatePK", "<generate-pk>", "Generate PK class where needed?");
        cmd.addOption("generateConstructor", "generateConstructor", "<generate-constructor>", "Generate default constructor where needed?");
        cmd.parse(args);
        String apiName = cmd.hasOption("api") ? cmd.getOptionArg("api") : "JDO";
        String enhancerName = cmd.hasOption("enhancerName") ? cmd.getOptionArg("enhancerName") : "ASM";
        DataNucleusEnhancer enhancer = new DataNucleusEnhancer(apiName, enhancerName);
        boolean quiet = false;
        if (cmd.hasOption("q")) {
            quiet = true;
            if (cmd.hasOption("v")) {
                enhancer.setVerbose(true);
            }
        }
        if (!quiet) {
            enhancer.setSystemOut(true);
        }
        if (cmd.hasOption("d")) {
            String destination = cmd.getOptionArg("d");
            File tmp = new File(destination);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    System.out.println(destination + " is not directory. please set directory.");
                    System.exit(1);
                }
            } else {
                tmp.mkdirs();
            }
            enhancer.setOutputDirectory(destination);
        }
        if (cmd.hasOption("generateConstructor") && (val = cmd.getOptionArg("generateConstructor")).equalsIgnoreCase("false")) {
            enhancer.setGenerateConstructor(false);
        }
        if (cmd.hasOption("generatePK") && (val = cmd.getOptionArg("generatePK")).equalsIgnoreCase("false")) {
            enhancer.setGeneratePK(false);
        }
        boolean validating = cmd.hasOption("checkonly");
        String persistenceUnitName = cmd.hasOption("pu") ? cmd.getOptionArg("pu") : null;
        String[] filenames = cmd.getDefaultArgs();
        String msg = null;
        String version = enhancer.nucleusContext.getPluginManager().getVersionForBundle("org.datanucleus.enhancer");
        msg = validating ? LOCALISER.msg("Enhancer.Title.Validate", (Object)version) : LOCALISER.msg("Enhancer.Title.Enhance", (Object)version);
        LOGGER.info((Object)msg);
        if (!quiet) {
            System.out.println(msg);
        }
        LOGGER.debug((Object)LOCALISER.msg("Enhancer.Classpath"));
        if (enhancer.isVerbose()) {
            System.out.println(LOCALISER.msg("Enhancer.Classpath"));
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            String entry = LOCALISER.msg("Enhancer.Classpath.Entry", (Object)tokeniser.nextToken());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)entry);
            }
            if (!enhancer.isVerbose()) continue;
            System.out.println(entry);
        }
        if (enhancer.isVerbose()) {
            System.out.flush();
        }
        int numClasses = 0;
        try {
            if (persistenceUnitName != null) {
                enhancer.addPersistenceUnit(persistenceUnitName);
            } else {
                enhancer.addFiles(filenames);
            }
            numClasses = validating ? enhancer.validate() : enhancer.enhance();
        }
        catch (NucleusException jpe) {
            System.out.println(jpe.getMessage());
            msg = LOCALISER.msg("Enhancer.Failure");
            LOGGER.error((Object)msg, (Throwable)jpe);
            if (!quiet) {
                System.out.println(msg);
            }
            System.exit(1);
        }
        if (numClasses == 0) {
            msg = LOCALISER.msg("Enhancer.NoClassesEnhanced");
            LOGGER.info((Object)msg);
            if (!quiet) {
                System.out.println(msg);
            }
        }
    }

    class EnhanceComponent {
        public static final int CLASS = 0;
        public static final int CLASS_FILE = 1;
        public static final int MAPPING_FILE = 2;
        public static final int JAR_FILE = 3;
        public static final int PERSISTENCE_UNIT = 4;
        int type;
        Object value;

        public EnhanceComponent(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }
}

