/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.file;

import java.io.File;
import java.util.regex.Pattern;

/**
 * {@link FileFilter} that can be configured to accepted files and/or folders 
 * based on a regular expression.<br/><br/>
 * Created: 24.02.2010 07:09:52
 * @since 0.5.0
 * @author Volker Bergmann
 */
public class PatternFileFilter implements FileFilter {
	
	private Pattern pattern;
	private boolean acceptingFiles;
	private boolean acceptingFolders;

	public PatternFileFilter(String regex, boolean acceptingFiles, boolean acceptingFolders) {
	    this.pattern = (regex != null ? Pattern.compile(regex) : null);
	    this.acceptingFiles = acceptingFiles;
	    this.acceptingFolders = acceptingFolders;
    }

	@Override
	public boolean accept(File file) {
		if (pattern != null && !pattern.matcher(file.getName()).matches())
	    	return false;
		return (acceptingFiles && file.isFile()) || (acceptingFolders && file.isDirectory());
    }

}
