/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;

/**
 * Extracts a sub string from a string.<br/><br/>
 * Created: 26.02.2010 10:55:11
 * @since 0.5.0
 * @author Volker Bergmann
 */
public class SubstringExtractor extends ThreadSafeConverter<String, String> {
	
	private int from;
	private Integer to;

	public SubstringExtractor() {
	    this(0);
    }

	public SubstringExtractor(int from) {
	    this(from, null);
    }

	public SubstringExtractor(int from, Integer to) {
	    super(String.class, String.class);
	    this.from = from;
	    this.to = to;
    }

	public void setFrom(int from) {
    	this.from = from;
    }

	public void setTo(Integer to) {
    	this.to = to;
    }

	@Override
	public String convert(String sourceValue) throws ConversionException {
		if (sourceValue == null)
			return null;
		if (to == null)
			return sourceValue.substring(relativeIndex(from, sourceValue));
		else
			return sourceValue.substring(relativeIndex(from, sourceValue), relativeIndex(to, sourceValue));
    }

	private static int relativeIndex(int index, String sourceValue) {
	    return (index >= 0 ? index : sourceValue.length() + index);
    }

}
