/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons;

import java.util.Locale;

/**
 * Provides Java constants for common {@link Locale}s.<br/><br/>
 * Created: 26.03.2010 18:52:58
 * @since 0.5.0
 * @author Volker Bergmann
 */
public interface Locales {

	public static final Locale AFRIKAANS = new Locale("af");
	public static final Locale ALBANIAN = new Locale("sq");
	public static final Locale ARABIC = new Locale("ar");
	public static final Locale BELARUSIAN = new Locale("be");
	public static final Locale BOSNIAN = new Locale("bs");
	public static final Locale BULGARIAN = new Locale("bg");
	public static final Locale CATALAN = new Locale("ca");
	public static final Locale CZECH = new Locale("cs");
	public static final Locale CHINESE = Locale.CHINESE;
	public static final Locale DANISH = new Locale("da");
	public static final Locale GERMAN = Locale.GERMAN;
	public static final Locale DUTCH = new Locale("nl");
	public static final Locale GREEK = new Locale("el");
	public static final Locale ENGLISH = Locale.ENGLISH;
	public static final Locale ESTONIAN = new Locale("et");
	public static final Locale FINISH = new Locale("fi");
	public static final Locale FRENCH = Locale.FRENCH;
	public static final Locale HEBREW = new Locale("he");
	public static final Locale HINDI = new Locale("hi");
	public static final Locale CROATIAN = new Locale("hr");
	public static final Locale HUNGARIAN = new Locale("hu");
	public static final Locale INDONESIAN = new Locale("id");
	public static final Locale ITALIAN = Locale.ITALIAN; // it
	public static final Locale JAPANESE = Locale.JAPANESE; // ja
	public static final Locale KOREAN = Locale.KOREAN; // ko
	public static final Locale LATVIAN = new Locale("lv");
	public static final Locale LITHUANIAN = new Locale("lt");
	public static final Locale NORWEGIAN = new Locale("no");
	public static final Locale POLISH = new Locale("pl");
	public static final Locale PORTUGUESE = new Locale("pt");
	public static final Locale ROMANIAN = new Locale("ro");
	public static final Locale RUSSIAN = new Locale("ru");
	public static final Locale SLOVENIAN = new Locale("sl");
	public static final Locale SPANISH = new Locale("es");
	public static final Locale SWEDISH = new Locale("sv");
	public static final Locale THAI = new Locale("th");
	public static final Locale TURKISH = new Locale("tr");
	public static final Locale UKRAINIAN = new Locale("uk");
	public static final Locale VIETNAMESE = new Locale("vi");

}
