/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons;

/**
 * Provides names for frequently used encodings.<br/><br/>
 * Created: 16.12.2009 08:38:45
 * @since 0.5.0
 * @author Volker Bergmann
 */
public interface Encodings {
	
	public static final String ASCII = "US-ASCII";

	public static final String UTF_8    = "UTF-8";
	public static final String UTF_16   = "UTF-16";
	public static final String UTF_16BE = "UTF-16BE";
	public static final String UTF_16LE = "UTF-16LE";
	public static final String UTF_32   = "UTF-32";
	public static final String UTF_32BE = "UTF-32BE";
	public static final String UTF_32LE = "UTF-32LE";

	public static final String ISO_2022_CN = "ISO-2022-CN";
	public static final String ISO_2022_JP = "ISO-2022-JP";
	public static final String ISO_2022_JP2 = "ISO-2022-JP-2";
	public static final String ISO_2022_KR = "ISO-2022-KR";
	public static final String ISO_8859_1  = "ISO-8859-1";
	public static final String ISO_8859_13 = "ISO-8859-13";
	public static final String ISO_8859_15 = "ISO-8859-15";
	public static final String ISO_8859_2  = "ISO-8859-2";
	public static final String ISO_8859_3  = "ISO-8859-3";
	public static final String ISO_8859_4  = "ISO-8859-4";
	public static final String ISO_8859_5  = "ISO-8859-5";
	public static final String ISO_8859_6  = "ISO-8859-6";
	public static final String ISO_8859_7  = "ISO-8859-7";
	public static final String ISO_8859_8  = "ISO-8859-8";
	public static final String ISO_8859_9  = "ISO-8859-9";
	
	public static final String MAC_ROMAN   = "MacRoman";
	public static final String WIN_1252    = "windows-1252";

}
