/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.CascadeMapping;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.lifecycle.HibernateEventListenerUtils;
import org.compass.gps.device.hibernate.lifecycle.HibernateMirrorFilter;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;

public class HibernateEventListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final HibernateGpsDevice device;
    protected final HibernateMirrorFilter mirrorFilter;
    protected final boolean marshallIds;
    protected final boolean pendingCascades;
    protected final boolean processCollections;
    private Map<Object, Collection> pendingCreate = Collections.synchronizedMap(new IdentityHashMap());
    private Map<Object, Collection> pendingSave = Collections.synchronizedMap(new IdentityHashMap());

    public HibernateEventListener(HibernateGpsDevice device, boolean marshallIds, boolean pendingCascades, boolean processCollections) {
        this.device = device;
        this.mirrorFilter = device.getMirrorFilter();
        this.marshallIds = marshallIds;
        this.pendingCascades = pendingCascades;
        this.processCollections = processCollections;
    }

    public void onPostInsert(final PostInsertEvent postInsertEvent) {
        Object entity;
        if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
            return;
        }
        final CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror((entity = postInsertEvent.getEntity()).getClass(), CascadeMapping.Cascade.CREATE)) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterInsert(postInsertEvent)) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Creating [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    HibernateEventListener.this.doInsert(session, postInsertEvent, entity, compassGps);
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while creating [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while creating [" + entity + "]"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostUpdate(final PostUpdateEvent postUpdateEvent) {
        block12: {
            Object entity;
            if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
                return;
            }
            final CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
            if (!compassGps.hasMappingForEntityForMirror((entity = postUpdateEvent.getEntity()).getClass(), CascadeMapping.Cascade.SAVE)) {
                return;
            }
            if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterUpdate(postUpdateEvent)) {
                return;
            }
            HashSet collectionsBefore = null;
            if (this.processCollections) {
                collectionsBefore = new HashSet(postUpdateEvent.getSession().getPersistenceContext().getCollectionEntries().values());
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)this.device.buildMessage("Updating [" + entity + "]"));
                }
                compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        HibernateEventListener.this.doUpdate(session, compassGps, entity, postUpdateEvent.getSession());
                    }
                });
            }
            catch (Exception e) {
                if (this.device.isIgnoreMirrorExceptions()) {
                    this.log.error((Object)this.device.buildMessage("Failed while updating [" + entity + "]"), (Throwable)e);
                }
                throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while updating [" + entity + "]"), e);
            }
            finally {
                if (!this.processCollections) break block12;
                Collection collectionsAfter = postUpdateEvent.getSession().getPersistenceContext().getCollectionEntries().values();
                for (CollectionEntry collection : collectionsAfter) {
                    if (collectionsBefore.contains(collection)) continue;
                    collection.setProcessed(true);
                }
            }
        }
    }

    public void onPostDelete(PostDeleteEvent postDeleteEvent) {
        Object entity;
        if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
            return;
        }
        CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror((entity = postDeleteEvent.getEntity()).getClass(), CascadeMapping.Cascade.DELETE)) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterDelete(postDeleteEvent)) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Deleting [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    session.delete(entity);
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while deleting [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while deleting [" + entity + "]"), e);
        }
    }

    protected void doInsert(CompassSession session, PostInsertEvent postInsertEvent, Object entity, CompassGpsInterfaceDevice compassGps) {
        if (this.marshallIds) {
            Serializable id = postInsertEvent.getId();
            postInsertEvent.getPersister().setIdentifier(entity, id, postInsertEvent.getSession().getEntityMode());
        }
        HashSet collectionsBefore = null;
        if (this.processCollections) {
            collectionsBefore = new HashSet(postInsertEvent.getSession().getPersistenceContext().getCollectionEntries().values());
        }
        if (this.pendingCascades) {
            HibernateEventListenerUtils.registerRemovalHook(postInsertEvent.getSession(), this.pendingCreate, entity);
            Collection dependencies = HibernateEventListenerUtils.getUnpersistedCascades(compassGps, entity, (SessionFactoryImplementor)this.device.getSessionFactory(), CascadeMapping.Cascade.CREATE, new HashSet());
            if (!dependencies.isEmpty()) {
                this.pendingCreate.put(entity, dependencies);
            } else {
                dependencies = HibernateEventListenerUtils.getAssociatedDependencies(entity, this.pendingCreate);
                if (!dependencies.isEmpty()) {
                    this.pendingCreate.put(entity, dependencies);
                } else {
                    session.create(entity);
                }
            }
            HibernateEventListenerUtils.persistPending(session, entity, this.pendingCreate, true);
        } else {
            session.create(entity);
        }
        if (this.processCollections) {
            Collection collectionsAfter = postInsertEvent.getSession().getPersistenceContext().getCollectionEntries().values();
            for (CollectionEntry collection : collectionsAfter) {
                if (collectionsBefore.contains(collection)) continue;
                collection.setProcessed(true);
            }
        }
    }

    protected void doUpdate(CompassSession session, CompassGpsInterfaceDevice compassGps, Object entity, EventSource eventSource) {
        if (this.pendingCascades) {
            HibernateEventListenerUtils.registerRemovalHook(eventSource, this.pendingSave, entity);
            Collection dependencies = HibernateEventListenerUtils.getUnpersistedCascades(compassGps, entity, (SessionFactoryImplementor)this.device.getSessionFactory(), CascadeMapping.Cascade.SAVE, new HashSet());
            if (!dependencies.isEmpty()) {
                this.pendingSave.put(entity, dependencies);
            } else {
                dependencies = HibernateEventListenerUtils.getAssociatedDependencies(entity, this.pendingSave);
                if (!dependencies.isEmpty()) {
                    this.pendingSave.put(entity, dependencies);
                } else {
                    session.save(entity);
                }
            }
            HibernateEventListenerUtils.persistPending(session, entity, this.pendingSave, false);
        } else {
            session.save(entity);
        }
    }
}

