/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.reflection.ReflectionConstructor;
import org.compass.core.util.reflection.ReflectionField;
import org.compass.core.util.reflection.ReflectionMethod;
import org.compass.core.util.reflection.asm.AsmReflectionConstructorGenerator;
import org.compass.core.util.reflection.asm.AsmReflectionFieldGenerator;
import org.compass.core.util.reflection.asm.AsmReflectionMethodGenerator;
import org.compass.core.util.reflection.plain.PlainReflectionConstructor;
import org.compass.core.util.reflection.plain.PlainReflectionField;
import org.compass.core.util.reflection.plain.PlainReflectionMethod;

public class ReflectionFactory {
    private static final Log log = LogFactory.getLog(ReflectionFactory.class);

    public static ReflectionMethod getMethod(CompassSettings settings, Method method) throws NoSuchMethodException {
        block3: {
            if (ReflectionFactory.canGenerateAsm(method) && "asm".equals(settings.getSetting("compass.reflection.type", "asm"))) {
                try {
                    return AsmReflectionMethodGenerator.generateMethod(method);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to generate ASM (should have worked...) for method [" + method + "]"), (Throwable)e);
                }
            }
        }
        return new PlainReflectionMethod(method);
    }

    public static ReflectionField getField(CompassSettings settings, Field field) throws NoSuchFieldException {
        block3: {
            if (ReflectionFactory.canGenerateAsm(field) && "asm".equals(settings.getSetting("compass.reflection.type", "asm"))) {
                try {
                    return AsmReflectionFieldGenerator.generateField(field);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to generate ASM (should have worked...) for field [" + field + "]"), (Throwable)e);
                }
            }
        }
        return new PlainReflectionField(field);
    }

    public static ReflectionConstructor getDefaultConstructor(CompassSettings settings, Class clazz) {
        Constructor defaultConstructor = ClassUtils.getDefaultConstructor(clazz);
        if (defaultConstructor == null) {
            return null;
        }
        return ReflectionFactory.getConstructor(settings, defaultConstructor);
    }

    public static ReflectionConstructor getConstructor(CompassSettings settings, Constructor constructor) {
        block3: {
            if (ReflectionFactory.canGenerateAsm(constructor) && "asm".equals(settings.getSetting("compass.reflection.type", "asm"))) {
                try {
                    return AsmReflectionConstructorGenerator.generateConstructor(constructor);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to generate ASM (should have worked...) for constructor [" + constructor + "]"), (Throwable)e);
                }
            }
        }
        return new PlainReflectionConstructor(constructor);
    }

    private static boolean canGenerateAsm(Member member) {
        return !Modifier.isPrivate(member.getModifiers());
    }
}

