/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.terracotta.TerracottaDirectory;
import org.compass.needle.terracotta.TerracottaFile;

public class TerracottaIndexOutput
extends IndexOutput {
    private final int bufferSize;
    private final int flushRate;
    private final String name;
    private TerracottaFile file;
    private byte[] firstBuffer;
    private byte[] buffer;
    private int bufferPosition;
    private int currentBucketIndex;
    private int flushCounter;
    private long length;
    private long position;
    private boolean open;
    private boolean seekOccured;

    TerracottaIndexOutput(TerracottaDirectory dir, String name) {
        this.name = name;
        this.bufferSize = dir.getBufferSize();
        this.flushRate = dir.getFlushRate();
        this.file = new TerracottaFile();
        dir.addFile(name, this.file);
        this.file.lock();
        this.file.addBuffer(0);
        this.open = true;
        this.buffer = new byte[this.bufferSize];
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferSize) {
            if (this.seekOccured) {
                throw new IOException("Seek occured and overflowed first buffer for file [" + this.name + "]");
            }
            this.flushBuffer();
        }
        this.buffer[this.bufferPosition++] = b;
        if (!this.seekOccured) {
            ++this.length;
            ++this.position;
        }
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        if (!this.seekOccured) {
            this.position += (long)len;
            this.length += (long)len;
        }
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferSize) {
                if (this.seekOccured) {
                    throw new IOException("Seek occured and overflowed first bucket for file [" + this.name + "]");
                }
                this.flushBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.bufferSize - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.buffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flushBuffer();
        this.file.setFirstBuffer(this.firstBuffer);
        this.file.setLength(this.length);
        this.file.setLastModified(System.currentTimeMillis());
        this.file.unlock();
        this.buffer = null;
        this.firstBuffer = null;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        if (pos >= (long)this.bufferSize) {
            throw new IOException("seek called outside of first buffer boundries for file [" + this.name + "]");
        }
        if (this.firstBuffer == null) {
            this.firstBuffer = new byte[this.bufferPosition];
            System.arraycopy(this.buffer, 0, this.firstBuffer, 0, this.bufferPosition);
        } else if (!this.seekOccured) {
            this.flushBuffer(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        this.position = pos;
        this.currentBucketIndex = 0;
        this.bufferPosition = (int)pos;
        this.buffer = this.firstBuffer;
        this.seekOccured = true;
    }

    public long length() throws IOException {
        return this.length;
    }

    private void flushBuffer() throws IOException {
        if (this.currentBucketIndex == 0) {
            if (this.firstBuffer == null) {
                this.firstBuffer = new byte[this.bufferPosition];
                System.arraycopy(this.buffer, 0, this.firstBuffer, 0, this.bufferPosition);
            }
        } else if (this.bufferPosition > 0) {
            this.flushBuffer(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        ++this.currentBucketIndex;
        this.bufferPosition = 0;
    }

    private void flushBuffer(long bucketIndex, byte[] buffer, int length) throws IOException {
        byte[] data = this.file.addBuffer(length);
        System.arraycopy(buffer, 0, data, 0, length);
        if (++this.flushCounter == this.flushRate) {
            this.flushCounter = 0;
            this.file.unlock();
            this.file.lock();
        }
    }
}

