/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.io.ExternalizableLite;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.compass.needle.coherence.FileKey;

public class FileBucketKey
implements FileKey,
ExternalizableLite {
    private String indexName;
    private String fileName;
    private long bucketIndex;

    public FileBucketKey() {
    }

    public FileBucketKey(String indexName, String fileName, long bucketIndex) {
        this.indexName = indexName;
        this.fileName = fileName;
        this.bucketIndex = bucketIndex;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getBucketIndex() {
        return this.bucketIndex;
    }

    public byte getType() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((FileKey)o).getType() != this.getType()) {
            return false;
        }
        FileBucketKey that = (FileBucketKey)o;
        if (this.bucketIndex != that.bucketIndex) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        return this.indexName.equals(that.indexName);
    }

    public int hashCode() {
        int result = this.getType();
        result = 31 * result + this.indexName.hashCode();
        result = 31 * result + this.fileName.hashCode();
        result = 31 * result + (int)(this.bucketIndex ^ this.bucketIndex >>> 32);
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
        this.indexName = in.readUTF();
        this.fileName = in.readUTF();
        this.bucketIndex = in.readLong();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.indexName);
        out.writeUTF(this.fileName);
        out.writeLong(this.bucketIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("fileBucketKey: indexName[").append(this.indexName).append("]");
        sb.append(" fileName[").append(this.fileName).append("]");
        sb.append(" bucketIndex[").append(this.bucketIndex).append("]");
        return sb.toString();
    }
}

