/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.OverrideByNameMapping;
import org.compass.core.mapping.internal.InternalMultipleMapping;
import org.compass.core.mapping.support.AbstractMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultipleMapping
extends AbstractMapping
implements InternalMultipleMapping {
    protected ArrayList<Mapping> mappings = new ArrayList();
    protected Map<String, Mapping> mappingsByNameMap = new HashMap<String, Mapping>();

    public void removeExistingByName(Mapping mapping) {
        if (this.mappingsByNameMap.get(mapping.getName()) != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                Mapping tempMapping = this.mappings.get(i);
                if (tempMapping.getName() == null || !tempMapping.getName().equals(mapping.getName())) continue;
                this.mappings.remove(i);
                break;
            }
            this.mappingsByNameMap.remove(mapping.getName());
        }
    }

    @Override
    public int addMapping(Mapping mapping) {
        if (mapping instanceof OverrideByNameMapping && ((OverrideByNameMapping)mapping).isOverrideByName()) {
            this.removeExistingByName(mapping);
        }
        this.mappingsByNameMap.put(mapping.getName(), mapping);
        this.mappings.add(mapping);
        return this.mappings.size() - 1;
    }

    public void addMappings(MultipleMapping mapping) {
        Iterator<Mapping> it = mapping.mappingsIt();
        while (it.hasNext()) {
            this.addMapping(it.next());
        }
    }

    public void replaceMappings(MultipleMapping mapping) {
        this.clearMappings();
        this.addMappings(mapping);
    }

    @Override
    public Iterator<Mapping> mappingsIt() {
        return this.mappings.iterator();
    }

    public int mappingsSize() {
        return this.mappings.size();
    }

    @Override
    public Mapping getMapping(String name) {
        return this.mappingsByNameMap.get(name);
    }

    @Override
    public Mapping getMapping(int index) {
        return this.mappings.get(index);
    }

    public void clearMappings() {
        this.mappings.clear();
        this.mappingsByNameMap.clear();
    }

    protected void copy(InternalMultipleMapping mapping) {
        super.copy(mapping);
        Iterator<Mapping> it = this.mappingsIt();
        while (it.hasNext()) {
            mapping.addMapping(it.next().copy());
        }
    }

    protected void shallowCopy(InternalMultipleMapping mapping) {
        super.copy(mapping);
    }
}

