/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.support.NullResourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompassMapping
implements InternalCompassMapping {
    private final Map<String, AliasMapping> mappings = new ConcurrentHashMap<String, AliasMapping>();
    private final Map<String, ResourceMapping> rootMappingsByAlias = new ConcurrentHashMap<String, ResourceMapping>();
    private final Map<String, ResourceMapping> nonRootMappingsByAlias = new ConcurrentHashMap<String, ResourceMapping>();
    private final ResourceMappingsByNameHolder mappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder rootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedRootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder nonRootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedNonRootMappingsByClass = new ResourceMappingsByNameHolder();
    private ResourceMapping[] rootMappingsArr = new ResourceMapping[0];
    private ConverterLookup converterLookup;
    private final NullResourceMapping nullResourceMappingEntryInCache = new NullResourceMapping();
    private final Map<String, ResourcePropertyMapping[]> resourcePropertyMappingByPath = new ConcurrentHashMap<String, ResourcePropertyMapping[]>();
    private PropertyPath path;
    private ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCompassMapping copy(ConverterLookup converterLookup) {
        this.writeLock.lock();
        try {
            DefaultCompassMapping copy = new DefaultCompassMapping();
            copy.converterLookup = converterLookup;
            copy.setPath(this.getPath());
            for (AliasMapping aliasMapping : this.mappings.values()) {
                AliasMapping copyMapping = (AliasMapping)aliasMapping.copy();
                copy.addMapping(copyMapping);
            }
            DefaultCompassMapping defaultCompassMapping = copy;
            return defaultCompassMapping;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postProcess() {
        this.writeLock.lock();
        try {
            ResourceMapping[] rootMappings;
            for (ResourceMapping rootMapping : rootMappings = this.getRootMappings()) {
                ResourcePropertyMapping[] resourcePropertyMappings;
                for (ResourcePropertyMapping rpm : resourcePropertyMappings = rootMapping.getResourcePropertyMappings()) {
                    if (rpm.getPath() == null) continue;
                    String path = rpm.getPath().getPath();
                    ResourcePropertyMapping[] rpms = this.resourcePropertyMappingByPath.get(path);
                    if (rpms == null) {
                        this.resourcePropertyMappingByPath.put(path, new ResourcePropertyMapping[]{rpm});
                        continue;
                    }
                    ResourcePropertyMapping[] tmpRpms = new ResourcePropertyMapping[rpms.length + 1];
                    System.arraycopy(rpms, 0, tmpRpms, 0, rpms.length);
                    tmpRpms[tmpRpms.length - 1] = rpm;
                    this.resourcePropertyMappingByPath.put(path, tmpRpms);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearMappings() {
        this.writeLock.lock();
        try {
            this.mappings.clear();
            this.rootMappingsByAlias.clear();
            this.nonRootMappingsByAlias.clear();
            this.mappingsByClass.clear();
            this.rootMappingsByClass.clear();
            this.nonRootMappingsByClass.clear();
            this.rootMappingsArr = new ResourceMapping[0];
            this.resourcePropertyMappingByPath.clear();
            this.clearCache();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.writeLock.lock();
        try {
            this.cachedMappingsByClass.clear();
            this.cachedRootMappingsByClass.clear();
            this.cachedNonRootMappingsByClass.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapping(AliasMapping mapping) throws MappingException {
        this.writeLock.lock();
        try {
            if (this.mappings.get(mapping.getAlias()) != null) {
                throw new MappingException("Compass does not allow multiple aliases for alias [" + mapping.getAlias() + "]");
            }
            this.mappings.put(mapping.getAlias(), mapping);
            if (mapping instanceof ResourceMapping) {
                ResourceMapping resourceMapping = (ResourceMapping)mapping;
                if (resourceMapping.isRoot()) {
                    this.rootMappingsByAlias.put(mapping.getAlias(), resourceMapping);
                    if (resourceMapping instanceof ClassMapping) {
                        this.rootMappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                        this.mappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                    }
                    ResourceMapping[] result = new ResourceMapping[this.rootMappingsArr.length + 1];
                    for (int i = 0; i < this.rootMappingsArr.length; ++i) {
                        result[i] = this.rootMappingsArr[i];
                    }
                    result[i] = resourceMapping;
                    this.rootMappingsArr = result;
                } else {
                    this.nonRootMappingsByAlias.put(mapping.getAlias(), resourceMapping);
                    if (resourceMapping instanceof ClassMapping) {
                        this.mappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                        this.nonRootMappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMappingByClass(String className) throws MappingException {
        this.writeLock.lock();
        try {
            boolean result = false;
            List<ResourceMapping> resourceMappings = this.mappingsByClass.getMappingsByName(className);
            if (resourceMappings != null) {
                ResourceMapping[] rm;
                for (ResourceMapping resourceMapping : rm = resourceMappings.toArray(new ResourceMapping[resourceMappings.size()])) {
                    result |= this.removeMappingByAlias(resourceMapping.getAlias());
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMappingByAlias(String alias) throws MappingException {
        this.writeLock.lock();
        try {
            AliasMapping aliasMapping = this.mappings.remove(alias);
            if (aliasMapping == null) {
                boolean bl = false;
                return bl;
            }
            if (aliasMapping instanceof ResourceMapping) {
                ResourceMapping resourceMapping = (ResourceMapping)aliasMapping;
                if (resourceMapping.isRoot()) {
                    this.rootMappingsByAlias.remove(alias);
                    if (resourceMapping instanceof ClassMapping) {
                        this.rootMappingsByClass.removeMapping(resourceMapping);
                        this.mappingsByClass.removeMapping(resourceMapping);
                    }
                    ArrayList<ResourceMapping> l = new ArrayList<ResourceMapping>(this.rootMappingsArr.length);
                    for (ResourceMapping rm : this.rootMappingsArr) {
                        if (rm == resourceMapping) continue;
                        l.add(resourceMapping);
                    }
                    this.rootMappingsArr = l.toArray(new ResourceMapping[l.size()]);
                } else {
                    this.nonRootMappingsByAlias.remove(alias);
                    if (resourceMapping instanceof ClassMapping) {
                        this.mappingsByClass.removeMapping(resourceMapping);
                        this.nonRootMappingsByClass.removeMapping(resourceMapping);
                    }
                }
            }
            this.clearCache();
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ResourcePropertyLookup getResourcePropertyLookup(String name) throws IllegalArgumentException {
        return new ResourcePropertyLookup(this, name);
    }

    @Override
    public ResourcePropertyMapping getResourcePropertyMappingByPath(String path) {
        String[] extendingAliases;
        int dotIndex = path.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        String alias = path.substring(0, dotIndex);
        String propertyName = path.substring(dotIndex + 1);
        AliasMapping aliasMapping = this.getAliasMapping(alias);
        ResourcePropertyMapping resourcePropertyMapping = null;
        if (aliasMapping instanceof ResourceMapping) {
            resourcePropertyMapping = ((ResourceMapping)aliasMapping).getResourcePropertyMappingByDotPath(propertyName);
        } else if (aliasMapping != null && (extendingAliases = aliasMapping.getExtendingAliases()) != null) {
            String extendingAlias;
            ResourceMapping resourceMapping;
            String[] arr$ = extendingAliases;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((resourceMapping = this.getRootMappingByAlias(extendingAlias = arr$[i$])) == null || (resourcePropertyMapping = resourceMapping.getResourcePropertyMappingByDotPath(propertyName)) == null); ++i$) {
            }
        }
        if (resourcePropertyMapping == null) {
            throw new IllegalArgumentException("Failed to find mapping for alias [" + alias + "] and path [" + path + "]");
        }
        return resourcePropertyMapping;
    }

    @Override
    public ResourcePropertyMapping[] getResourcePropertyMappingsByPath(String path) {
        int dotIndex = path.indexOf(46);
        if (dotIndex != -1) {
            return new ResourcePropertyMapping[]{this.getResourcePropertyMappingByPath(path)};
        }
        return this.resourcePropertyMappingByPath.get(path);
    }

    @Override
    public AliasMapping[] getMappings() {
        return this.mappings.values().toArray(new AliasMapping[this.mappings.size()]);
    }

    @Override
    public AliasMapping getAliasMapping(String alias) {
        return this.mappings.get(alias);
    }

    @Override
    public ResourceMapping getMappingByAlias(String alias) {
        return (ResourceMapping)this.mappings.get(alias);
    }

    @Override
    public ResourceMapping getRootMappingByAlias(String alias) {
        return this.rootMappingsByAlias.get(alias);
    }

    @Override
    public ResourceMapping getNonRootMappingByAlias(String alias) {
        return this.nonRootMappingsByAlias.get(alias);
    }

    @Override
    public boolean hasRootMappingByAlias(String alias) {
        return this.rootMappingsByAlias.get(alias) != null;
    }

    @Override
    public boolean hasRootClassMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof ClassMapping;
    }

    @Override
    public boolean hasRootRawResourceMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof RawResourceMapping;
    }

    @Override
    public boolean hasMultipleRootClassMapping(String className) {
        return this.rootMappingsByClass.hasMultipleMappingsByName(className);
    }

    @Override
    public ResourceMapping getDirectMappingByClass(Class clazz) {
        return this.mappingsByClass.getResourceMappingByName(clazz.getName());
    }

    @Override
    public List<ResourceMapping> getAllDirectMappingByClass(Class clazz) {
        return this.mappingsByClass.getUnmodifiableMappingsByName(clazz.getName());
    }

    @Override
    public boolean hasMappingForClass(Class clazz, CascadeMapping.Cascade cascade) {
        ResourceMapping resourceMapping = this.getRootMappingByClass(clazz);
        if (resourceMapping != null) {
            return true;
        }
        resourceMapping = this.getNonRootMappingByClass(clazz);
        return resourceMapping != null && resourceMapping.operationAllowed(cascade);
    }

    @Override
    public boolean hasMappingForAlias(String alias, CascadeMapping.Cascade cascade) {
        ResourceMapping resourceMapping = this.getRootMappingByAlias(alias);
        if (resourceMapping != null) {
            return true;
        }
        resourceMapping = this.getNonRootMappingByAlias(alias);
        return resourceMapping != null && resourceMapping.operationAllowed(cascade);
    }

    @Override
    public ResourceMapping getMappingByClass(Class clazz) {
        return this.doGetResourceMappingByClass(clazz, false, this.mappingsByClass, this.cachedMappingsByClass);
    }

    @Override
    public ResourceMapping findRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, true, this.rootMappingsByClass, this.cachedRootMappingsByClass);
    }

    @Override
    public ResourceMapping getRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, false, this.rootMappingsByClass, this.cachedRootMappingsByClass);
    }

    @Override
    public ResourceMapping findNonRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, true, this.nonRootMappingsByClass, this.cachedNonRootMappingsByClass);
    }

    @Override
    public ResourceMapping getNonRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, false, this.nonRootMappingsByClass, this.cachedNonRootMappingsByClass);
    }

    private ResourceMapping doGetResourceMappingByClass(Class clazz, boolean throwEx, ResourceMappingsByNameHolder mappingByClass, ResourceMappingsByNameHolder cachedMappingsByClass) throws MappingException {
        String className = clazz.getName();
        ResourceMapping rm = cachedMappingsByClass.getResourceMappingByName(className);
        if (rm != null) {
            if (rm == this.nullResourceMappingEntryInCache) {
                if (throwEx) {
                    throw new MappingException("Failed to find any mappings for class [" + className + "]");
                }
                return null;
            }
            return rm;
        }
        rm = this.doGetActualResourceMappingByClass(clazz, mappingByClass);
        if (rm == null) {
            cachedMappingsByClass.addMapping(className, this.nullResourceMappingEntryInCache);
            if (throwEx) {
                throw new MappingException("Failed to find any mappings for class [" + className + "]");
            }
            return null;
        }
        cachedMappingsByClass.addMapping(className, rm);
        return rm;
    }

    private ResourceMapping doGetActualResourceMappingByClass(Class clazz, ResourceMappingsByNameHolder mappingByClass) {
        ResourceMapping rm = mappingByClass.getResourceMappingByName(clazz.getName());
        if (rm != null) {
            return rm;
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            rm = mappingByClass.getResourceMappingByName(anInterface.getName());
            if (rm == null) continue;
            return rm;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return this.doGetActualResourceMappingByClass(superClass, mappingByClass);
    }

    @Override
    public ResourceMapping[] getRootMappings() {
        return this.rootMappingsArr;
    }

    @Override
    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    @Override
    public PropertyPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(PropertyPath path) {
        this.path = path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceMappingsByNameHolder {
        private final HashMap<String, List<ResourceMapping>> mappings = new HashMap();
        private ReadWriteLock rwl = new ReentrantReadWriteLock();

        private ResourceMappingsByNameHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMapping(String name, ResourceMapping resourceMapping) {
            this.rwl.writeLock().lock();
            try {
                List<ResourceMapping> l = this.mappings.get(name);
                if (l == null) {
                    l = new ArrayList<ResourceMapping>();
                    this.mappings.put(name, l);
                }
                l.add(resourceMapping);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeMapping(ResourceMapping resourceMapping) {
            this.rwl.writeLock().lock();
            try {
                for (List<ResourceMapping> l : this.mappings.values()) {
                    l.remove(resourceMapping);
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.rwl.writeLock().lock();
            try {
                this.mappings.clear();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ResourceMapping> getMappingsByName(String name) {
            this.rwl.readLock().lock();
            try {
                List<ResourceMapping> list = this.mappings.get(name);
                return list;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ResourceMapping> getUnmodifiableMappingsByName(String name) {
            this.rwl.readLock().lock();
            try {
                List<ResourceMapping> list = Collections.unmodifiableList(this.mappings.get(name));
                return list;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceMapping getResourceMappingByName(String name) {
            this.rwl.readLock().lock();
            try {
                List<ResourceMapping> l = this.getMappingsByName(name);
                if (l == null) {
                    ResourceMapping resourceMapping = null;
                    return resourceMapping;
                }
                ResourceMapping resourceMapping = l.get(l.size() - 1);
                return resourceMapping;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMultipleMappingsByName(String name) {
            this.rwl.readLock().lock();
            try {
                List<ResourceMapping> l = this.getMappingsByName(name);
                boolean bl = l != null && l.size() > 1;
                return bl;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }
}

