/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;

public class LuceneSearchEngineMultiPhraseQueryBuilder
implements SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder {
    private LuceneSearchEngine searchEngine;
    private String resourceProperty;
    private MultiPhraseQuery multiPhraseQuery;

    public LuceneSearchEngineMultiPhraseQueryBuilder(LuceneSearchEngine searchEngine, String resourceProperty) {
        this.searchEngine = searchEngine;
        this.resourceProperty = resourceProperty;
        this.multiPhraseQuery = new MultiPhraseQuery();
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder setSlop(int slop) {
        this.multiPhraseQuery.setSlop(slop);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder add(String value) {
        this.multiPhraseQuery.add(new Term(this.resourceProperty, value));
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder add(String value, int position) {
        this.multiPhraseQuery.add(new Term[]{new Term(this.resourceProperty, value)}, position);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder add(String[] values) {
        Term[] terms = new Term[values.length];
        for (int i = 0; i < values.length; ++i) {
            terms[i] = new Term(this.resourceProperty, values[i]);
        }
        this.multiPhraseQuery.add(terms);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder add(String[] values, int position) {
        Term[] terms = new Term[values.length];
        for (int i = 0; i < values.length; ++i) {
            terms[i] = new Term(this.resourceProperty, values[i]);
        }
        this.multiPhraseQuery.add(terms, position);
        return this;
    }

    public SearchEngineQuery toQuery() {
        return new LuceneSearchEngineQuery(this.searchEngine, (Query)this.multiPhraseQuery);
    }
}

