/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AbstractOptimizer;

public class AdaptiveOptimizer
extends AbstractOptimizer
implements CompassConfigurable {
    private int mergeFactor;

    public void configure(CompassSettings settings) throws CompassException {
        this.mergeFactor = settings.getSettingAsInt("compass.engine.optimizer.adaptive.mergeFactor", 10);
    }

    public boolean canBeScheduled() {
        return true;
    }

    protected boolean isOptimizeOnlyIfIndexChanged() {
        return false;
    }

    protected void doForceOptimize(String subIndex) throws SearchEngineException {
        this.doOptimize(subIndex, 1);
    }

    protected void doOptimize(String subIndex) throws SearchEngineException {
        this.doOptimize(subIndex, this.mergeFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptimize(String subIndex, int mergeFactor) throws SearchEngineException {
        IndexWriter indexWriter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Optimizing sub-index [" + subIndex + "] with mergeFactor [" + mergeFactor + "]"));
        }
        long time = System.currentTimeMillis();
        LuceneSearchEngineIndexManager indexManager = (LuceneSearchEngineIndexManager)this.getSearchEngineFactory().getIndexManager();
        try {
            indexWriter = indexManager.openIndexWriter(indexManager.getSettings().getSettings(), subIndex);
        }
        catch (LockObtainFailedException e) {
            this.log.debug((Object)"Failed to obtain lock in order to optimizer, will try next time...");
            return;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open index writer for optimization for sub index [" + subIndex + "]", e);
        }
        try {
            indexWriter.optimize(mergeFactor);
        }
        catch (Exception e) {
            try {
                Directory dir = indexManager.getStore().openDirectory(subIndex);
                if (IndexReader.isLocked((Directory)dir)) {
                    IndexReader.unlock((Directory)dir);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        finally {
            try {
                indexWriter.close();
            }
            catch (Exception e) {}
        }
        long optimizeTime = System.currentTimeMillis() - time;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Optimization of sub-index [" + subIndex + "] took [" + optimizeTime + "ms]"));
        }
    }
}

