/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public class LuceneIndexHolder {
    private volatile long lastCacheInvalidation = System.currentTimeMillis();
    private IndexSearcher indexSearcher;
    private IndexReader indexReader;
    private int count = 0;
    private boolean markForClose = false;
    private String subIndex;

    public LuceneIndexHolder(String subIndex, IndexSearcher indexSearcher) {
        this.subIndex = subIndex;
        this.indexSearcher = indexSearcher;
        this.indexReader = indexSearcher.getIndexReader();
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public synchronized boolean acquire() {
        if (this.markForClose) {
            return false;
        }
        ++this.count;
        return true;
    }

    public synchronized void release() {
        --this.count;
        this.checkIfCanClose();
    }

    public synchronized void markForClose() {
        this.markForClose = true;
        this.checkIfCanClose();
    }

    private void checkIfCanClose() {
        if (this.markForClose && this.count <= 0) {
            try {
                this.indexSearcher.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.indexReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getLastCacheInvalidation() {
        return this.lastCacheInvalidation;
    }

    public void setLastCacheInvalidation(long lastCacheInvalidation) {
        this.lastCacheInvalidation = lastCacheInvalidation;
    }
}

