/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.ResourceFactory;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.FirstLevelCacheFactory;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.spellcheck.SearchEngineSpellCheckManager;
import org.compass.core.engine.spi.InternalSearchEngineFactory;
import org.compass.core.events.CompassEventManager;
import org.compass.core.events.RebuildEventListener;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.id.IdentifierGenerator;
import org.compass.core.id.UUIDGenerator;
import org.compass.core.impl.DefaultCompassSession;
import org.compass.core.jndi.CompassObjectFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionFactory;
import org.compass.core.transaction.TransactionFactoryFactory;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.transaction.context.TransactionContextCallback;
import org.compass.core.transaction.context.TransactionContextCallbackWithTr;

public class DefaultCompass
implements InternalCompass {
    private static final Log log = LogFactory.getLog(DefaultCompass.class);
    private static final long serialVersionUID = 3256446884762891059L;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDGenerator();
    private final String name;
    private String uuid;
    private CompassMapping mapping;
    private InternalSearchEngineFactory searchEngineFactory;
    private TransactionFactory transactionFactory;
    private LocalTransactionFactory localTransactionFactory;
    private ConverterLookup converterLookup;
    private CompassMetaData compassMetaData;
    private PropertyNamingStrategy propertyNamingStrategy;
    private ExecutorManager executorManager;
    private CompassEventManager eventManager;
    protected CompassSettings settings;
    private FirstLevelCacheFactory firstLevelCacheFactory;
    private boolean duplicate;
    private volatile boolean closed = false;

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, ExecutorManager executorManager, CompassSettings settings) throws CompassException {
        this(mapping, converterLookup, compassMetaData, propertyNamingStrategy, executorManager, settings, false);
    }

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, ExecutorManager executorManager, CompassSettings settings, boolean duplicate) throws CompassException {
        this(mapping, converterLookup, compassMetaData, propertyNamingStrategy, executorManager, settings, duplicate, new LuceneSearchEngineFactory(propertyNamingStrategy, settings, mapping, executorManager));
    }

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings, LuceneSearchEngineFactory searchEngineFactory) throws CompassException {
        this(mapping, converterLookup, compassMetaData, propertyNamingStrategy, searchEngineFactory.getExecutorManager(), settings, false, searchEngineFactory);
    }

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, ExecutorManager executorManager, CompassSettings settings, boolean duplicate, LuceneSearchEngineFactory searchEngineFactory) throws CompassException {
        this.mapping = mapping;
        this.converterLookup = converterLookup;
        this.compassMetaData = compassMetaData;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.executorManager = executorManager;
        this.name = settings.getSetting("compass.name", "default");
        this.settings = settings;
        this.duplicate = duplicate;
        this.eventManager = new CompassEventManager(this, mapping);
        this.eventManager.configure(settings);
        if (!duplicate) {
            this.registerJndi();
        }
        searchEngineFactory.setTransactionContext(new CompassTransactionContext(this));
        this.searchEngineFactory = searchEngineFactory;
        this.transactionFactory = TransactionFactoryFactory.createTransactionFactory(this, settings);
        this.localTransactionFactory = TransactionFactoryFactory.createLocalTransactionFactory(this, settings);
        this.firstLevelCacheFactory = new FirstLevelCacheFactory();
        this.firstLevelCacheFactory.configure(settings);
        searchEngineFactory.getIndexManager().verifyIndex();
        if (!duplicate) {
            this.start();
        }
    }

    public CompassConfiguration getConfig() {
        throw new UnsupportedOperationException();
    }

    public void rebuild() {
        throw new UnsupportedOperationException();
    }

    public void addRebuildEventListener(RebuildEventListener eventListener) {
        throw new UnsupportedOperationException();
    }

    public void removeRebuildEventListener(RebuildEventListener eventListener) {
        throw new UnsupportedOperationException();
    }

    public Compass clone(CompassSettings addedSettings) {
        CompassSettings copySettings = this.settings.copy();
        copySettings.addSettings(addedSettings);
        return new DefaultCompass(this.mapping, this.converterLookup, this.compassMetaData, this.propertyNamingStrategy, this.executorManager, copySettings, true);
    }

    public String getName() {
        return this.name;
    }

    public ResourceFactory getResourceFactory() {
        return this.searchEngineFactory.getResourceFactory();
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public CompassEventManager getEventManager() {
        return this.eventManager;
    }

    public CompassSession openSession() {
        return this.openSession(true);
    }

    public CompassSession openSession(boolean allowCreate) {
        return this.openSession(allowCreate, true);
    }

    public CompassSession openSession(boolean allowCreate, boolean checkClosed) {
        CompassSession session;
        if (checkClosed) {
            this.checkClosed();
        }
        if ((session = this.transactionFactory.getTransactionBoundSession()) != null) {
            return session;
        }
        if (!allowCreate) {
            return null;
        }
        FirstLevelCache firstLevelCache = this.firstLevelCacheFactory.createFirstLevelCache();
        RuntimeCompassSettings runtimeSettings = new RuntimeCompassSettings(this.getSettings());
        return new DefaultCompassSession(runtimeSettings, this, this.searchEngineFactory.openSearchEngine(runtimeSettings), firstLevelCache);
    }

    public void start() {
        this.searchEngineFactory.start();
    }

    public void stop() {
        this.searchEngineFactory.stop();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        log.info((Object)("Closing Compass [" + this.name + "]"));
        if (this.settings.getSettingAsBoolean("compass.jndi.enable", false) && !this.duplicate) {
            CompassObjectFactory.removeInstance(this.uuid, this.name, this.settings);
        }
        this.searchEngineFactory.close();
        if (!this.duplicate) {
            this.executorManager.close();
        }
        log.info((Object)("Closed Compass [" + this.name + "]"));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Reference getReference() throws NamingException {
        return new Reference(DefaultCompass.class.getName(), new StringRefAddr("uuid", this.uuid), CompassObjectFactory.class.getName(), null);
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public SearchEngineOptimizer getSearchEngineOptimizer() {
        return this.searchEngineFactory.getOptimizer();
    }

    public SearchEngineIndexManager getSearchEngineIndexManager() {
        return this.searchEngineFactory.getIndexManager();
    }

    public SearchEngineSpellCheckManager getSpellCheckManager() {
        return this.searchEngineFactory.getSpellCheckManager();
    }

    public SearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public CompassMetaData getMetaData() {
        return this.compassMetaData;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public LocalTransactionFactory getLocalTransactionFactory() {
        return this.localTransactionFactory;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    private void registerJndi() throws CompassException {
        if (!this.settings.getSettingAsBoolean("compass.jndi.enable", false)) {
            return;
        }
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate());
        }
        catch (Exception e) {
            throw new CompassException("Could not generate UUID for JNDI binding");
        }
        CompassObjectFactory.addInstance(this.uuid, this.name, this, this.settings);
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Compass already closed");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompassTransactionContext
    implements TransactionContext {
        private InternalCompass compass;

        public CompassTransactionContext(InternalCompass compass) {
            this.compass = compass;
        }

        @Override
        public <T> T execute(TransactionContextCallback<T> callback) throws TransactionException {
            if (!this.compass.getSearchEngineIndexManager().requiresAsyncTransactionalContext()) {
                return callback.doInTransaction();
            }
            CompassSession session = this.compass.openSession(true, false);
            CompassTransaction tx = null;
            try {
                tx = session.beginTransaction();
                T result = callback.doInTransaction();
                tx.commit();
                T t = result;
                return t;
            }
            catch (RuntimeException e) {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception e1) {
                        log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                    }
                }
                throw e;
            }
            catch (Error err) {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception e1) {
                        log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                    }
                }
                throw err;
            }
            finally {
                session.close();
            }
        }

        @Override
        public <T> T execute(TransactionContextCallbackWithTr<T> callback) throws TransactionException {
            CompassSession session = this.compass.openSession(true, false);
            CompassTransaction tx = null;
            try {
                tx = session.beginTransaction();
                T result = callback.doInTransaction((InternalCompassTransaction)tx);
                tx.commit();
                T t = result;
                return t;
            }
            catch (RuntimeException e) {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception e1) {
                        log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                    }
                }
                throw e;
            }
            catch (Error err) {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception e1) {
                        log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                    }
                }
                throw err;
            }
            finally {
                session.close();
            }
        }
    }
}

