/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.xsem;

import java.io.Reader;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlContentMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlConverterUtils;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.MultiResource;
import org.compass.core.xml.RawXmlObject;
import org.compass.core.xml.XmlObject;

public class XmlObjectMappingConverter
implements ResourceMappingConverter {
    private Map<String, String> namespace;

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        this.extractNamespace(context);
        if (root == null && !context.handleNulls()) {
            return false;
        }
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        XmlObject rootXmlObject = (XmlObject)root;
        rootXmlObject = this.getActualXmlObject(rootXmlObject, xmlObjectMapping, context, resource);
        rootXmlObject.setNamespaces(this.namespace);
        if (xmlObjectMapping.getXPath() != null) {
            XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
            if (xmlObjects == null || xmlObjects.length == 0) {
                throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
            }
            boolean store = false;
            MultiResource multiResource = (MultiResource)resource;
            multiResource.clear();
            for (XmlObject xmlObject : xmlObjects) {
                multiResource.addResource();
                Iterator<Mapping> it = xmlObjectMapping.mappingsIt();
                while (it.hasNext()) {
                    Mapping m = it.next();
                    InternalResource resource1 = (InternalResource)multiResource.currentResource();
                    store |= m.getConverter().marshall(resource1, xmlObject, m, context);
                    resource1.addUID();
                }
            }
            return store;
        }
        boolean store = false;
        Iterator<Mapping> it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            store |= m.getConverter().marshall(resource, rootXmlObject, m, context);
        }
        ((InternalResource)resource).addUID();
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        this.extractNamespace(context);
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        if (xmlObjectMapping.getXmlContentMapping() == null) {
            return null;
        }
        XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
        XmlObject xmlObject = (XmlObject)xmlContentMapping.getConverter().unmarshall(resource, xmlContentMapping, context);
        xmlObject.setNamespaces(this.namespace);
        return xmlObject;
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        this.extractNamespace(context);
        ResourceFactory resourceFactory = context.getResourceFactory();
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)resourceMapping;
        Mapping[] ids = resourceMapping.getIdMappings();
        if (id instanceof XmlObject) {
            XmlObject rootXmlObject = this.getActualXmlObject((XmlObject)id, xmlObjectMapping, context, idResource);
            rootXmlObject.setNamespaces(this.namespace);
            if (xmlObjectMapping.getXPath() != null) {
                XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
                if (xmlObjects == null || xmlObjects.length == 0) {
                    throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
                }
                MultiResource multiResource = (MultiResource)idResource;
                multiResource.clear();
                for (XmlObject xmlObject : xmlObjects) {
                    multiResource.addResource();
                    for (Mapping id1 : ids) {
                        id1.getConverter().marshall(multiResource.currentResource(), xmlObject, id1, context);
                    }
                }
            } else {
                for (Mapping id1 : ids) {
                    id1.getConverter().marshall(idResource, rootXmlObject, id1, context);
                }
            }
        } else if (id instanceof Resource) {
            for (Mapping id1 : ids) {
                Resource rId = (Resource)id;
                idResource.addProperty(rId.getProperty(id1.getPath().getPath()));
            }
        } else if (id instanceof Object[]) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load resource with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            if (Property.class.isAssignableFrom(id.getClass().getComponentType())) {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty((Property)Array.get(id, i));
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty(resourceFactory.createProperty(ids[i].getPath().getPath(), Array.get(id, i).toString(), Property.Store.YES, Property.Index.NOT_ANALYZED));
                }
            }
        } else {
            if (ids.length != 1) {
                throw new ConversionException("Trying to load resource which has more than one id mappings with only one id value");
            }
            if (id instanceof Property) {
                idResource.addProperty((Property)id);
            } else {
                idResource.addProperty(resourceFactory.createProperty(ids[0].getPath().getPath(), id.toString(), Property.Store.YES, Property.Index.NOT_ANALYZED));
            }
        }
        ((InternalResource)idResource).addUID();
        return true;
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported, please use xml-content mapping");
    }

    private XmlObject getActualXmlObject(XmlObject rootXmlObject, XmlObjectMapping xmlObjectMapping, MarshallingContext context, Resource resource) {
        if (rootXmlObject instanceof RawXmlObject) {
            Reader xml = ((RawXmlObject)rootXmlObject).getXml();
            XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
            XmlContentMappingConverter xmlContentMappingConverter = xmlContentMapping != null ? (XmlContentMappingConverter)xmlContentMapping.getConverter() : (XmlContentMappingConverter)context.getConverterLookup().lookupConverter("xmlContentMapping");
            rootXmlObject = xmlContentMappingConverter.getXmlContentConverter().fromXml(resource.getAlias(), xml);
        }
        return rootXmlObject;
    }

    private void extractNamespace(MarshallingContext context) throws CompassException {
        if (this.namespace != null) {
            return;
        }
        this.namespace = new HashMap<String, String>();
        Map<String, CompassSettings> namespaceSettings = context.getSession().getSettings().getSettingGroups("compass.xsem.namespace");
        if (namespaceSettings != null && !namespaceSettings.isEmpty()) {
            for (Map.Entry<String, CompassSettings> entry : namespaceSettings.entrySet()) {
                this.namespace.put(entry.getKey(), entry.getValue().getSetting("uri"));
            }
        }
    }
}

