/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.cometd.client.transport.ClientTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientTransport
extends ClientTransport {
    private volatile String url;
    private volatile CookieProvider cookieProvider;

    protected HttpClientTransport(String name, Map<String, Object> options) {
        super(name, options);
    }

    protected String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    protected CookieProvider getCookieProvider() {
        return this.cookieProvider;
    }

    public void setCookieProvider(CookieProvider cookieProvider) {
        this.cookieProvider = cookieProvider;
    }

    protected Cookie getCookie(String name) {
        CookieProvider cookieProvider = this.cookieProvider;
        if (cookieProvider != null) {
            return cookieProvider.getCookie(name);
        }
        return null;
    }

    protected void setCookie(Cookie cookie) {
        CookieProvider cookieProvider = this.cookieProvider;
        if (cookieProvider != null) {
            cookieProvider.setCookie(cookie);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardCookieProvider
    implements CookieProvider {
        private final Map<String, Cookie> cookies = new ConcurrentHashMap<String, Cookie>();

        @Override
        public Cookie getCookie(String name) {
            Cookie cookie = this.cookies.get(name);
            if (!cookie.isExpired(System.currentTimeMillis())) {
                return cookie;
            }
            return null;
        }

        @Override
        public void setCookie(Cookie cookie) {
            this.cookies.put(cookie.getName(), cookie);
        }

        @Override
        public List<Cookie> getCookies() {
            ArrayList<Cookie> result = new ArrayList<Cookie>();
            for (String name : this.cookies.keySet()) {
                Cookie cookie = this.getCookie(name);
                if (cookie == null) continue;
                result.add(cookie);
            }
            return result;
        }

        @Override
        public void clear() {
            this.cookies.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CookieProvider {
        public Cookie getCookie(String var1);

        public List<Cookie> getCookies();

        public void setCookie(Cookie var1);

        public void clear();
    }

    public static class Cookie {
        private final String name;
        private final String value;
        private final String domain;
        private final String path;
        private final int maxAge;
        private final boolean secure;
        private final int version;
        private final String comment;
        private final long expirationTime;

        public Cookie(String name, String value, String domain, String path, int maxAge, boolean secure, int version, String comment) {
            this.name = name;
            this.value = value;
            this.domain = domain;
            this.path = path;
            this.maxAge = maxAge;
            this.secure = secure;
            this.version = version;
            this.comment = comment;
            this.expirationTime = maxAge < 0 ? -1L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxAge);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public int getVersion() {
            return this.version;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isExpired(long time) {
            return this.expirationTime >= 0L && time >= this.expirationTime;
        }

        public String asString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName()).append("=").append(this.getValue());
            if (this.getPath() != null) {
                builder.append(";$Path=").append(this.getPath());
            }
            if (this.getDomain() != null) {
                builder.append(";$Domain=").append(this.getDomain());
            }
            return builder.toString();
        }
    }
}

