/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.codenarc.analyzer.AbstractSourceAnalyzer;
import org.codenarc.results.DirectoryResults;
import org.codenarc.results.FileResults;
import org.codenarc.results.Results;
import org.codenarc.rule.Violation;
import org.codenarc.ruleset.RuleSet;
import org.codenarc.source.SourceFile;
import org.codenarc.util.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntFileSetSourceAnalyzer
extends AbstractSourceAnalyzer {
    private static final Logger LOG = Logger.getLogger(AntFileSetSourceAnalyzer.class);
    private static final int POOL_TIMEOUT_SECONDS = 3600;
    private final Project project;
    protected final List<FileSet> fileSets;
    private final ConcurrentMap<String, List<FileResults>> resultsMap = new ConcurrentHashMap<String, List<FileResults>>();
    private final ConcurrentMap<String, AtomicInteger> fileCountMap = new ConcurrentHashMap<String, AtomicInteger>();

    public AntFileSetSourceAnalyzer(Project project, FileSet fileSet) {
        if (fileSet == null) {
            throw new IllegalArgumentException("Null: fileSet");
        }
        if (project == null) {
            throw new IllegalArgumentException("Null: project");
        }
        this.project = project;
        this.fileSets = Arrays.asList(fileSet);
    }

    AntFileSetSourceAnalyzer(Project project, List<FileSet> fileSets) {
        if (fileSets == null) {
            throw new IllegalArgumentException("Null: fileSets");
        }
        if (project == null) {
            throw new IllegalArgumentException("Null: project");
        }
        this.project = project;
        this.fileSets = new ArrayList<FileSet>(fileSets);
    }

    @Override
    public Results analyze(RuleSet ruleSet) {
        long startTime = System.currentTimeMillis();
        DirectoryResults reportResults = new DirectoryResults();
        int numThreads = Runtime.getRuntime().availableProcessors() + 1;
        ExecutorService pool = Executors.newFixedThreadPool(numThreads);
        for (FileSet fileSet : this.fileSets) {
            this.processFileSet(fileSet, ruleSet, pool);
        }
        pool.shutdown();
        try {
            boolean completed = pool.awaitTermination(3600L, TimeUnit.SECONDS);
            if (!completed) {
                throw new IllegalStateException("Thread Pool terminated before comp<FileResults>letion");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread Pool interrupted before completion");
        }
        this.addDirectoryResults(reportResults);
        LOG.info((Object)("Analysis time=" + (System.currentTimeMillis() - startTime) + "ms"));
        return reportResults;
    }

    @Override
    public List getSourceDirectories() {
        String baseDir = this.project.getBaseDir().getAbsolutePath();
        ArrayList<String> result = new ArrayList<String>();
        for (FileSet fileSet : this.fileSets) {
            String path = fileSet.getDir(this.project).getPath();
            String trimmedPath = PathUtil.removePathPrefix(baseDir, path);
            result.add(trimmedPath);
        }
        return result;
    }

    private void processFileSet(FileSet fileSet, RuleSet ruleSet, ExecutorService pool) {
        DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.project);
        File baseDir = fileSet.getDir(this.project);
        String[] includedFiles = dirScanner.getIncludedFiles();
        if (includedFiles == null || includedFiles.length == 0) {
            LOG.info((Object)("No matching files found for FileSet with basedir [" + baseDir + "]"));
            return;
        }
        for (String filePath : includedFiles) {
            Runnable task = this.buildTask(baseDir, filePath, ruleSet);
            pool.submit(task);
        }
    }

    private Runnable buildTask(final File baseDir, final String filePath, final RuleSet ruleSet) {
        return new Runnable(){

            public void run() {
                try {
                    AntFileSetSourceAnalyzer.this.processFile(baseDir, filePath, ruleSet);
                }
                catch (Throwable t) {
                    LOG.info((Object)("Error processing filePath: '" + filePath + "'"), t);
                }
            }
        };
    }

    private void processFile(File baseDir, String filePath, RuleSet ruleSet) {
        String parentPath;
        File file = new File(baseDir, filePath);
        SourceFile sourceFile = new SourceFile(file);
        List<Violation> allViolations = this.collectViolations(sourceFile, ruleSet);
        FileResults fileResults = null;
        if (allViolations != null && !allViolations.isEmpty()) {
            fileResults = new FileResults(PathUtil.normalizePath(filePath), allViolations);
        }
        String safeParentPath = (parentPath = PathUtil.getParentPath(filePath)) != null ? parentPath : "";
        this.addToResultsMap(safeParentPath, fileResults);
        this.incrementFileCount(safeParentPath);
    }

    private void incrementFileCount(String parentPath) {
        AtomicInteger initialZeroCount = new AtomicInteger(0);
        this.fileCountMap.putIfAbsent(parentPath, initialZeroCount);
        AtomicInteger fileCount = (AtomicInteger)this.fileCountMap.get(parentPath);
        fileCount.incrementAndGet();
    }

    private void addToResultsMap(String parentPath, FileResults results) {
        List initialEmptyResults = Collections.synchronizedList(new ArrayList());
        this.resultsMap.putIfAbsent(parentPath, initialEmptyResults);
        if (results != null) {
            List dirResults = (List)this.resultsMap.get(parentPath);
            dirResults.add(results);
        }
    }

    private void addToParentResults(DirectoryResults reportResults, Results results) {
        String parentPath = PathUtil.getParentPath(results.getPath());
        if (parentPath == null) {
            reportResults.addChild(results);
            return;
        }
        DirectoryResults parent = (DirectoryResults)reportResults.findResultsForPath(parentPath);
        if (parent == null) {
            parent = new DirectoryResults(parentPath);
            this.addToParentResults(reportResults, parent);
        }
        parent.addChild(results);
    }

    private void addDirectoryResults(DirectoryResults reportResults) {
        Set set = this.resultsMap.keySet();
        ArrayList allPaths = new ArrayList(set);
        Collections.sort(allPaths);
        for (String path : allPaths) {
            DirectoryResults dirResults = new DirectoryResults(path);
            List allResults = (List)this.resultsMap.get(path);
            Collections.sort(allResults, new Comparator<FileResults>(){

                @Override
                public int compare(FileResults o1, FileResults o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            for (FileResults child : allResults) {
                dirResults.addChild(child);
            }
            AtomicInteger cnt = (AtomicInteger)this.fileCountMap.get(path);
            dirResults.setNumberOfFilesInThisDirectory(cnt != null ? cnt.get() : 0);
            this.addToParentResults(reportResults, dirResults);
        }
    }
}

