/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.ResourceSearchResult;

public class ResourceSearchQuery
extends Query<ResourceSearchResult> {
    private int page = -1;
    private int pageSize = -1;
    private String[] qualifiers = null;
    private String text;

    private ResourceSearchQuery() {
    }

    public static ResourceSearchQuery create(String text) {
        return new ResourceSearchQuery().setText(text);
    }

    public int getPage() {
        return this.page;
    }

    public ResourceSearchQuery setPage(int page) {
        this.page = page;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ResourceSearchQuery setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    public ResourceSearchQuery setQualifiers(String ... qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public ResourceSearchQuery setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/resources/search?");
        ResourceSearchQuery.appendUrlParameter(url, "s", this.text);
        if (this.page > 0) {
            ResourceSearchQuery.appendUrlParameter(url, "p", this.page);
        }
        if (this.pageSize > 0) {
            ResourceSearchQuery.appendUrlParameter(url, "ps", this.pageSize);
        }
        ResourceSearchQuery.appendUrlParameter(url, "q", this.qualifiers);
        return url.toString();
    }

    @Override
    public Class<ResourceSearchResult> getModelClass() {
        return ResourceSearchResult.class;
    }
}

