/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceQuery
extends Query<Resource> {
    public static final String BASE_URL = "/api/resources";
    public static final int DEPTH_UNLIMITED = -1;
    private Integer depth;
    private String resourceKeyOrId;
    private Integer limit;
    private String[] scopes;
    private String[] qualifiers;
    private String[] metrics;
    private String[] rules;
    private String[] ruleSeverities;
    private String[] characteristicKeys;
    private String model;
    private boolean excludeRules = true;
    private boolean excludeRuleSeverities = true;
    private Boolean includeTrends = null;
    private Boolean verbose = Boolean.FALSE;

    public ResourceQuery() {
    }

    public ResourceQuery(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public ResourceQuery(long resourceId) {
        this.resourceKeyOrId = String.valueOf(resourceId);
    }

    public Integer getDepth() {
        return this.depth;
    }

    public ResourceQuery setDepth(Integer depth) {
        this.depth = depth;
        return this;
    }

    public ResourceQuery setAllDepths() {
        return this.setDepth(-1);
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public ResourceQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    public ResourceQuery setResourceId(int resourceId) {
        this.resourceKeyOrId = Integer.toString(resourceId);
        return this;
    }

    public ResourceQuery setCharacteristicKeys(String model, String ... keys) {
        this.model = model;
        this.characteristicKeys = keys;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ResourceQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public ResourceQuery setScopes(String ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    public ResourceQuery setQualifiers(String ... qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public ResourceQuery setMetrics(String ... metrics) {
        this.metrics = metrics;
        return this;
    }

    public String[] getRules() {
        return this.rules;
    }

    public ResourceQuery setRules(String ... rules) {
        this.rules = rules;
        this.excludeRules = false;
        return this;
    }

    @Deprecated
    public String[] getRuleCategories() {
        return null;
    }

    @Deprecated
    public ResourceQuery setRuleCategories(String ... ruleCategories) {
        return this;
    }

    public String[] getRuleSeverities() {
        return this.ruleSeverities;
    }

    public ResourceQuery setRuleSeverities(String ... ruleSeverities) {
        this.ruleSeverities = ruleSeverities;
        this.excludeRuleSeverities = false;
        return this;
    }

    @Deprecated
    public String[] getRulePriorities() {
        return this.ruleSeverities;
    }

    @Deprecated
    public ResourceQuery setRulePriorities(String ... rulePriorities) {
        return this.setRuleSeverities(rulePriorities);
    }

    public boolean isExcludeRules() {
        return this.excludeRules;
    }

    public ResourceQuery setExcludeRules(boolean excludeRules) {
        this.excludeRules = excludeRules;
        return this;
    }

    @Deprecated
    public boolean isExcludeRuleCategories() {
        return false;
    }

    @Deprecated
    public ResourceQuery setExcludeRuleCategories(boolean b) {
        return this;
    }

    public boolean isExcludeRuleSeverities() {
        return this.excludeRuleSeverities;
    }

    public ResourceQuery setExcludeRuleSeverities(boolean excludeRuleSeverities) {
        this.excludeRuleSeverities = excludeRuleSeverities;
        return this;
    }

    @Deprecated
    public boolean isExcludeRulePriorities() {
        return this.excludeRuleSeverities;
    }

    @Deprecated
    public ResourceQuery setExcludeRulePriorities(boolean b) {
        this.excludeRuleSeverities = b;
        return this;
    }

    public Boolean isVerbose() {
        return this.verbose;
    }

    public ResourceQuery setVerbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Boolean isIncludeTrends() {
        return this.includeTrends;
    }

    public ResourceQuery setIncludeTrends(Boolean includeTrends) {
        this.includeTrends = includeTrends;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        ResourceQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        ResourceQuery.appendUrlParameter(url, "metrics", this.metrics);
        ResourceQuery.appendUrlParameter(url, "scopes", this.scopes);
        ResourceQuery.appendUrlParameter(url, "qualifiers", this.qualifiers);
        ResourceQuery.appendUrlParameter(url, "depth", this.depth);
        ResourceQuery.appendUrlParameter(url, "limit", this.limit);
        this.appendRuleField(url, "rules", this.excludeRules, this.rules);
        this.appendRuleField(url, "rule_priorities", this.excludeRuleSeverities, this.ruleSeverities);
        ResourceQuery.appendUrlParameter(url, "includetrends", this.includeTrends);
        ResourceQuery.appendUrlParameter(url, "model", this.model);
        ResourceQuery.appendUrlParameter(url, "characteristics", this.characteristicKeys);
        ResourceQuery.appendUrlParameter(url, "verbose", this.verbose);
        return url.toString();
    }

    private void appendRuleField(StringBuilder url, String field, boolean excludeField, String[] list) {
        if (!excludeField) {
            if (list == null || list.length == 0) {
                ResourceQuery.appendUrlParameter(url, field, true);
            } else {
                ResourceQuery.appendUrlParameter(url, field, list);
            }
        }
    }

    @Override
    public final Class<Resource> getModelClass() {
        return Resource.class;
    }

    public static ResourceQuery createForMetrics(String resourceKeyOrId, String ... metricKeys) {
        return new ResourceQuery(resourceKeyOrId).setMetrics(metricKeys);
    }

    public static ResourceQuery createForResource(Resource resource, String ... metricKeys) {
        return new ResourceQuery(resource.getId().toString()).setMetrics(metricKeys);
    }

    public static ResourceQuery create(String resourceKey) {
        return new ResourceQuery(resourceKey);
    }
}

