/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.CloneIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCloneIndex
implements CloneIndex {
    private final TreeMultimap<String, Block> filenameIndex = TreeMultimap.create((Comparator)new KeyComparator(), (Comparator)new ValueComparator());
    private final HashMultimap<ByteArray, Block> sequenceHashIndex = HashMultimap.create();

    public Collection<String> getAllUniqueResourceId() {
        return this.filenameIndex.keySet();
    }

    public boolean containsResourceId(String resourceId) {
        return this.filenameIndex.containsKey((Object)resourceId);
    }

    @Override
    public Collection<Block> getByResourceId(String fileName) {
        return this.filenameIndex.get((Object)fileName);
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        return this.sequenceHashIndex.get((Object)sequenceHash);
    }

    @Override
    public void insert(Block tuple) {
        this.filenameIndex.put((Object)tuple.getResourceId(), (Object)tuple);
        this.sequenceHashIndex.put((Object)tuple.getBlockHash(), (Object)tuple);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8705841881237170539L;

        private KeyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueComparator
    implements Comparator<Block>,
    Serializable {
        private static final long serialVersionUID = 6048010242032502222L;

        private ValueComparator() {
        }

        @Override
        public int compare(Block o1, Block o2) {
            if (o2.getResourceId().equals(o1.getResourceId())) {
                return o1.getIndexInFile() - o2.getIndexInFile();
            }
            return o1.getResourceId().compareTo(o2.getResourceId());
        }
    }
}

