/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.config;

import java.util.List;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.database.configuration.Property;
import org.sonar.batch.config.BatchSettings;
import org.sonar.core.config.ConfigurationUtils;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchSettingsEnhancer {
    private DatabaseSessionFactory dbFactory;
    private BatchSettings settings;
    private ProjectReactor reactor;

    public BatchSettingsEnhancer(DatabaseSessionFactory dbFactory, BatchSettings settings, ProjectReactor reactor) {
        this.dbFactory = dbFactory;
        this.settings = settings;
        this.reactor = reactor;
    }

    public void start() {
        String projectKey = this.reactor.getRoot().getKey();
        this.setIfNotDefined(ConfigurationUtils.getProjectProperties((DatabaseSessionFactory)this.dbFactory, (String)projectKey));
        this.setIfNotDefined(ConfigurationUtils.getGeneralProperties((DatabaseSessionFactory)this.dbFactory));
        this.settings.updateDeprecatedCommonsConfiguration();
    }

    private void setIfNotDefined(List<Property> dbProperties) {
        for (Property dbProperty : dbProperties) {
            if (this.settings.hasKey(dbProperty.getKey())) continue;
            this.settings.setProperty(dbProperty.getKey(), dbProperty.getValue());
        }
    }
}

